/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.quinoa.deployment.config;

import io.quarkus.runtime.annotations.ConfigDocDefault;
import io.quarkus.runtime.annotations.ConfigGroup;
import io.smallrye.config.WithDefault;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@ConfigGroup
public interface PackageManagerCommandConfig {
    public static final String DEFAULT_DEV_SCRIPT_NAME = "start";
    public static final String DEFAULT_DEV_COMMAND = "run start";
    public static final String DEFAULT_INSTALL_COMMAND = "install";
    public static final String DEFAULT_BUILD_COMMAND = "run build";
    public static final String DEFAULT_TEST_COMMAND = "run test";
    public static final String DEFAULT_PUBLISH_COMMAND = "run publish";

    @ConfigDocDefault(value="install")
    public Optional<String> install();

    public Map<String, String> installEnv();

    @ConfigDocDefault(value="Detected based on package manager")
    public Optional<String> ci();

    public Map<String, String> ciEnv();

    @WithDefault(value="run build")
    public Optional<String> build();

    public Map<String, String> buildEnv();

    @ConfigDocDefault(value="run test")
    public Optional<String> test();

    @ConfigDocDefault(value="CI=true")
    public Map<String, String> testEnv();

    @ConfigDocDefault(value="framework detection with fallback to 'start'")
    public Optional<String> dev();

    public Map<String, String> devEnv();

    @WithDefault(value="run publish")
    public Optional<String> publish();

    public Map<String, String> publishEnv();

    public static boolean isEqual(PackageManagerCommandConfig p1, PackageManagerCommandConfig p2) {
        if (!Objects.equals(p1.install(), p2.install())) {
            return false;
        }
        if (!Objects.equals(p1.installEnv(), p2.installEnv())) {
            return false;
        }
        if (!Objects.equals(p1.ci(), p2.ci())) {
            return false;
        }
        if (!Objects.equals(p1.ciEnv(), p2.ciEnv())) {
            return false;
        }
        if (!Objects.equals(p1.buildEnv(), p2.buildEnv())) {
            return false;
        }
        if (!Objects.equals(p1.testEnv(), p2.testEnv())) {
            return false;
        }
        if (!Objects.equals(p1.dev(), p2.dev())) {
            return false;
        }
        if (!Objects.equals(p1.devEnv(), p2.devEnv())) {
            return false;
        }
        if (!Objects.equals(p1.publish(), p2.publish())) {
            return false;
        }
        return Objects.equals(p1.publishEnv(), p2.publishEnv());
    }
}

