/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.quinoa.deployment.framework.override;

import io.quarkiverse.quinoa.deployment.config.DevServerConfig;
import io.quarkiverse.quinoa.deployment.config.QuinoaConfig;
import io.quarkiverse.quinoa.deployment.config.delegate.DevServerConfigDelegate;
import io.quarkiverse.quinoa.deployment.config.delegate.QuinoaConfigDelegate;
import io.quarkiverse.quinoa.deployment.framework.override.GenericFramework;
import jakarta.json.JsonObject;
import java.nio.file.Path;
import java.util.Optional;
import org.jboss.logging.Logger;

public class NextFramework
extends GenericFramework {
    private static final Logger LOG = Logger.getLogger(NextFramework.class);
    private static final String EXPECTED_OUTPUT_VALUE = "export";

    public NextFramework() {
        super("out", "dev", 3000);
    }

    @Override
    public QuinoaConfig override(QuinoaConfig delegate, Optional<JsonObject> packageJson, Optional<String> detectedDevScript, boolean isCustomized, Path uiDir) {
        JsonObject scripts;
        LOG.warn((Object)"Next.js version 13 and above are not fully supported yet. Please make sure to use version 12 or below.");
        if (delegate.packageManagerCommand().build().orElse("???").equals("run build") && packageJson.isPresent() && (scripts = packageJson.get().getJsonObject("scripts")) != null) {
            String output;
            String buildScript = scripts.getString("build");
            if (buildScript == null || buildScript.isEmpty()) {
                LOG.warn((Object)"Make sure you define  \"build\": \"next build \", in the package.json to make Next work with Quinoa.");
            }
            if (!EXPECTED_OUTPUT_VALUE.equals(output = packageJson.get().getString("output", null))) {
                LOG.warn((Object)"Make sure you define  \"output\": \"export \", in the package.json to make Next work with Quinoa.");
            }
        }
        return new QuinoaConfigDelegate(super.override(delegate, packageJson, detectedDevScript, isCustomized, uiDir)){

            @Override
            public DevServerConfig devServer() {
                return new DevServerConfigDelegate(super.devServer()){

                    @Override
                    public Optional<String> indexPage() {
                        return Optional.of(super.indexPage().orElse("/"));
                    }
                };
            }
        };
    }
}

