/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.quinoa.deployment.framework.override;

import io.quarkiverse.quinoa.deployment.config.PackageManagerCommandConfig;
import io.quarkiverse.quinoa.deployment.config.QuinoaConfig;
import io.quarkiverse.quinoa.deployment.config.delegate.PackageManagerCommandConfigDelegate;
import io.quarkiverse.quinoa.deployment.config.delegate.QuinoaConfigDelegate;
import io.quarkiverse.quinoa.deployment.framework.override.GenericFramework;
import jakarta.json.Json;
import jakarta.json.JsonException;
import jakarta.json.JsonObject;
import jakarta.json.JsonReader;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Optional;

public class AngularFramework
extends GenericFramework {
    public static final String ANGULAR_DEVKIT_BUILD_ANGULAR_APPLICATION = "@angular-devkit/build-angular:application";
    public static final String ANGULAR_JSON_FILE = "angular.json";

    public AngularFramework() {
        super("dist", "start", 4200);
    }

    @Override
    public QuinoaConfig override(final QuinoaConfig originalConfig, Optional<JsonObject> packageJson, Optional<String> detectedDevScript, final boolean isCustomized, final Path uiDir) {
        final String devScript = detectedDevScript.orElse(this.getDefaultDevScriptName());
        return new QuinoaConfigDelegate(super.override(originalConfig, packageJson, detectedDevScript, isCustomized, uiDir)){

            @Override
            public Optional<String> buildDir() {
                return Optional.of(originalConfig.buildDir().orElseGet(() -> {
                    JsonObject angularJson = 1.readAngularJson(uiDir);
                    JsonObject projectList = angularJson.getJsonObject("projects");
                    JsonObject builder = projectList.values().stream().map(JsonValue::asJsonObject).filter(project -> "application".equals(project.getString("projectType"))).findFirst().orElseThrow(() -> new RuntimeException("Quinoa failed to determine which application must be started in the angular.json file.")).getJsonObject("architect").getJsonObject("build");
                    return AngularFramework.getBuildDir(builder);
                }));
            }

            private static JsonObject readAngularJson(Path uiDir2) {
                JsonObject jsonObject;
                block8: {
                    JsonReader reader = Json.createReader((InputStream)Files.newInputStream(uiDir2.resolve(AngularFramework.ANGULAR_JSON_FILE), new OpenOption[0]));
                    try {
                        jsonObject = reader.readObject();
                        if (reader == null) break block8;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (reader != null) {
                                try {
                                    reader.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (JsonException | IOException e) {
                            throw new RuntimeException("Quinoa failed to read the angular.json file.", e);
                        }
                    }
                    reader.close();
                }
                return jsonObject;
            }

            @Override
            public PackageManagerCommandConfig packageManagerCommand() {
                return new PackageManagerCommandConfigDelegate(super.packageManagerCommand()){

                    @Override
                    public Optional<String> dev() {
                        String extraArgs = isCustomized ? "" : " -- --host=0.0.0.0 --hmr";
                        return Optional.of(originalConfig.packageManagerCommand().dev().orElse("run " + devScript + extraArgs));
                    }

                    @Override
                    public Optional<String> test() {
                        String extraArgs = isCustomized ? "" : " -- --no-watch --no-progress --browsers=ChromeHeadlessCI";
                        return Optional.of(originalConfig.packageManagerCommand().test().orElse("run test" + extraArgs));
                    }
                };
            }
        };
    }

    static String getBuildDir(JsonObject build) {
        String builderName = build.getString("builder");
        JsonValue outputPath = (JsonValue)build.getJsonObject("options").get((Object)"outputPath");
        if (outputPath instanceof JsonString) {
            JsonString outputPathStr = (JsonString)outputPath;
            String fullBuildDir = outputPathStr.getString();
            if (ANGULAR_DEVKIT_BUILD_ANGULAR_APPLICATION.equals(builderName)) {
                fullBuildDir = String.format("%s/browser", fullBuildDir);
            }
            return fullBuildDir;
        }
        if (outputPath instanceof JsonObject) {
            JsonObject outputPathObj = (JsonObject)outputPath;
            return String.format("%s/%s", outputPathObj.getString("base"), outputPathObj.getString("browser", "browser"));
        }
        throw new RuntimeException("Unexpected type of outputPath in the angular.json file.");
    }
}

