/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.quinoa.deployment.config;

import io.quarkus.runtime.annotations.ConfigDocDefault;
import io.quarkus.runtime.annotations.ConfigGroup;
import io.smallrye.config.WithDefault;
import io.smallrye.config.WithParentName;
import java.util.Objects;
import java.util.Optional;

@ConfigGroup
public interface DevServerConfig {
    @WithParentName
    @WithDefault(value="true")
    public boolean enabled();

    @WithDefault(value="true")
    public boolean managed();

    @ConfigDocDefault(value="framework detection or fallback to empty")
    public Optional<Integer> port();

    @WithDefault(value="localhost")
    public String host();

    @WithDefault(value="false")
    public boolean tls();

    @WithDefault(value="false")
    public boolean tlsAllowInsecure();

    @WithDefault(value="/")
    public Optional<String> checkPath();

    @WithDefault(value="true")
    public boolean websocket();

    @WithDefault(value="30000")
    public int checkTimeout();

    @WithDefault(value="false")
    public boolean logs();

    @ConfigDocDefault(value="auto-detected falling back to index.html")
    public Optional<String> indexPage();

    @WithDefault(value="false")
    public boolean directForwarding();

    public static boolean isEqual(DevServerConfig d1, DevServerConfig d2) {
        if (!Objects.equals(d1.enabled(), d2.enabled())) {
            return false;
        }
        if (!Objects.equals(d1.managed(), d2.managed())) {
            return false;
        }
        if (!Objects.equals(d1.port(), d2.port())) {
            return false;
        }
        if (!Objects.equals(d1.host(), d2.host())) {
            return false;
        }
        if (!Objects.equals(d1.tls(), d2.tls())) {
            return false;
        }
        if (!Objects.equals(d1.tlsAllowInsecure(), d2.tlsAllowInsecure())) {
            return false;
        }
        if (!Objects.equals(d1.checkPath(), d2.checkPath())) {
            return false;
        }
        if (!Objects.equals(d1.websocket(), d2.websocket())) {
            return false;
        }
        if (!Objects.equals(d1.checkTimeout(), d2.checkTimeout())) {
            return false;
        }
        if (!Objects.equals(d1.logs(), d2.logs())) {
            return false;
        }
        if (!Objects.equals(d1.indexPage(), d2.indexPage())) {
            return false;
        }
        return Objects.equals(d1.directForwarding(), d2.directForwarding());
    }
}

