/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.quinoa.deployment.config;

import io.quarkiverse.quinoa.deployment.config.PackageManagerInstallAuthConfig;
import io.quarkus.runtime.annotations.ConfigDocDefault;
import io.quarkus.runtime.annotations.ConfigGroup;
import io.smallrye.config.WithDefault;
import io.smallrye.config.WithName;
import io.smallrye.config.WithParentName;
import java.util.Objects;
import java.util.Optional;

@ConfigGroup
public interface PackageManagerInstallConfig {
    public static final String NPM_PROVIDED = "provided";
    public static final String DEFAULT_INSTALL_DIR = ".quinoa/";

    @WithParentName
    @WithDefault(value="false")
    public boolean enabled();

    @WithDefault(value=".quinoa/")
    public String installDir();

    public Optional<String> nodeVersion();

    @WithDefault(value="provided")
    @ConfigDocDefault(value="'provided' means it will use the NPM embedded in NodeJS")
    public String npmVersion();

    @WithDefault(value="https://registry.npmjs.org/npm/-/")
    public String npmDownloadRoot();

    @WithDefault(value="https://nodejs.org/dist/")
    public String nodeDownloadRoot();

    public Optional<String> yarnVersion();

    @WithDefault(value="https://github.com/yarnpkg/yarn/releases/download/")
    public String yarnDownloadRoot();

    public Optional<String> pnpmVersion();

    @WithDefault(value="https://registry.npmjs.org/pnpm/-/")
    public String pnpmDownloadRoot();

    @WithName(value="basic-auth")
    public PackageManagerInstallAuthConfig packageManagerInstallAuth();

    public static boolean isEqual(PackageManagerInstallConfig p1, PackageManagerInstallConfig p2) {
        if (!Objects.equals(p1.enabled(), p2.enabled())) {
            return false;
        }
        if (!Objects.equals(p1.installDir(), p2.installDir())) {
            return false;
        }
        if (!Objects.equals(p1.enabled(), p2.enabled())) {
            return false;
        }
        if (!Objects.equals(p1.nodeVersion(), p2.nodeVersion())) {
            return false;
        }
        if (!Objects.equals(p1.npmVersion(), p2.npmVersion())) {
            return false;
        }
        if (!Objects.equals(p1.npmDownloadRoot(), p2.npmDownloadRoot())) {
            return false;
        }
        if (!Objects.equals(p1.nodeDownloadRoot(), p2.nodeDownloadRoot())) {
            return false;
        }
        if (!Objects.equals(p1.yarnVersion(), p2.yarnVersion())) {
            return false;
        }
        if (!Objects.equals(p1.pnpmVersion(), p2.pnpmVersion())) {
            return false;
        }
        if (!Objects.equals(p1.pnpmDownloadRoot(), p2.pnpmDownloadRoot())) {
            return false;
        }
        return PackageManagerInstallAuthConfig.isEqual(p1.packageManagerInstallAuth(), p2.packageManagerInstallAuth());
    }
}

