/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.quinoa.deployment.packagemanager.types;

import io.quarkiverse.quinoa.deployment.config.PackageManagerCommandConfig;
import io.quarkiverse.quinoa.deployment.packagemanager.PackageManagerRunner;
import io.quarkiverse.quinoa.deployment.packagemanager.types.PackageManager;
import io.quarkiverse.quinoa.deployment.packagemanager.types.PackageManagerType;
import io.quarkus.runtime.LaunchMode;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class ConfiguredPackageManager
implements PackageManager {
    private static final String PATH_ENV_VAR = "PATH";
    private final PackageManagerType type;
    private final String binary;
    private final PackageManagerCommandConfig commandsConfig;
    private final List<String> paths;

    ConfiguredPackageManager(PackageManagerType type, String binary, PackageManagerCommandConfig commandsConfig, List<String> paths) {
        this.type = type;
        this.binary = binary;
        this.commandsConfig = commandsConfig;
        this.paths = paths;
    }

    @Override
    public PackageManager.Command ci() {
        return new PackageManager.Command(this.environment(Map.of(), this.commandsConfig.ciEnv()), this.prepareCommandWithArguments(this.commandsConfig.ci().orElse(this.type.ciCommand())));
    }

    @Override
    public PackageManager.Command install() {
        return new PackageManager.Command(this.environment(Map.of(), this.commandsConfig.installEnv()), this.prepareCommandWithArguments(this.commandsConfig.install().orElse("install")));
    }

    @Override
    public String binary() {
        return this.binary;
    }

    @Override
    public PackageManager.Command build(LaunchMode mode) {
        Map<String, String> env = Map.of("MODE", mode.getDefaultProfile(), "NODE_ENV", mode.equals((Object)LaunchMode.DEVELOPMENT) ? "development" : "production");
        return new PackageManager.Command(this.environment(env, this.commandsConfig.buildEnv()), this.prepareCommandWithArguments(this.commandsConfig.build().orElse("run build")));
    }

    @Override
    public PackageManager.Command test() {
        HashMap<String, String> testEnv = new HashMap<String, String>(this.commandsConfig.testEnv());
        if (testEnv.isEmpty()) {
            testEnv.put("CI", "true");
        }
        return new PackageManager.Command(this.environment(Map.of(), testEnv), this.prepareCommandWithArguments(this.commandsConfig.test().orElse("run test")));
    }

    @Override
    public PackageManager.Command publish() {
        return new PackageManager.Command(this.environment(Map.of(), this.commandsConfig.publishEnv()), this.prepareCommandWithArguments(this.commandsConfig.publish().orElse("run publish")));
    }

    @Override
    public PackageManager.Command dev() {
        return new PackageManager.Command(this.environment(Map.of(), this.commandsConfig.devEnv()), this.prepareCommandWithArguments(this.commandsConfig.dev().orElseThrow()));
    }

    private String prepareCommandWithArguments(String command) {
        String c = command;
        if (PackageManagerType.PNPM.equals((Object)this.type)) {
            c = c.replace("-- ", "");
        }
        return String.format("%s %s", this.binary(), c);
    }

    private Map<String, String> environment(Map<String, String> configuredEnvs, Map<String, String> additionalEnvironment) {
        HashMap<String, String> environment = new HashMap<String, String>(System.getenv());
        if (configuredEnvs != null) {
            environment.putAll(configuredEnvs);
        }
        if (additionalEnvironment != null) {
            environment.putAll(additionalEnvironment);
        }
        if (PackageManagerRunner.isWindows()) {
            for (Map.Entry entry : environment.entrySet()) {
                String pathName = (String)entry.getKey();
                if (!PATH_ENV_VAR.equalsIgnoreCase(pathName)) continue;
                String pathValue = (String)entry.getValue();
                environment.put(pathName, this.extendPathVariable(pathValue, this.paths));
            }
        } else {
            String pathValue = (String)environment.get(PATH_ENV_VAR);
            environment.put(PATH_ENV_VAR, this.extendPathVariable(pathValue, this.paths));
        }
        return environment;
    }

    private String extendPathVariable(String existingValue, List<String> paths) {
        StringBuilder pathBuilder = new StringBuilder();
        for (String path : paths) {
            pathBuilder.append(path).append(File.pathSeparator);
        }
        if (existingValue != null) {
            pathBuilder.append(existingValue).append(File.pathSeparator);
        }
        return pathBuilder.toString();
    }
}

