/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.quinoa.deployment.packagemanager.types;

import io.quarkiverse.quinoa.deployment.config.PackageManagerCommandConfig;
import io.quarkiverse.quinoa.deployment.packagemanager.types.ConfiguredPackageManager;
import io.quarkiverse.quinoa.deployment.packagemanager.types.PackageManagerType;
import io.quarkus.runtime.LaunchMode;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public interface PackageManager {
    public Command ci();

    public Command install();

    public String binary();

    public Command build(LaunchMode var1);

    public Command test();

    public Command publish();

    public Command dev();

    public static PackageManager resolve(PackageManagerType type, String binary, PackageManagerCommandConfig packageManagerCommands, List<String> paths) {
        return PackageManager.configure(type, binary, packageManagerCommands, paths);
    }

    private static PackageManager configure(PackageManagerType type, String binary, PackageManagerCommandConfig commandsConfig, List<String> paths) {
        return new ConfiguredPackageManager(type, binary, commandsConfig, paths);
    }

    public static class Command {
        public final Map<String, String> envs;
        public final String commandWithArguments;

        Command(String commandWithArguments) {
            this.envs = Collections.emptyMap();
            this.commandWithArguments = commandWithArguments;
        }

        Command(Map<String, String> envs, String commandWithArguments) {
            this.envs = envs;
            this.commandWithArguments = commandWithArguments;
        }
    }
}

