/*
 * Decompiled with CFR 0.152.
 */
package com.github.eirslett.maven.plugins.frontend.lib;

import com.github.eirslett.maven.plugins.frontend.lib.ArchiveExtractor;
import com.github.eirslett.maven.plugins.frontend.lib.BunInstaller;
import com.github.eirslett.maven.plugins.frontend.lib.CacheResolver;
import com.github.eirslett.maven.plugins.frontend.lib.DefaultArchiveExtractor;
import com.github.eirslett.maven.plugins.frontend.lib.DefaultInstallConfig;
import com.github.eirslett.maven.plugins.frontend.lib.DirectoryCacheResolver;
import com.github.eirslett.maven.plugins.frontend.lib.FileDownloader;
import com.github.eirslett.maven.plugins.frontend.lib.InstallConfig;
import com.github.eirslett.maven.plugins.frontend.lib.InstallNodeExecutorConfig;
import com.github.eirslett.maven.plugins.frontend.lib.NPMInstaller;
import com.github.eirslett.maven.plugins.frontend.lib.NodeExecutorConfig;
import com.github.eirslett.maven.plugins.frontend.lib.NodeInstaller;
import com.github.eirslett.maven.plugins.frontend.lib.Platform;
import com.github.eirslett.maven.plugins.frontend.lib.PnpmInstaller;
import com.github.eirslett.maven.plugins.frontend.lib.VertxFileDownloader;
import com.github.eirslett.maven.plugins.frontend.lib.YarnInstaller;
import io.vertx.core.Vertx;
import java.nio.file.Path;

public class PackageManagerInstallFactory {
    private static final Platform defaultPlatform = Platform.guess();
    private final Path uiDir;
    private final Path installDir;
    private final CacheResolver cacheResolver;
    private final VertxFileDownloader fileDownloader;
    private final String userName;
    private final String password;

    public PackageManagerInstallFactory(Vertx vertx, Path uiDir, Path installDir, String userName, String password) {
        this.uiDir = uiDir;
        this.installDir = installDir;
        this.cacheResolver = PackageManagerInstallFactory.getDefaultCacheResolver(installDir);
        this.userName = userName;
        this.password = password;
        this.fileDownloader = new VertxFileDownloader(vertx);
    }

    public NodeInstaller getNodeInstaller() {
        NodeInstaller nodeInstaller = new NodeInstaller(this.getInstallConfig(), (ArchiveExtractor)new DefaultArchiveExtractor(), (FileDownloader)this.fileDownloader);
        nodeInstaller.setUserName(this.userName);
        nodeInstaller.setPassword(this.password);
        return nodeInstaller;
    }

    public NPMInstaller getNPMInstaller() {
        NPMInstaller npmInstaller = new NPMInstaller(this.getInstallConfig(), (ArchiveExtractor)new DefaultArchiveExtractor(), (FileDownloader)this.fileDownloader);
        npmInstaller.setUserName(this.userName);
        npmInstaller.setPassword(this.password);
        return npmInstaller;
    }

    public PnpmInstaller getPnpmInstaller() {
        PnpmInstaller pnpmInstaller = new PnpmInstaller(this.getInstallConfig(), (ArchiveExtractor)new DefaultArchiveExtractor(), (FileDownloader)this.fileDownloader);
        pnpmInstaller.setUserName(this.userName);
        pnpmInstaller.setPassword(this.password);
        return pnpmInstaller;
    }

    public YarnInstaller getYarnInstaller() {
        YarnInstaller yarnInstaller = new YarnInstaller(this.getInstallConfig(), (ArchiveExtractor)new DefaultArchiveExtractor(), (FileDownloader)this.fileDownloader);
        yarnInstaller.setUserName(this.userName);
        yarnInstaller.setPassword(this.password);
        return yarnInstaller;
    }

    public BunInstaller getBunInstaller() {
        BunInstaller bunInstaller = new BunInstaller(this.getInstallConfig(), (ArchiveExtractor)new DefaultArchiveExtractor(), (FileDownloader)this.fileDownloader);
        bunInstaller.setUserName(this.userName);
        bunInstaller.setPassword(this.password);
        return bunInstaller;
    }

    private NodeExecutorConfig getExecutorConfig() {
        return new InstallNodeExecutorConfig(this.getInstallConfig());
    }

    private InstallConfig getInstallConfig() {
        return new DefaultInstallConfig(this.installDir.toFile(), this.uiDir.toFile(), this.cacheResolver, defaultPlatform);
    }

    private static CacheResolver getDefaultCacheResolver(Path root) {
        return new DirectoryCacheResolver(root.resolve("cache").toFile());
    }
}

