/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.quinoa.deployment.packagemanager;

import com.github.eirslett.maven.plugins.frontend.lib.InstallationException;
import com.github.eirslett.maven.plugins.frontend.lib.PackageManagerInstallFactory;
import io.quarkiverse.quinoa.deployment.config.PackageManagerInstallConfig;
import io.quarkiverse.quinoa.deployment.packagemanager.PackageManagerRunner;
import io.quarkiverse.quinoa.deployment.packagemanager.types.PackageManagerType;
import io.quarkus.deployment.console.ConsoleInstalledBuildItem;
import io.quarkus.deployment.console.StartupLogCompressor;
import io.quarkus.deployment.logging.LoggingSetupBuildItem;
import io.quarkus.runtime.configuration.ConfigurationException;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.Path;
import java.util.Optional;
import java.util.Set;
import org.jboss.logging.Logger;

public final class PackageManagerInstall {
    private static final Logger LOG = Logger.getLogger(PackageManagerInstall.class);
    private static final String INSTALL_SUB_PATH = "node";
    public static final String NODE_BINARY = PackageManagerRunner.isWindows() ? "node.exe" : "node";
    public static final String BUN_BINARY = PackageManagerRunner.isWindows() ? "bun.exe" : "bun";
    public static final String NPM_PATH = "node/node_modules/npm/bin/npm-cli.js";
    public static final String PNPM_PATH = "node/node_modules/pnpm/bin/pnpm.cjs";
    public static final String YARN_PATH = "node/yarn/dist/bin/yarn.js";
    public static final String BUN_PATH = "bun/" + BUN_BINARY;

    private PackageManagerInstall() {
    }

    /*
     * Exception decompiling
     */
    public static Installation install(PackageManagerInstallConfig config, Path projectDir, Path uiDir, Optional<ConsoleInstalledBuildItem> consoleInstalledBuildItem, LoggingSetupBuildItem loggingSetupBuildItem) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static Vertx createVertxInstance() {
        Vertx vertx;
        String originalValue = System.getProperty("vertx.disableDnsResolver");
        try {
            System.setProperty("vertx.disableDnsResolver", "true");
            vertx = Vertx.vertx((VertxOptions)new VertxOptions());
        }
        finally {
            if (originalValue == null) {
                System.clearProperty("vertx.disableDnsResolver");
            } else {
                System.setProperty("vertx.disableDnsResolver", originalValue);
            }
        }
        return vertx;
    }

    private static Installation attemptInstall(PackageManagerInstallConfig config, Path uiDir, Path installDir, PackageManagerInstallFactory factory, Optional<ConsoleInstalledBuildItem> consoleInstalledBuildItem, LoggingSetupBuildItem loggingSetupBuildItem) throws InstallationException {
        Optional<String> pnpmVersion;
        Optional<String> yarnVersion;
        boolean isBunOnly = PackageManagerInstall.isBunOnly(config);
        if (!isBunOnly) {
            StartupLogCompressor nodeInstallerLogCompressor = null;
            try {
                nodeInstallerLogCompressor = new StartupLogCompressor("node installer", consoleInstalledBuildItem, loggingSetupBuildItem);
                factory.getNodeInstaller().setNodeVersion("v" + config.nodeVersion().orElse("???")).setNodeDownloadRoot(config.nodeDownloadRoot()).setNpmVersion(config.npmVersion()).install();
                nodeInstallerLogCompressor.close();
            }
            catch (InstallationException e) {
                nodeInstallerLogCompressor.closeAndDumpCaptured();
                if (e.getCause() instanceof DirectoryNotEmptyException && e.getCause().getMessage().contains("tmp")) {
                    LOG.warnf("Quinoa was not able to delete the Node install temporary directory: %s", (Object)e.getCause().getMessage());
                }
                throw e;
            }
        }
        String executionPath = NPM_PATH;
        String npmVersion = config.npmVersion();
        boolean isNpmProvided = "provided".equalsIgnoreCase(npmVersion);
        if (!isNpmProvided) {
            StartupLogCompressor npmInstallerLogCompressor = null;
            try {
                npmInstallerLogCompressor = new StartupLogCompressor("npm installer", consoleInstalledBuildItem, loggingSetupBuildItem);
                factory.getNPMInstaller().setNodeVersion("v" + config.nodeVersion().orElse("???")).setNpmVersion(npmVersion).setNpmDownloadRoot(config.npmDownloadRoot()).install();
                npmInstallerLogCompressor.close();
            }
            catch (InstallationException e) {
                npmInstallerLogCompressor.closeAndDumpCaptured();
                throw e;
            }
        }
        if ((yarnVersion = config.yarnVersion()).isPresent() && isNpmProvided) {
            executionPath = YARN_PATH;
            factory.getYarnInstaller().setIsYarnBerry(PackageManagerType.isYarnBerry(uiDir)).setYarnVersion("v" + config.yarnVersion().orElse("???")).setYarnDownloadRoot(config.yarnDownloadRoot()).setIsYarnBerry(true).install();
        }
        if ((pnpmVersion = config.pnpmVersion()).isPresent() && isNpmProvided && yarnVersion.isEmpty()) {
            executionPath = PNPM_PATH;
            factory.getPnpmInstaller().setNodeVersion("v" + config.nodeVersion().orElse("???")).setPnpmVersion(pnpmVersion.get()).setPnpmDownloadRoot(config.pnpmDownloadRoot()).install();
        }
        if (isBunOnly) {
            executionPath = BUN_PATH;
            factory.getBunInstaller().setBunVersion("v" + config.bunVersion().orElse("???")).install();
        }
        return PackageManagerInstall.resolveInstalledExecutorBinary(installDir, executionPath, isBunOnly);
    }

    private static Path resolveInstallDir(PackageManagerInstallConfig config, Path projectDir) {
        Path installPath = Path.of(config.installDir().trim(), new String[0]);
        if (installPath.isAbsolute()) {
            return installPath;
        }
        if (projectDir == null) {
            throw new ConfigurationException("Use an absolute package-manager-install.install-dir when the project root directory is not standard", Set.of("quarkus.quinoa.package-manager-install.install-dir"));
        }
        return projectDir.resolve(installPath);
    }

    private static Installation resolveInstalledExecutorBinary(Path installDirectory, String executionPath, boolean isBunOnly) {
        Path nodeDirPath = installDirectory.resolve(!isBunOnly ? INSTALL_SUB_PATH : "").toAbsolutePath();
        Path executorPath = installDirectory.resolve(executionPath).toAbsolutePath();
        String platformNodeDirPath = PackageManagerInstall.normalizePath(nodeDirPath.toString());
        String platformExecutorPath = PackageManagerInstall.normalizePath(executorPath.toString());
        Object packageManagerBinary = isBunOnly ? PackageManagerInstall.quotePathWithSpaces(platformExecutorPath) : NODE_BINARY + " " + PackageManagerInstall.quotePathWithSpaces(platformExecutorPath);
        return new Installation(platformNodeDirPath, (String)packageManagerBinary);
    }

    public static String normalizePath(String path) {
        return PackageManagerRunner.isWindows() ? path.replaceAll("/", "\\\\") : path;
    }

    public static String quotePathWithSpaces(String path) {
        return path.contains(" ") ? "\"".concat(path).concat("\"") : path;
    }

    private static boolean isBunOnly(PackageManagerInstallConfig config) {
        Optional<String> nodeVersion = config.nodeVersion();
        Optional<String> bunVersion = config.bunVersion();
        Optional<String> yarnVersion = config.yarnVersion();
        Optional<String> pnpmVersion = config.pnpmVersion();
        String npmVersion = config.npmVersion();
        boolean isNpmProvided = "provided".equalsIgnoreCase(npmVersion);
        return bunVersion.isPresent() && isNpmProvided && yarnVersion.isEmpty() && pnpmVersion.isEmpty() && nodeVersion.isEmpty();
    }

    public record Installation(String nodeDirPath, String packageManagerBinary) {
    }
}

