/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.quinoa;

import io.quarkus.runtime.annotations.Recorder;
import io.vertx.core.Handler;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.FileSystemAccess;
import io.vertx.ext.web.handler.StaticHandler;
import java.io.IOException;
import java.util.Objects;
import java.util.Set;
import org.jboss.logging.Logger;

@Recorder
public class QuinoaRecorder {
    private static final Logger log = Logger.getLogger(QuinoaRecorder.class);
    public static final String META_INF_UI = "META-INF/ui";

    public Handler<RoutingContext> quinoaHandler(String directory, Set<String> uiResources) throws IOException {
        return new QuinoaUIResourceHandler(directory, uiResources);
    }

    private static class QuinoaUIResourceHandler
    implements Handler<RoutingContext> {
        private final Set<String> uiResources;
        private final Handler<RoutingContext> staticHandler;
        private final ClassLoader currentClassLoader;

        private QuinoaUIResourceHandler(String directory, Set<String> uiResources) {
            this.uiResources = uiResources;
            this.staticHandler = directory != null ? StaticHandler.create((FileSystemAccess)FileSystemAccess.ROOT, (String)directory) : StaticHandler.create((String)QuinoaRecorder.META_INF_UI);
            this.currentClassLoader = Thread.currentThread().getContextClassLoader();
        }

        public void handle(RoutingContext ctx) {
            String rel;
            String string = ctx.mountPoint() == null ? ctx.normalizedPath() : (rel = ctx.normalizedPath().substring(ctx.mountPoint().endsWith("/") ? ctx.mountPoint().length() - 1 : ctx.mountPoint().length()));
            if (this.uiResources.contains(rel) || Objects.equals(rel, "/")) {
                log.infof("Quinoa is serving: '%s'", (Object)rel);
                this.staticHandler.handle((Object)ctx);
            } else {
                Thread.currentThread().setContextClassLoader(this.currentClassLoader);
                ctx.next();
            }
        }
    }
}

