/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.quinoa;

import io.quarkiverse.quinoa.QuinoaRecorder;
import io.vertx.core.Handler;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.FileSystemAccess;
import io.vertx.ext.web.handler.StaticHandler;
import java.util.List;
import java.util.Set;
import org.jboss.logging.Logger;

class QuinoaUIResourceHandler
implements Handler<RoutingContext> {
    private static final Logger LOG = Logger.getLogger(QuinoaUIResourceHandler.class);
    private final Set<String> uiResources;
    private final Handler<RoutingContext> staticHandler;
    private final List<String> ignoredPathPrefixes;
    private final ClassLoader currentClassLoader;

    QuinoaUIResourceHandler(String directory, Set<String> uiResources, List<String> ignoredPathPrefixes) {
        this.uiResources = uiResources;
        this.staticHandler = directory != null ? StaticHandler.create((FileSystemAccess)FileSystemAccess.ROOT, (String)directory) : StaticHandler.create((String)"META-INF/webui");
        this.ignoredPathPrefixes = ignoredPathPrefixes;
        this.currentClassLoader = Thread.currentThread().getContextClassLoader();
    }

    public void handle(RoutingContext ctx) {
        if (!QuinoaRecorder.shouldHandleMethod(ctx)) {
            QuinoaRecorder.next(this.currentClassLoader, ctx);
            return;
        }
        String path = QuinoaRecorder.resolvePath(ctx);
        if (!QuinoaRecorder.isIgnored(path, this.ignoredPathPrefixes) && this.isUIResource(path)) {
            if (LOG.isDebugEnabled()) {
                LOG.debugf("Quinoa is serving: '%s'", (Object)path);
            }
            this.staticHandler.handle((Object)ctx);
        } else {
            QuinoaRecorder.next(this.currentClassLoader, ctx);
        }
    }

    private boolean isUIResource(String path) {
        return this.uiResources.contains(path) || path.endsWith("/") && this.uiResources.contains(path + "index.html");
    }
}

