/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.quinoa;

import io.quarkiverse.quinoa.QuinoaDevProxyHandler;
import io.quarkiverse.quinoa.QuinoaHandlerConfig;
import io.quarkiverse.quinoa.QuinoaSPARoutingHandler;
import io.quarkiverse.quinoa.QuinoaUIResourceHandler;
import io.quarkus.runtime.annotations.Recorder;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpMethod;
import io.vertx.ext.web.RoutingContext;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import org.jboss.logging.Logger;

@Recorder
public class QuinoaRecorder {
    private static final Logger LOG = Logger.getLogger(QuinoaRecorder.class);
    public static final String META_INF_WEB_UI = "META-INF/webui";
    public static final int QUINOA_ROUTE_ORDER = 1100;
    public static final int QUINOA_SPA_ROUTE_ORDER = 20100;
    public static final Set<HttpMethod> HANDLED_METHODS = Set.of(HttpMethod.HEAD, HttpMethod.OPTIONS, HttpMethod.GET);

    public Handler<RoutingContext> quinoaProxyDevHandler(QuinoaHandlerConfig handlerConfig, Supplier<Vertx> vertx, int port) {
        QuinoaRecorder.logIgnoredPathPrefixes(handlerConfig.ignoredPathPrefixes);
        return new QuinoaDevProxyHandler(handlerConfig, vertx.get(), port);
    }

    public Handler<RoutingContext> quinoaSPARoutingHandler(QuinoaHandlerConfig handlerConfig) throws IOException {
        return new QuinoaSPARoutingHandler(handlerConfig);
    }

    public Handler<RoutingContext> quinoaHandler(QuinoaHandlerConfig handlerConfig, String directory, Set<String> uiResources) {
        QuinoaRecorder.logIgnoredPathPrefixes(handlerConfig.ignoredPathPrefixes);
        return new QuinoaUIResourceHandler(handlerConfig, directory, uiResources);
    }

    static String resolvePath(RoutingContext ctx) {
        return ctx.mountPoint() == null ? ctx.normalizedPath() : ctx.normalizedPath().substring(ctx.mountPoint().endsWith("/") ? ctx.mountPoint().length() - 1 : ctx.mountPoint().length());
    }

    static boolean isIgnored(String path, List<String> ignoredPathPrefixes) {
        if (ignoredPathPrefixes.stream().anyMatch(path::startsWith)) {
            if (LOG.isDebugEnabled()) {
                LOG.debugf("Quinoa is ignoring path (quarkus.quinoa.ignored-path-prefixes): " + path, new Object[0]);
            }
            return true;
        }
        return false;
    }

    static void logIgnoredPathPrefixes(List<String> ignoredPathPrefixes) {
        if (LOG.isDebugEnabled()) {
            LOG.debugf("Quinoa is ignoring paths starting with: " + String.join((CharSequence)", ", ignoredPathPrefixes), new Object[0]);
        }
    }

    static boolean shouldHandleMethod(RoutingContext ctx) {
        return HANDLED_METHODS.contains(ctx.request().method());
    }

    static void next(ClassLoader cl, RoutingContext ctx) {
        Thread.currentThread().setContextClassLoader(cl);
        ctx.next();
    }
}

