/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.quinoa;

import io.quarkus.runtime.util.StringUtil;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.ServerWebSocket;
import io.vertx.core.http.WebSocket;
import io.vertx.core.http.WebSocketConnectOptions;
import io.vertx.ext.web.RoutingContext;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicReference;
import org.jboss.logging.Logger;

class QuinoaDevWebSocketProxyHandler {
    private static final Logger LOG = Logger.getLogger(QuinoaDevWebSocketProxyHandler.class);
    private final HttpClient httpClient;
    private final int port;

    QuinoaDevWebSocketProxyHandler(Vertx vertx, int port) {
        this.httpClient = vertx.createHttpClient();
        this.port = port;
    }

    public void handle(RoutingContext ctx) {
        HttpServerRequest request = ctx.request();
        ctx.request().pause();
        request.toWebSocket(r -> {
            if (r.succeeded()) {
                String host = request.localAddress().host();
                String forwardUri = request.uri();
                LOG.debugf("Quinoa Dev WebSocket Server Connected: %s:%s%s", (Object)host, (Object)this.port, (Object)forwardUri);
                ServerWebSocket serverWs = (ServerWebSocket)r.result();
                AtomicReference clientWs = new AtomicReference();
                serverWs.exceptionHandler(e -> LOG.errorf(e, "Quinoa Dev WebSocket Server closed with error: %s", (Object)e.getMessage())).closeHandler(__ -> {
                    clientWs.getAndUpdate(w -> {
                        if (w != null && !w.isClosed()) {
                            w.close();
                        }
                        return null;
                    });
                    LOG.debug((Object)"Quinoa Dev WebSocket Server is closed");
                });
                String subProtocol = serverWs.subProtocol();
                ArrayList<String> subProtocols = new ArrayList<String>(1);
                if (!StringUtil.isNullOrEmpty((String)subProtocol)) {
                    subProtocols.add(subProtocol);
                    LOG.debugf("Quinoa Dev WebSocket SubProtocol: %s", (Object)subProtocol);
                }
                WebSocketConnectOptions options = new WebSocketConnectOptions().setHost(host).setPort(Integer.valueOf(this.port)).setURI(forwardUri).setHeaders(serverWs.headers()).setSubProtocols(subProtocols).setAllowOriginHeader(false);
                serverWs.accept();
                this.httpClient.webSocket(options, clientContext -> {
                    if (clientContext.succeeded()) {
                        LOG.debugf("Quinoa Dev WebSocket Client Connected: %s:%s%s", (Object)host, (Object)this.port, (Object)forwardUri);
                        clientWs.set((WebSocket)clientContext.result());
                        ((WebSocket)clientWs.get()).exceptionHandler(e -> LOG.errorf(e, "Quinoa Dev WebSocket Client closed with error: %s", (Object)e.getMessage())).closeHandler(__ -> {
                            LOG.debug((Object)"Quinoa Dev WebSocket Client is closed");
                            serverWs.close();
                        }).textMessageHandler(msg -> {
                            LOG.debugf("Quinoa Dev WebSocket Client message: %s", msg);
                            serverWs.writeTextMessage(msg);
                        });
                        serverWs.textMessageHandler(msg -> {
                            LOG.debugf("Quinoa Dev WebSocket Server message:  %s", msg);
                            WebSocket w = (WebSocket)clientWs.get();
                            if (w != null && !w.isClosed()) {
                                w.writeTextMessage(msg);
                            }
                        });
                    } else {
                        LOG.error((Object)"Quinoa Dev WebSocket Client connection failed", clientContext.cause());
                    }
                });
            } else {
                LOG.error((Object)"Error while upgrading request to WebSocket", r.cause());
            }
        });
    }
}

