/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.quinoa;

import io.quarkiverse.quinoa.QuinoaRecorder;
import io.vertx.core.Handler;
import io.vertx.ext.web.RoutingContext;
import java.util.List;
import java.util.Objects;
import org.jboss.logging.Logger;

class QuinoaSPARoutingHandler
implements Handler<RoutingContext> {
    private static final Logger LOG = Logger.getLogger(QuinoaSPARoutingHandler.class);
    private final ClassLoader currentClassLoader;
    private final List<String> ignoredPathPrefixes;

    public QuinoaSPARoutingHandler(List<String> ignoredPathPrefixes) {
        this.ignoredPathPrefixes = ignoredPathPrefixes;
        this.currentClassLoader = Thread.currentThread().getContextClassLoader();
    }

    public void handle(RoutingContext ctx) {
        if (!QuinoaRecorder.shouldHandleMethod(ctx)) {
            QuinoaRecorder.next(this.currentClassLoader, ctx);
            return;
        }
        String path = QuinoaRecorder.resolvePath(ctx);
        if (!Objects.equals(path, "/") && !QuinoaRecorder.isIgnored(path, this.ignoredPathPrefixes)) {
            String mountPoint = ctx.mountPoint() != null ? ctx.mountPoint() : "/";
            String routePath = ctx.currentRoute().getPath() != null ? ctx.currentRoute().getPath() : "/";
            String target = mountPoint.endsWith("/") ? mountPoint.substring(0, mountPoint.length() - 1) + routePath : mountPoint + routePath;
            LOG.debugf("Quinoa is re-routing SPA request '%s' to '%s'", (Object)ctx.normalizedPath(), (Object)target);
            ctx.reroute(target);
        } else {
            QuinoaRecorder.next(this.currentClassLoader, ctx);
        }
    }
}

