/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.qute.web.deployment;

import io.quarkiverse.qute.web.deployment.QuteWebTemplatePathBuildItem;
import io.quarkiverse.qute.web.runtime.QuteWebBuildTimeConfig;
import io.quarkiverse.qute.web.runtime.QuteWebExtensions;
import io.quarkiverse.qute.web.runtime.QuteWebRecorder;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.SyntheticBeansRuntimeInitBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.Consume;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.qute.deployment.TemplateFilePathsBuildItem;
import io.quarkus.vertx.http.deployment.HttpRootPathBuildItem;
import io.quarkus.vertx.http.deployment.RouteBuildItem;
import io.quarkus.vertx.http.runtime.HandlerType;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;

class QuteWebProcessor {
    private static final Logger LOG = Logger.getLogger(QuteWebProcessor.class);
    private static final String FEATURE = "qute-web";

    QuteWebProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    AdditionalBeanBuildItem beans() {
        return new AdditionalBeanBuildItem(new Class[]{QuteWebExtensions.class});
    }

    @BuildStep
    public void collectTemplatePaths(TemplateFilePathsBuildItem templateFilePaths, QuteWebBuildTimeConfig config, BuildProducer<QuteWebTemplatePathBuildItem> paths) {
        Object publicPathPrefix = "";
        String publicDir = config.publicDir();
        if (!publicDir.equals("/") && !publicDir.isBlank()) {
            publicPathPrefix = publicDir + "/";
        }
        Optional hiddenTemplates = config.hiddenTemplates();
        for (String path : templateFilePaths.getFilePaths()) {
            if (!path.startsWith((String)publicPathPrefix)) continue;
            if (hiddenTemplates.isPresent() && ((Pattern)hiddenTemplates.get()).matcher(path.substring(((String)publicPathPrefix).length())).matches()) {
                LOG.debugf("Template %s is hidden", (Object)path);
                continue;
            }
            LOG.debugf("Web template found: %s", (Object)path);
            paths.produce((BuildItem)new QuteWebTemplatePathBuildItem(path));
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    @Consume(value=SyntheticBeansRuntimeInitBuildItem.class)
    public RouteBuildItem produceTemplatesRoute(QuteWebRecorder recorder, List<QuteWebTemplatePathBuildItem> templatePaths, HttpRootPathBuildItem httpRootPath, QuteWebBuildTimeConfig config) {
        if (templatePaths.isEmpty()) {
            return null;
        }
        return httpRootPath.routeBuilder().routeFunction(httpRootPath.relativePath(config.rootPath() + "/*"), recorder.initializeRoute()).handlerType(config.useBlockingHandler() ? HandlerType.BLOCKING : HandlerType.NORMAL).handler(recorder.handler(httpRootPath.relativePath(config.rootPath()), templatePaths.stream().map(QuteWebTemplatePathBuildItem::getPath).collect(Collectors.toSet()))).build();
    }
}

