/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.rabbitmqclient.deployment;

import io.quarkiverse.rabbitmqclient.NamedRabbitMQClient;
import io.quarkiverse.rabbitmqclient.RabbitMQClient;
import io.quarkiverse.rabbitmqclient.RabbitMQClients;
import io.quarkiverse.rabbitmqclient.deployment.QuarkusRabbitMQClientBuildItem;
import io.quarkiverse.rabbitmqclient.runtime.RabbitMQClientBuildConfig;
import io.quarkiverse.rabbitmqclient.runtime.RabbitMQClientsBuildConfig;
import io.quarkiverse.rabbitmqclient.runtime.RabbitMQRecorder;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.BeanArchiveIndexBuildItem;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.arc.deployment.ValidationPhaseBuildItem;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.ShutdownContextBuildItem;
import io.quarkus.deployment.metrics.MetricsCapabilityBuildItem;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.smallrye.health.deployment.spi.HealthBuildItem;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import javax.enterprise.inject.Default;
import javax.inject.Singleton;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;

class QuarkusRabbitMQClientProcessor {
    private static final String FEATURE = "rabbitmq-client";
    private static final DotName NAMED_RABBITMQ_CLIENT_ANNOTATION = DotName.createSimple((String)NamedRabbitMQClient.class.getName());

    QuarkusRabbitMQClientProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    HealthBuildItem addHealthCheck(RabbitMQClientsBuildConfig buildTimeConfig) {
        return new HealthBuildItem("io.quarkiverse.rabbitmqclient.RabbitMQReadyCheck", buildTimeConfig.healthEnabled);
    }

    @BuildStep
    public void registerAdditionalBeans(BuildProducer<AdditionalBeanBuildItem> additionalBeanBuildItemProducer) {
        additionalBeanBuildItemProducer.produce((BuildItem)AdditionalBeanBuildItem.builder().addBeanClasses(new Class[]{RabbitMQClients.class}).setUnremovable().setDefaultScope(DotNames.SINGLETON).build());
        additionalBeanBuildItemProducer.produce((BuildItem)AdditionalBeanBuildItem.builder().addBeanClass(NamedRabbitMQClient.class).build());
    }

    @BuildStep
    public void defineClients(BuildProducer<QuarkusRabbitMQClientBuildItem> clientName, RabbitMQClientsBuildConfig clients, BeanArchiveIndexBuildItem indexBuildItem) {
        if (clients.defaultClient.enabled) {
            clientName.produce((BuildItem)new QuarkusRabbitMQClientBuildItem("default"));
        }
        IndexView indexView = indexBuildItem.getIndex();
        Collection clientAnnotations = indexView.getAnnotations(NAMED_RABBITMQ_CLIENT_ANNOTATION);
        for (AnnotationInstance annotation : clientAnnotations) {
            RabbitMQClientBuildConfig cfg = (RabbitMQClientBuildConfig)clients.namedClients.get(annotation.value().asString());
            if (cfg != null && cfg.enabled) {
                clientName.produce((BuildItem)new QuarkusRabbitMQClientBuildItem(annotation.value().asString()));
                continue;
            }
            if (cfg != null) continue;
            clientName.produce((BuildItem)new QuarkusRabbitMQClientBuildItem(annotation.value().asString()));
        }
    }

    @BuildStep
    public void validateClients(ValidationPhaseBuildItem validationPhase, BuildProducer<ValidationPhaseBuildItem.ValidationErrorBuildItem> errors, List<QuarkusRabbitMQClientBuildItem> clients) {
        if (clients.stream().filter(c -> "default".equalsIgnoreCase(c.getName())).count() > 1L) {
            errors.produce((BuildItem)new ValidationPhaseBuildItem.ValidationErrorBuildItem(new Throwable[]{new IllegalArgumentException("RabbitMQ client name 'default' is reserved for the default client.")}));
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void createClients(RabbitMQRecorder recorder, ShutdownContextBuildItem shutdown, List<QuarkusRabbitMQClientBuildItem> namedClients, RabbitMQClientsBuildConfig buildTimeConfig, BuildProducer<SyntheticBeanBuildItem> syntheticBeans, Optional<MetricsCapabilityBuildItem> metricsCapability) {
        recorder.registerShutdownTask((ShutdownContext)shutdown);
        for (QuarkusRabbitMQClientBuildItem namedClient : namedClients) {
            this.addRabbitMQClient(recorder, namedClient.getName(), buildTimeConfig, metricsCapability, syntheticBeans);
        }
    }

    void addRabbitMQClient(RabbitMQRecorder recorder, String name, RabbitMQClientsBuildConfig buildTimeConfig, Optional<MetricsCapabilityBuildItem> metricsCapability, BuildProducer<SyntheticBeanBuildItem> syntheticBeans) {
        Supplier rabbitMQClientSupplier = null;
        if (buildTimeConfig.metricsEnabled && metricsCapability.isPresent()) {
            if (metricsCapability.get().metricsSupported("micrometer")) {
                rabbitMQClientSupplier = recorder.rabbitMQClientSupplierMicrometerMetrics(name, Map.of("name", name));
            } else if (metricsCapability.get().metricsSupported("smallrye-metrics")) {
                rabbitMQClientSupplier = recorder.rabbitMQClientSupplierMPMetrics(name, Map.of("name", name));
            }
        }
        if (rabbitMQClientSupplier == null) {
            rabbitMQClientSupplier = recorder.rabbitMQClientSupplier(name);
        }
        SyntheticBeanBuildItem.ExtendedBeanConfigurator configurator = ((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(RabbitMQClient.class).scope(Singleton.class)).setRuntimeInit().unremovable()).supplier(rabbitMQClientSupplier);
        if ("default".equals(name)) {
            configurator.addQualifier(Default.class);
        } else {
            configurator.addQualifier().annotation(DotNames.NAMED).addValue("value", (Object)name).done();
            configurator.addQualifier().annotation(NamedRabbitMQClient.class).addValue("value", (Object)name).done();
        }
        syntheticBeans.produce((BuildItem)configurator.done());
    }
}

