/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.rabbitmqclient.deployment;

import io.quarkiverse.rabbitmqclient.NamedRabbitMQClient;
import io.quarkiverse.rabbitmqclient.RabbitMQClient;
import io.quarkiverse.rabbitmqclient.RabbitMQClients;
import io.quarkiverse.rabbitmqclient.deployment.QuarkusRabbitMQClientBuildItem;
import io.quarkiverse.rabbitmqclient.deployment.RabbitMQClientBuildConfig;
import io.quarkiverse.rabbitmqclient.deployment.RabbitMQClientsBuildConfig;
import io.quarkiverse.rabbitmqclient.runtime.RabbitMQRecorder;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.BeanArchiveIndexBuildItem;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.arc.deployment.ValidationPhaseBuildItem;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.ShutdownContextBuildItem;
import io.quarkus.deployment.metrics.MetricsCapabilityBuildItem;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.smallrye.health.deployment.spi.HealthBuildItem;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Default;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;

class QuarkusRabbitMQClientProcessor {
    private static final String FEATURE = "rabbitmq-client";
    private static final DotName NAMED_RABBITMQ_CLIENT_ANNOTATION = DotName.createSimple((String)NamedRabbitMQClient.class.getName());

    QuarkusRabbitMQClientProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    HealthBuildItem addHealthCheck(RabbitMQClientsBuildConfig buildTimeConfig) {
        return new HealthBuildItem("io.quarkiverse.rabbitmqclient.RabbitMQReadyCheck", buildTimeConfig.healthEnabled());
    }

    @BuildStep
    public void registerAdditionalBeans(BuildProducer<AdditionalBeanBuildItem> additionalBeanBuildItemProducer) {
        additionalBeanBuildItemProducer.produce((BuildItem)AdditionalBeanBuildItem.builder().addBeanClasses(new Class[]{RabbitMQClients.class}).setUnremovable().setDefaultScope(DotNames.SINGLETON).build());
        additionalBeanBuildItemProducer.produce((BuildItem)AdditionalBeanBuildItem.builder().addBeanClass(NamedRabbitMQClient.class).build());
    }

    @BuildStep
    public void defineClients(BuildProducer<QuarkusRabbitMQClientBuildItem> clientName, RabbitMQClientsBuildConfig clients, BeanArchiveIndexBuildItem indexBuildItem) {
        if (clients.clients().get("<default>").enabled()) {
            clientName.produce((BuildItem)new QuarkusRabbitMQClientBuildItem("<default>", clients.metricsEnabled()));
        }
        IndexView indexView = indexBuildItem.getIndex();
        Collection clientAnnotations = indexView.getAnnotations(NAMED_RABBITMQ_CLIENT_ANNOTATION);
        for (AnnotationInstance annotation : clientAnnotations) {
            RabbitMQClientBuildConfig cfg = clients.clients().get(annotation.value().asString());
            if (cfg != null && cfg.enabled()) {
                clientName.produce((BuildItem)new QuarkusRabbitMQClientBuildItem(annotation.value().asString(), clients.metricsEnabled()));
                continue;
            }
            if (cfg != null) continue;
            clientName.produce((BuildItem)new QuarkusRabbitMQClientBuildItem(annotation.value().asString(), clients.metricsEnabled()));
        }
    }

    @BuildStep
    public void validateClients(ValidationPhaseBuildItem validationPhase, BuildProducer<ValidationPhaseBuildItem.ValidationErrorBuildItem> errors, List<QuarkusRabbitMQClientBuildItem> clients) {
        if (clients.stream().filter(c -> "<default>".equalsIgnoreCase(c.getName())).count() > 1L) {
            errors.produce((BuildItem)new ValidationPhaseBuildItem.ValidationErrorBuildItem(new Throwable[]{new IllegalArgumentException("RabbitMQ client name '<default>' is reserved for the default client.")}));
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void createClients(RabbitMQRecorder recorder, ShutdownContextBuildItem shutdown, List<QuarkusRabbitMQClientBuildItem> namedClients, BuildProducer<SyntheticBeanBuildItem> syntheticBeans, Optional<MetricsCapabilityBuildItem> metricsCapability) {
        recorder.registerShutdownTask((ShutdownContext)shutdown);
        for (QuarkusRabbitMQClientBuildItem namedClient : namedClients) {
            this.addRabbitMQClient(recorder, namedClient, metricsCapability, syntheticBeans);
        }
    }

    void addRabbitMQClient(RabbitMQRecorder recorder, QuarkusRabbitMQClientBuildItem client, Optional<MetricsCapabilityBuildItem> metricsCapability, BuildProducer<SyntheticBeanBuildItem> syntheticBeans) {
        Supplier rabbitMQClientSupplier = null;
        if (client.isMetricsEnabled() && metricsCapability.isPresent()) {
            if (metricsCapability.get().metricsSupported("micrometer")) {
                rabbitMQClientSupplier = recorder.rabbitMQClientSupplierMicrometerMetrics(client.getName(), Map.of("name", client.getName()));
            } else if (metricsCapability.get().metricsSupported("smallrye-metrics")) {
                rabbitMQClientSupplier = recorder.rabbitMQClientSupplierMPMetrics(client.getName(), Map.of("name", client.getName()));
            }
        }
        if (rabbitMQClientSupplier == null) {
            rabbitMQClientSupplier = recorder.rabbitMQClientSupplier(client.getName());
        }
        SyntheticBeanBuildItem.ExtendedBeanConfigurator configurator = ((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(RabbitMQClient.class).scope(ApplicationScoped.class)).setRuntimeInit().unremovable()).supplier(rabbitMQClientSupplier);
        if ("<default>".equals(client.getName())) {
            configurator.addQualifier(Default.class);
        } else {
            configurator.addQualifier().annotation(DotNames.NAMED).addValue("value", (Object)client.getName()).done();
            configurator.addQualifier().annotation(NamedRabbitMQClient.class).addValue("value", (Object)client.getName()).done();
        }
        syntheticBeans.produce((BuildItem)configurator.done());
    }
}

