/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.rabbitmqclient;

import io.quarkiverse.rabbitmqclient.SaslType;
import io.quarkus.runtime.annotations.ConfigGroup;
import io.quarkus.runtime.annotations.ConfigItem;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;

@ConfigGroup
public class RabbitMQClientConfig {
    @ConfigItem
    public Optional<String> uri;
    @ConfigItem
    public Map<String, Address> addresses = Collections.emptyMap();
    @ConfigItem(defaultValue="guest")
    public String username;
    @ConfigItem(defaultValue="guest")
    public String password;
    @ConfigItem(defaultValue="localhost")
    public String hostname;
    @ConfigItem(defaultValue="/")
    public String virtualHost;
    @ConfigItem(defaultValue="-1")
    public int port;
    @ConfigItem(defaultValue="60000")
    public int connectionTimeout;
    @ConfigItem(defaultValue="-1")
    public int connectionCloseTimeout;
    @ConfigItem(defaultValue="60")
    public int requestedHeartbeat;
    @ConfigItem(defaultValue="10000")
    public int handshakeTimeout;
    @ConfigItem(defaultValue="10000")
    public int shutdownTimeout;
    @ConfigItem(defaultValue="2047")
    public int requestedChannelMax;
    @ConfigItem(defaultValue="0")
    public int requestedFrameMax;
    @ConfigItem(defaultValue="5000")
    public int networkRecoveryInterval;
    @ConfigItem(defaultValue="600000")
    public int channelRpcTimeout;
    @ConfigItem(defaultValue="false")
    public boolean channelRpcResponseTypeCheck;
    @ConfigItem(defaultValue="true")
    public boolean connectionRecovery;
    @ConfigItem(defaultValue="true")
    public boolean topologyRecovery;
    @ConfigItem(defaultValue="plain")
    public SaslType sasl;
    @ConfigItem
    public TlsConfig tls;
    @ConfigItem
    public NioConfig nio;
    @ConfigItem
    public Map<String, String> properties;

    @ConfigGroup
    public static class TlsConfig {
        @ConfigItem(defaultValue="false")
        public boolean enabled;
        @ConfigItem(defaultValue="TLSv1.2")
        public String algorithm;
        @ConfigItem
        public Optional<String> trustStoreFile;
        @ConfigItem(defaultValue="JKS")
        public String trustStoreType;
        @ConfigItem(defaultValue="SunX509")
        public String trustStoreAlgorithm;
        @ConfigItem
        public Optional<String> trustStorePassword;
        @ConfigItem
        public Optional<String> keyStoreFile;
        @ConfigItem
        public Optional<String> keyStorePassword;
        @ConfigItem(defaultValue="PKCS12")
        public String keyStoreType;
        @ConfigItem(defaultValue="SunX509")
        public String keyStoreAlgorithm;
        @ConfigItem(defaultValue="true")
        public boolean validateServerCertificate;
        @ConfigItem(defaultValue="true")
        public boolean verifyHostname;
    }

    @ConfigGroup
    public static class NioConfig {
        @ConfigItem(defaultValue="false")
        public boolean enabled;
        @ConfigItem(defaultValue="32768")
        public int readByteBufferSize;
        @ConfigItem(defaultValue="32768")
        public int writeByteBufferSize;
        @ConfigItem(defaultValue="1")
        public int threads;
        @ConfigItem(defaultValue="10000")
        public int writeEnqueuingTimeout;
        @ConfigItem(defaultValue="10000")
        public int writeQueueCapacity;
    }

    @ConfigGroup
    public static class Address {
        @ConfigItem
        public String hostname;
        @ConfigItem
        public int port;
    }
}

