/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.rabbitmqclient;

import com.rabbitmq.client.AlreadyClosedException;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.MetricsCollector;
import io.quarkiverse.rabbitmqclient.RabbitMQClient;
import io.quarkiverse.rabbitmqclient.RabbitMQClientParams;
import io.quarkiverse.rabbitmqclient.RabbitMQHelper;
import io.quarkus.runtime.LaunchMode;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RabbitMQClientImpl
implements RabbitMQClient {
    private static final Logger log = LoggerFactory.getLogger(RabbitMQClientImpl.class);
    private static final int DEFAULT_CONNECTION_CLOSE_TIME_OUT_DEV_MODE = 100;
    private final Map<String, Connection> connections = new HashMap<String, Connection>();
    private final RabbitMQClientParams params;
    private final MetricsCollector metricsCollector;

    RabbitMQClientImpl(RabbitMQClientParams params, MetricsCollector metricsCollector) {
        this.params = params;
        this.metricsCollector = metricsCollector;
    }

    @Override
    public Connection connect() {
        return this.connect(UUID.randomUUID().toString());
    }

    @Override
    public Connection connect(String name) {
        log.debug("Opening connection {} with a RabbitMQ broker. Configured brokers: {}", (Object)name, RabbitMQHelper.resolveBrokerAddresses(this.params.getConfig()));
        return this.connections.computeIfAbsent(name, n -> RabbitMQHelper.newConnection(this.params, n, this.metricsCollector));
    }

    @Override
    public void disconnect() {
        this.connections.forEach((name, connection) -> {
            try {
                log.debug("Closing connection {} with RabbitMQ broker.", name);
                if (connection != null) {
                    if (this.params.getLaunchMode() == LaunchMode.DEVELOPMENT && this.params.getConfig().connectionCloseTimeout < 0) {
                        connection.close(100);
                    }
                    connection.close(this.params.getConfig().connectionCloseTimeout);
                }
                log.debug("Closed connection {} with RabbitMQ broker.", name);
            }
            catch (AlreadyClosedException ex) {
                log.debug("Already closed connection {} with RabbitMQ broker.", name);
            }
            catch (IOException e) {
                log.debug("Failed to close connection {} with RabbitMQ broker, ignoring.", name);
            }
        });
    }

    @Override
    public String getName() {
        return this.params.getName();
    }
}

