/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.rabbitmqclient;

import com.rabbitmq.client.Address;
import io.quarkiverse.rabbitmqclient.RabbitMQClientConfig;
import io.quarkiverse.rabbitmqclient.RabbitMQClientsConfig;
import io.quarkiverse.rabbitmqclient.RabbitMQHelper;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.eclipse.microprofile.health.HealthCheck;
import org.eclipse.microprofile.health.HealthCheckResponse;
import org.eclipse.microprofile.health.HealthCheckResponseBuilder;
import org.eclipse.microprofile.health.Readiness;

@Readiness
@ApplicationScoped
public class RabbitMQReadyCheck
implements HealthCheck {
    public static final String HEALTH_CHECK_NAME = "quarkus-rabbitmq-client";
    @Inject
    RabbitMQClientsConfig config;

    public HealthCheckResponse call() {
        return this.checkAllBrokers();
    }

    private HealthCheckResponse checkAllBrokers() {
        HashMap<String, List<ClientStatus>> data = new HashMap<String, List<ClientStatus>>();
        if (this.config.defaultClient != null) {
            this.appendClientState(data, null, this.config.defaultClient);
        }
        this.config.namedClients.forEach((n, c) -> this.appendClientState((Map<String, List<ClientStatus>>)data, (String)n, (RabbitMQClientConfig)c));
        HealthCheckResponseBuilder builder = HealthCheckResponse.builder();
        builder.name(HEALTH_CHECK_NAME);
        builder.status(data.values().stream().allMatch(clientStatuses -> clientStatuses.stream().anyMatch(ClientStatus::isUp)));
        data.forEach((name, clientStatuses) -> {
            Object prefix = name.length() > 0 ? name + "|" : name;
            clientStatuses.forEach(arg_0 -> RabbitMQReadyCheck.lambda$checkAllBrokers$2(builder, (String)prefix, arg_0));
        });
        return builder.build();
    }

    private void appendClientState(Map<String, List<ClientStatus>> data, String name, RabbitMQClientConfig config) {
        String clientName = name == null ? "" : name;
        data.putIfAbsent(clientName, new ArrayList());
        RabbitMQHelper.resolveBrokerAddresses(config).forEach(a -> {
            if (this.isBrokerAvailable((Address)a)) {
                ((List)data.get(clientName)).add(new ClientStatus((Address)a, true));
            } else {
                ((List)data.get(clientName)).add(new ClientStatus((Address)a, false));
            }
        });
    }

    private boolean isBrokerAvailable(Address address) {
        try {
            new Socket(address.getHost(), address.getPort());
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static /* synthetic */ void lambda$checkAllBrokers$2(HealthCheckResponseBuilder builder, String prefix, ClientStatus cs) {
        builder.withData(prefix + cs.getAddress(), cs.getStatus());
    }

    private static final class ClientStatus {
        private final Address address;
        private final boolean isUp;

        public ClientStatus(Address address, boolean isUp) {
            this.address = address;
            this.isUp = isUp;
        }

        public boolean isUp() {
            return this.isUp;
        }

        public Address getAddress() {
            return this.address;
        }

        public String getStatus() {
            return this.isUp ? HealthCheckResponse.Status.UP.name() : HealthCheckResponse.Status.DOWN.name();
        }
    }
}

