/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.rabbitmqclient;

import io.quarkiverse.rabbitmqclient.SaslType;
import io.quarkus.runtime.annotations.ConfigGroup;
import io.smallrye.config.WithDefault;
import java.util.Map;
import java.util.Optional;

@ConfigGroup
public interface RabbitMQClientConfig {
    public Optional<String> uri();

    public Map<String, Address> addresses();

    @WithDefault(value="guest")
    public String username();

    @WithDefault(value="guest")
    public String password();

    @WithDefault(value="localhost")
    public String hostname();

    @WithDefault(value="/")
    public String virtualHost();

    @WithDefault(value="-1")
    public int port();

    @WithDefault(value="60000")
    public int connectionTimeout();

    @WithDefault(value="-1")
    public int connectionCloseTimeout();

    @WithDefault(value="60")
    public int requestedHeartbeat();

    @WithDefault(value="10000")
    public int handshakeTimeout();

    @WithDefault(value="10000")
    public int shutdownTimeout();

    @WithDefault(value="2047")
    public int requestedChannelMax();

    @WithDefault(value="0")
    public int requestedFrameMax();

    @WithDefault(value="5000")
    public int networkRecoveryInterval();

    @WithDefault(value="600000")
    public int channelRpcTimeout();

    @WithDefault(value="false")
    public boolean channelRpcResponseTypeCheck();

    @WithDefault(value="true")
    public boolean connectionRecovery();

    @WithDefault(value="true")
    public boolean topologyRecovery();

    @WithDefault(value="plain")
    public SaslType sasl();

    public TlsConfig tls();

    public NioConfig nio();

    public Map<String, String> properties();

    @ConfigGroup
    public static interface TlsConfig {
        @WithDefault(value="false")
        public boolean enabled();

        @WithDefault(value="TLSv1.2")
        public String algorithm();

        public Optional<String> trustStoreFile();

        @WithDefault(value="JKS")
        public String trustStoreType();

        @WithDefault(value="SunX509")
        public String trustStoreAlgorithm();

        public Optional<String> trustStorePassword();

        public Optional<String> keyStoreFile();

        public Optional<String> keyStorePassword();

        @WithDefault(value="PKCS12")
        public String keyStoreType();

        @WithDefault(value="SunX509")
        public String keyStoreAlgorithm();

        @WithDefault(value="true")
        public boolean validateServerCertificate();

        @WithDefault(value="true")
        public boolean verifyHostname();
    }

    @ConfigGroup
    public static interface NioConfig {
        @WithDefault(value="false")
        public boolean enabled();

        @WithDefault(value="32768")
        public int readByteBufferSize();

        @WithDefault(value="32768")
        public int writeByteBufferSize();

        @WithDefault(value="1")
        public int threads();

        @WithDefault(value="10000")
        public int writeEnqueuingTimeout();

        @WithDefault(value="10000")
        public int writeQueueCapacity();
    }

    @ConfigGroup
    public static interface Address {
        public String hostname();

        public int port();
    }
}

