/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.rabbitmqclient;

import com.rabbitmq.client.AlreadyClosedException;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.MetricsCollector;
import com.rabbitmq.client.ShutdownListener;
import io.quarkiverse.rabbitmqclient.RabbitMQClient;
import io.quarkiverse.rabbitmqclient.RabbitMQClientParams;
import io.quarkiverse.rabbitmqclient.RabbitMQHelper;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RabbitMQClientImpl
implements RabbitMQClient {
    private static final Logger log = LoggerFactory.getLogger(RabbitMQClientImpl.class);
    private final Map<String, Connection> connections = new HashMap<String, Connection>();
    private final RabbitMQClientParams params;
    private final MetricsCollector metricsCollector;

    RabbitMQClientImpl(RabbitMQClientParams params, MetricsCollector metricsCollector) {
        this.params = params;
        this.metricsCollector = metricsCollector;
    }

    @Override
    public Connection connect() {
        return this.connect(UUID.randomUUID().toString());
    }

    @Override
    public Connection connect(String name) {
        log.debug("Opening connection {} with a RabbitMQ broker. Configured brokers: {}", (Object)name, RabbitMQHelper.resolveBrokerAddresses(this.params.getConfig()));
        return this.connections.computeIfAbsent(name, n -> RabbitMQHelper.newConnection(this.params, n, this.metricsCollector));
    }

    @Override
    public void disconnect() {
        CountDownLatch cdl = new CountDownLatch(this.connections.size());
        ShutdownListener l = cause -> cdl.countDown();
        int closeTimeOut = this.params.getConfig().connectionCloseTimeout();
        this.connections.forEach((name, connection) -> {
            try {
                connection.addShutdownListener(l);
                log.debug("Closing connection {} with RabbitMQ broker.", name);
                connection.close(this.params.getConfig().connectionCloseTimeout());
                log.debug("Closed connection {} with RabbitMQ broker.", name);
            }
            catch (AlreadyClosedException ex) {
                log.debug("Already closed connection {} with RabbitMQ broker.", name);
            }
            catch (IOException e) {
                log.debug("Failed to close connection {} with RabbitMQ broker, ignoring.", name);
            }
        });
        try {
            if (closeTimeOut < 0) {
                cdl.await();
            } else if (!cdl.await((long)this.params.getConfig().connectionCloseTimeout() * (long)this.connections.size(), TimeUnit.MILLISECONDS)) {
                log.warn("Disconnecting RabbitMQ client connections timed out.");
            }
        }
        catch (InterruptedException ie) {
            log.warn("Disconnecting RabbitMQ client was interrupted.", (Throwable)ie);
        }
    }

    @Override
    public String getName() {
        return this.params.getName();
    }
}

