/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.rabbitmqclient;

import com.rabbitmq.client.MetricsCollector;
import io.quarkiverse.rabbitmqclient.RabbitMQClient;
import io.quarkiverse.rabbitmqclient.RabbitMQClientImpl;
import io.quarkiverse.rabbitmqclient.RabbitMQClientParams;
import io.quarkiverse.rabbitmqclient.RabbitMQClientsConfig;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.TlsConfig;
import jakarta.inject.Singleton;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.eclipse.microprofile.context.ManagedExecutor;

@Singleton
public class RabbitMQClients {
    public static final String DEFAULT_CLIENT_NAME = "<default>";
    private final Map<String, RabbitMQClientImpl> clients;
    private final ManagedExecutor executorService;
    private final TlsConfig tlsConfig;
    private final RabbitMQClientsConfig rabbitMQClientsConfig;
    private final LaunchMode launchMode;

    public RabbitMQClients(RabbitMQClientsConfig rabbitMQClientsConfig, TlsConfig tlsConfig, ManagedExecutor executorService, LaunchMode launchMode) {
        this.rabbitMQClientsConfig = rabbitMQClientsConfig;
        this.tlsConfig = tlsConfig;
        this.executorService = executorService;
        this.clients = new HashMap<String, RabbitMQClientImpl>();
        this.launchMode = launchMode;
    }

    public RabbitMQClient getRabbitMQClient(String name) {
        return this.getRabbitMQClient(name, null);
    }

    public RabbitMQClient getRabbitMQClient(String name, MetricsCollector mc) {
        RabbitMQClientParams params = this.params(name);
        return this.clients.computeIfAbsent(name, n -> new RabbitMQClientImpl(params, mc));
    }

    private RabbitMQClientParams params(String name) {
        RabbitMQClientParams params = new RabbitMQClientParams();
        params.setName(name);
        params.setExecutorService((ExecutorService)this.executorService);
        params.setLaunchMode(this.launchMode);
        params.setTlsConfig(this.tlsConfig);
        params.setConfig(this.rabbitMQClientsConfig.clients().get(name));
        return params;
    }

    public void destroy() {
        this.clients.forEach((k, v) -> v.disconnect());
    }
}

