/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.rabbitmqclient.runtime;

import com.rabbitmq.client.MetricsCollector;
import io.quarkiverse.rabbitmqclient.RabbitMQClient;
import io.quarkiverse.rabbitmqclient.RabbitMQClients;
import io.quarkiverse.rabbitmqclient.runtime.QuarkusMPMetricsCollector;
import io.quarkiverse.rabbitmqclient.runtime.QuarkusMicrometerMetricsCollector;
import io.quarkus.arc.Arc;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.annotations.Recorder;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.function.Supplier;

@Recorder
public class RabbitMQRecorder {
    public void registerShutdownTask(ShutdownContext shutdownContext) {
        RabbitMQClients producer = (RabbitMQClients)Arc.container().instance(RabbitMQClients.class, new Annotation[0]).get();
        shutdownContext.addShutdownTask(producer::destroy);
    }

    public Supplier<RabbitMQClient> rabbitMQClientSupplier(String name) {
        RabbitMQClients producer = (RabbitMQClients)Arc.container().instance(RabbitMQClients.class, new Annotation[0]).get();
        return () -> producer.getRabbitMQClient(name);
    }

    public Supplier<RabbitMQClient> rabbitMQClientSupplierMicrometerMetrics(String name, Map<String, String> tags) {
        RabbitMQClients producer = (RabbitMQClients)Arc.container().instance(RabbitMQClients.class, new Annotation[0]).get();
        return () -> producer.getRabbitMQClient(name, (MetricsCollector)new QuarkusMicrometerMetricsCollector(tags));
    }

    public Supplier<RabbitMQClient> rabbitMQClientSupplierMPMetrics(String name, Map<String, String> tags) {
        RabbitMQClients producer = (RabbitMQClients)Arc.container().instance(RabbitMQClients.class, new Annotation[0]).get();
        return () -> producer.getRabbitMQClient(name, (MetricsCollector)new QuarkusMPMetricsCollector(tags));
    }
}

