/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.rabbitmqclient;

import com.rabbitmq.client.Address;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import com.rabbitmq.client.ConnectionFactoryConfigurator;
import com.rabbitmq.client.MetricsCollector;
import io.quarkiverse.rabbitmqclient.RabbitMQClientConfig;
import io.quarkiverse.rabbitmqclient.RabbitMQClientException;
import io.quarkiverse.rabbitmqclient.RabbitMQClientParams;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;

class RabbitMQHelper {
    static final String CLIENT_PROPERTY_PREFIX = "client-property.";

    RabbitMQHelper() {
    }

    public static Connection newConnection(RabbitMQClientParams params, String name, MetricsCollector mc) {
        try {
            RabbitMQClientConfig config = params.getConfig();
            ConnectionFactory cf = RabbitMQHelper.newConnectionFactory(params);
            if (mc != null) {
                cf.setMetricsCollector(mc);
            }
            List<Address> addresses = config.addresses().isEmpty() ? Collections.singletonList(new Address(config.hostname(), config.port())) : RabbitMQHelper.convertAddresses(config.addresses());
            return addresses == null ? cf.newConnection(name) : cf.newConnection(addresses, name);
        }
        catch (Exception e) {
            throw new RabbitMQClientException("Failed to connect to RabbitMQ broker", e);
        }
    }

    private static ConnectionFactory newConnectionFactory(RabbitMQClientParams params) {
        ConnectionFactory cf = new ConnectionFactory();
        cf.setSharedExecutor(params.getExecutorService());
        cf.setSaslConfig(params.getConfig().sasl().getSaslConfig());
        ConnectionFactoryConfigurator.load((ConnectionFactory)cf, (Properties)RabbitMQHelper.newProperties(params), (String)"");
        cf.setMaxInboundMessageBodySize(params.getConfig().maxInboundMessageBodySize());
        String uri = params.getConfig().uri().orElse(null);
        if (uri != null) {
            try {
                RabbitMQHelper.cleanUriConnectionProperties(cf);
                cf.setUri(uri);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Invalid RabbitMQ connection URI " + uri);
            }
        }
        return cf;
    }

    public static List<Address> resolveBrokerAddresses(RabbitMQClientConfig config) {
        return config.addresses().isEmpty() ? Collections.singletonList(new Address(config.hostname(), ConnectionFactory.portOrDefault((int)config.port(), (config.tls() != null && config.tls().enabled() ? 1 : 0) != 0))) : RabbitMQHelper.convertAddresses(config.addresses());
    }

    private static List<Address> convertAddresses(Map<String, RabbitMQClientConfig.Address> addresses) {
        return addresses.values().stream().map(a -> new Address(a.hostname(), a.port())).collect(Collectors.toList());
    }

    private static void cleanUriConnectionProperties(ConnectionFactory cf) {
        cf.setUsername(null);
        cf.setPassword(null);
        cf.setHost(null);
        cf.setPort(-1);
        cf.setVirtualHost(null);
    }

    static Properties newProperties(RabbitMQClientParams params) {
        Properties properties = new Properties();
        properties.setProperty("username", params.getConfig().username());
        properties.setProperty("password", params.getConfig().password());
        properties.setProperty("virtual.host", params.getConfig().virtualHost());
        properties.setProperty("host", params.getConfig().hostname());
        properties.setProperty("port", Integer.toString(params.getConfig().port()));
        properties.setProperty("connection.channel.max", Integer.toString(params.getConfig().requestedChannelMax()));
        properties.setProperty("connection.frame.max", Integer.toString(params.getConfig().requestedFrameMax()));
        properties.setProperty("connection.heartbeat", Integer.toString(params.getConfig().requestedHeartbeat()));
        properties.setProperty("connection.timeout", Integer.toString(params.getConfig().connectionTimeout()));
        properties.setProperty("handshake.timeout", Integer.toString(params.getConfig().handshakeTimeout()));
        properties.setProperty("shutdown.timeout", Integer.toString(params.getConfig().shutdownTimeout()));
        properties.setProperty("client.properties.", CLIENT_PROPERTY_PREFIX);
        params.getConfig().properties().forEach((name, value) -> properties.setProperty(CLIENT_PROPERTY_PREFIX + name, (String)value));
        properties.setProperty("connection.recovery.enabled", Boolean.toString(params.getConfig().connectionRecovery()));
        properties.setProperty("topology.recovery.enabled", Boolean.toString(params.getConfig().topologyRecovery()));
        properties.setProperty("connection.recovery.interval", Integer.toString(params.getConfig().networkRecoveryInterval()));
        properties.setProperty("channel.rpc.timeout", Integer.toString(params.getConfig().channelRpcTimeout()));
        properties.setProperty("channel.should.check.rpc.response.type", Boolean.toString(params.getConfig().channelRpcResponseTypeCheck()));
        properties.setProperty("use.nio", Boolean.toString(params.getConfig().nio().enabled()));
        properties.setProperty("nio.read.byte.buffer.size", Integer.toString(params.getConfig().nio().readByteBufferSize()));
        properties.setProperty("nio.write.byte.buffer.size", Integer.toString(params.getConfig().nio().writeByteBufferSize()));
        properties.setProperty("nio.nb.io.threads", Integer.toString(params.getConfig().nio().threads()));
        properties.setProperty("nio.write.enqueuing.timeout.in.ms", Integer.toString(params.getConfig().nio().writeEnqueuingTimeout()));
        properties.setProperty("nio.write.queue.capacity", Integer.toString(params.getConfig().nio().writeQueueCapacity()));
        if (params.getConfig().tls() != null && params.getConfig().tls().enabled()) {
            properties.setProperty("ssl.algorithm", params.getConfig().tls().algorithm());
            properties.setProperty("ssl.enabled", Boolean.toString(params.getConfig().tls().enabled()));
            properties.setProperty("ssl.validate.server.certificate", Boolean.toString(params.getConfig().tls().validateServerCertificate()));
            properties.setProperty("ssl.verify.hostname", Boolean.toString(params.getConfig().tls().verifyHostname()));
            params.getConfig().tls().keyStoreFile().ifPresent(s -> properties.setProperty("ssl.key.store", (String)s));
            params.getConfig().tls().keyStorePassword().ifPresent(s -> properties.setProperty("ssl.key.store.password", (String)s));
            properties.setProperty("ssl.key.store.type", params.getConfig().tls().keyStoreType());
            properties.setProperty("ssl.key.store.algorithm", params.getConfig().tls().keyStoreAlgorithm());
            params.getConfig().tls().trustStoreFile().ifPresent(s -> properties.setProperty("ssl.trust.store", (String)s));
            params.getConfig().tls().trustStorePassword().ifPresent(s -> properties.setProperty("ssl.trust.store.password", (String)s));
            properties.setProperty("ssl.trust.store.type", params.getConfig().tls().trustStoreType());
            properties.setProperty("ssl.trust.store.algorithm", params.getConfig().tls().trustStoreAlgorithm());
        }
        return properties;
    }
}

