/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.rabbitmqclient.runtime;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.impl.AbstractMetricsCollector;
import io.smallrye.metrics.MetricRegistries;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.MetricType;
import org.eclipse.microprofile.metrics.Tag;

public class QuarkusMPMetricsCollector
extends AbstractMetricsCollector {
    private static final String PREFIX = "rabbitmq";
    private final RabbitMQGauge connections;
    private final RabbitMQGauge channels;
    private final RabbitMQCounter publishedMessages;
    private final RabbitMQCounter failedToPublishMessages;
    private final RabbitMQCounter ackedPublishedMessages;
    private final RabbitMQCounter nackedPublishedMessages;
    private final RabbitMQCounter unroutedPublishedMessages;
    private final RabbitMQCounter consumedMessages;
    private final RabbitMQCounter acknowledgedMessages;
    private final RabbitMQCounter rejectedMessages;

    public QuarkusMPMetricsCollector(Map<String, String> tags) {
        MetricRegistry registry = MetricRegistries.get((MetricRegistry.Type)MetricRegistry.Type.VENDOR);
        Tag[] tagArray = QuarkusMPMetricsCollector.toTagArray(tags);
        this.connections = (RabbitMQGauge)Metrics.CONNECTIONS.create(registry, tagArray);
        this.channels = (RabbitMQGauge)Metrics.CHANNELS.create(registry, tagArray);
        this.publishedMessages = (RabbitMQCounter)Metrics.PUBLISHED_MESSAGES.create(registry, tagArray);
        this.failedToPublishMessages = (RabbitMQCounter)Metrics.FAILED_TO_PUBLISH_MESSAGES.create(registry, tagArray);
        this.ackedPublishedMessages = (RabbitMQCounter)Metrics.ACKED_PUBLISHED_MESSAGES.create(registry, tagArray);
        this.nackedPublishedMessages = (RabbitMQCounter)Metrics.NACKED_PUBLISHED_MESSAGES.create(registry, tagArray);
        this.unroutedPublishedMessages = (RabbitMQCounter)Metrics.UNROUTED_PUBLISHED_MESSAGES.create(registry, tagArray);
        this.consumedMessages = (RabbitMQCounter)Metrics.CONSUMED_MESSAGES.create(registry, tagArray);
        this.acknowledgedMessages = (RabbitMQCounter)Metrics.ACKNOWLEDGED_MESSAGES.create(registry, tagArray);
        this.rejectedMessages = (RabbitMQCounter)Metrics.REJECTED_MESSAGES.create(registry, tagArray);
    }

    protected void incrementConnectionCount(Connection connection) {
        this.connections.increment();
    }

    protected void decrementConnectionCount(Connection connection) {
        this.connections.decrement();
    }

    protected void incrementChannelCount(Channel channel) {
        this.channels.increment();
    }

    protected void decrementChannelCount(Channel channel) {
        this.channels.decrement();
    }

    protected void markPublishedMessage() {
        this.publishedMessages.inc();
    }

    protected void markMessagePublishFailed() {
        this.failedToPublishMessages.inc();
    }

    protected void markConsumedMessage() {
        this.consumedMessages.inc();
    }

    protected void markAcknowledgedMessage() {
        this.acknowledgedMessages.inc();
    }

    protected void markRejectedMessage() {
        this.rejectedMessages.inc();
    }

    protected void markMessagePublishAcknowledged() {
        this.ackedPublishedMessages.inc();
    }

    protected void markMessagePublishNotAcknowledged() {
        this.nackedPublishedMessages.inc();
    }

    protected void markPublishedMessageUnrouted() {
        this.unroutedPublishedMessages.inc();
    }

    private static Tag[] toTagArray(Map<String, String> tags) {
        return (Tag[])tags.entrySet().stream().map(e -> new Tag((String)e.getKey(), (String)e.getValue())).toArray(Tag[]::new);
    }

    private static Metadata meta(String name, MetricType type) {
        return Metadata.builder().withName(name).withDisplayName(name).withType(type).withUnit("none").withDescription(name).build();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum Metrics {
        CONNECTIONS{

            @Override
            Object create(MetricRegistry registry, Tag[] tags) {
                return registry.register(QuarkusMPMetricsCollector.meta("rabbitmq.connections", MetricType.GAUGE), (Metric)new RabbitMQGauge(), tags);
            }
        }
        ,
        CHANNELS{

            @Override
            Object create(MetricRegistry registry, Tag[] tags) {
                return registry.register(QuarkusMPMetricsCollector.meta("rabbitmq.channels", MetricType.GAUGE), (Metric)new RabbitMQGauge(), tags);
            }
        }
        ,
        PUBLISHED_MESSAGES{

            @Override
            Object create(MetricRegistry registry, Tag[] tags) {
                return registry.register(QuarkusMPMetricsCollector.meta("rabbitmq.published", MetricType.COUNTER), (Metric)new RabbitMQCounter(), tags);
            }
        }
        ,
        CONSUMED_MESSAGES{

            @Override
            Object create(MetricRegistry registry, Tag[] tags) {
                return registry.register(QuarkusMPMetricsCollector.meta("rabbitmq.consumed", MetricType.COUNTER), (Metric)new RabbitMQCounter(), tags);
            }
        }
        ,
        ACKNOWLEDGED_MESSAGES{

            @Override
            Object create(MetricRegistry registry, Tag[] tags) {
                return registry.register(QuarkusMPMetricsCollector.meta("rabbitmq.acknowledged", MetricType.COUNTER), (Metric)new RabbitMQCounter(), tags);
            }
        }
        ,
        REJECTED_MESSAGES{

            @Override
            Object create(MetricRegistry registry, Tag[] tags) {
                return registry.register(QuarkusMPMetricsCollector.meta("rabbitmq.rejected", MetricType.COUNTER), (Metric)new RabbitMQCounter(), tags);
            }
        }
        ,
        FAILED_TO_PUBLISH_MESSAGES{

            @Override
            Object create(MetricRegistry registry, Tag[] tags) {
                return registry.register(QuarkusMPMetricsCollector.meta("rabbitmq.failed_to_publish", MetricType.COUNTER), (Metric)new RabbitMQCounter(), tags);
            }
        }
        ,
        ACKED_PUBLISHED_MESSAGES{

            @Override
            Object create(MetricRegistry registry, Tag[] tags) {
                return registry.register(QuarkusMPMetricsCollector.meta("rabbitmq.acknowledged_published", MetricType.COUNTER), (Metric)new RabbitMQCounter(), tags);
            }
        }
        ,
        NACKED_PUBLISHED_MESSAGES{

            @Override
            Object create(MetricRegistry registry, Tag[] tags) {
                return registry.register(QuarkusMPMetricsCollector.meta("rabbitmq.not_acknowledged_published", MetricType.COUNTER), (Metric)new RabbitMQCounter(), tags);
            }
        }
        ,
        UNROUTED_PUBLISHED_MESSAGES{

            @Override
            Object create(MetricRegistry registry, Tag[] tags) {
                return registry.register(QuarkusMPMetricsCollector.meta("rabbitmq.unrouted_published", MetricType.COUNTER), (Metric)new RabbitMQCounter(), tags);
            }
        };


        abstract Object create(MetricRegistry var1, Tag[] var2);
    }

    private static class RabbitMQGauge
    implements Gauge<Long> {
        private final AtomicLong value = new AtomicLong(0L);

        private RabbitMQGauge() {
        }

        public void increment() {
            this.value.incrementAndGet();
        }

        public void decrement() {
            this.value.decrementAndGet();
        }

        public Long getValue() {
            return this.value.get();
        }
    }

    private static class RabbitMQCounter
    implements Counter {
        private final AtomicLong value = new AtomicLong(0L);

        private RabbitMQCounter() {
        }

        public void inc() {
            this.value.incrementAndGet();
        }

        public void inc(long l) {
            this.value.addAndGet(l);
        }

        public long getCount() {
            return this.value.get();
        }
    }
}

