/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.reactivemessaging.http.runtime;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OutgoingHttpMetadata {
    private final Map<String, List<String>> query;
    private final Map<String, List<String>> headers;
    private final Map<String, String> pathParameters;

    private OutgoingHttpMetadata(Map<String, String> pathParameters, Map<String, List<String>> query, Map<String, List<String>> headers) {
        this.pathParameters = pathParameters;
        this.query = query;
        this.headers = headers;
    }

    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public Map<String, List<String>> getQuery() {
        return this.query;
    }

    public Map<String, String> getPathParameters() {
        return this.pathParameters;
    }

    public static final class Builder {
        private Map<String, List<String>> query;
        private Map<String, List<String>> headers;
        private Map<String, String> pathParameters;

        public Builder addQueryParameter(String paramName, String paramValue) {
            if (this.query == null) {
                this.query = new HashMap<String, List<String>>();
            }
            this.addToMap(this.query, paramName, paramValue, false);
            return this;
        }

        public Builder replaceQueryParameter(String paramName, String paramValue) {
            if (this.query == null) {
                this.query = new HashMap<String, List<String>>();
            }
            this.addToMap(this.query, paramName, paramValue, true);
            return this;
        }

        public Builder addHeader(String headerName, String headerValue) {
            if (this.headers == null) {
                this.headers = new HashMap<String, List<String>>();
            }
            this.addToMap(this.headers, headerName, headerValue, false);
            return this;
        }

        public Builder replaceHeader(String headerName, String headerValue) {
            if (this.headers == null) {
                this.headers = new HashMap<String, List<String>>();
            }
            this.addToMap(this.headers, headerName, headerValue, true);
            return this;
        }

        private void addToMap(Map<String, List<String>> map, String headerName, String headerValue, boolean replaceExisting) {
            List values = map.computeIfAbsent(headerName, whatever -> new ArrayList());
            if (replaceExisting && !values.isEmpty()) {
                values.clear();
            }
            values.add(headerValue);
        }

        public Builder addPathParameter(String parameter, String value) {
            if (this.pathParameters == null) {
                this.pathParameters = new HashMap<String, String>();
            }
            this.pathParameters.put(parameter, value);
            return this;
        }

        public OutgoingHttpMetadata build() {
            return new OutgoingHttpMetadata(this.pathParameters == null ? Collections.emptyMap() : this.pathParameters, this.query == null ? Collections.emptyMap() : this.query, this.headers == null ? Collections.emptyMap() : this.headers);
        }
    }
}

