/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.reactivemessaging.http.runtime.converters;

import io.quarkus.reactivemessaging.http.runtime.converters.JacksonBasedConverter;
import io.vertx.core.buffer.Buffer;
import jakarta.enterprise.context.ApplicationScoped;
import java.lang.reflect.Type;
import org.eclipse.microprofile.reactive.messaging.Message;

@ApplicationScoped
public class ObjectConverter
extends JacksonBasedConverter {
    public boolean canConvert(Message<?> message, Type type) {
        if (!(type instanceof Class)) {
            return false;
        }
        Class theClass = (Class)type;
        return message.getPayload() instanceof Buffer && !Buffer.class.isAssignableFrom(theClass) && Object.class.isAssignableFrom((Class)type);
    }

    @Override
    protected Message<?> doConvert(Message<?> message, Type type) {
        Buffer buffer = (Buffer)message.getPayload();
        Object result = buffer.toJsonObject().mapTo((Class)type);
        return message.withPayload(result);
    }

    public int getPriority() {
        return Integer.MAX_VALUE;
    }
}

