/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.reactivemessaging.http.runtime;

import io.quarkus.reactivemessaging.http.runtime.IncomingHttpMetadata;
import io.smallrye.reactive.messaging.ce.CloudEventMetadata;
import io.smallrye.reactive.messaging.ce.DefaultCloudEventMetadataBuilder;
import io.smallrye.reactive.messaging.ce.OutgoingCloudEventMetadata;
import java.net.URI;
import java.time.DateTimeException;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpCloudEventHelper {
    private static final Logger logger = LoggerFactory.getLogger(HttpCloudEventHelper.class);
    private static final String[] CE_PREFIXES = new String[]{"ce-", "ce_"};
    private static final DateTimeFormatter DATE_TIME_FORMATTER = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd'T'HH:mm:ss").optionalStart().appendFraction(ChronoField.MILLI_OF_SECOND, 0, 3, true).optionalEnd().appendOffset("+HH:MM", "Z").toFormatter();

    public static Optional<CloudEventMetadata<?>> getBinaryCloudEvent(IncomingHttpMetadata metadata) {
        DefaultCloudEventMetadataBuilder builder = new DefaultCloudEventMetadataBuilder();
        boolean hasCloudMeta = false;
        for (Map.Entry entry : metadata.getHeaders().entries()) {
            hasCloudMeta |= HttpCloudEventHelper.getCEAttribute(builder, (String)entry.getKey(), (String)entry.getValue());
        }
        return hasCloudMeta ? Optional.of(builder.build()) : Optional.empty();
    }

    public static Map<String, String> getCloudEventHeaders(Message<?> message) {
        return message.getMetadata(OutgoingCloudEventMetadata.class).map(HttpCloudEventHelper::getCloudEventHeaders).orElse(Collections.emptyMap());
    }

    private static Map<String, String> getCloudEventHeaders(OutgoingCloudEventMetadata<?> metadata) {
        HashMap<String, String> map = new HashMap<String, String>();
        metadata.getDataContentType().ifPresent(v -> map.put(HttpCloudEventHelper.header("datacontenttype"), (String)v));
        metadata.getDataSchema().ifPresent(v -> map.put(HttpCloudEventHelper.header("dataschema"), v.toString()));
        metadata.getSubject().ifPresent(v -> map.put(HttpCloudEventHelper.header("subject"), (String)v));
        metadata.getTimeStamp().ifPresent(v -> map.put(HttpCloudEventHelper.header("time"), DATE_TIME_FORMATTER.format((TemporalAccessor)v)));
        map.put(HttpCloudEventHelper.header("id"), metadata.getId());
        if (metadata.getSource() != null) {
            map.put(HttpCloudEventHelper.header("source"), metadata.getSource().toString());
        }
        map.put(HttpCloudEventHelper.header("specversion"), metadata.getSpecVersion());
        map.put(HttpCloudEventHelper.header("type"), metadata.getType());
        metadata.getExtensions().forEach((k, v) -> map.put(HttpCloudEventHelper.header(k), v.toString()));
        return map;
    }

    private static String header(String key) {
        return CE_PREFIXES[0] + key;
    }

    private static boolean getCEAttribute(DefaultCloudEventMetadataBuilder<?> builder, String key, String value) {
        String lowerCase = key.toLowerCase();
        boolean sucessfulSet = false;
        for (String prefix : CE_PREFIXES) {
            if (!lowerCase.startsWith(prefix)) continue;
            try {
                String extractKey;
                switch (extractKey = lowerCase.substring(prefix.length())) {
                    case "id": {
                        builder.withId(value);
                        break;
                    }
                    case "source": {
                        builder.withSource(URI.create(value));
                        break;
                    }
                    case "specversion": {
                        builder.withSpecVersion(value);
                        break;
                    }
                    case "subject": {
                        builder.withSubject(value);
                        break;
                    }
                    case "time": {
                        builder.withTimestamp(ZonedDateTime.parse(value));
                        break;
                    }
                    case "type": {
                        builder.withType(value);
                        break;
                    }
                    case "datacontenttype": {
                        builder.withDataContentType(value);
                        break;
                    }
                    case "dataschema": {
                        builder.withDataSchema(URI.create(value));
                        break;
                    }
                    default: {
                        logger.info("Unrecognized CE attribute {}, assuming extension", (Object)key);
                        builder.withExtension(extractKey, (Object)value);
                    }
                }
                sucessfulSet = true;
            }
            catch (IllegalArgumentException | DateTimeException ex) {
                logger.error("Error setting value {} for attribute {}", new Object[]{key, value, ex});
            }
        }
        return sucessfulSet;
    }

    private HttpCloudEventHelper() {
    }
}

