/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.reactivemessaging.http.runtime;

import java.util.Optional;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;

public class QuarkusHttpConnectorCommonConfiguration {
    protected final Config config;

    public QuarkusHttpConnectorCommonConfiguration(Config config) {
        this.config = config;
    }

    public Config config() {
        return this.config;
    }

    protected <T> Optional<T> getFromAlias(String alias, Class<T> type) {
        return ConfigProvider.getConfig().getOptionalValue(alias, type);
    }

    protected <T> T getFromAliasWithDefaultValue(String alias, Class<T> type, T defaultValue) {
        return this.getFromAlias(alias, type).orElse(defaultValue);
    }

    public String getChannel() {
        return (String)this.config.getValue("channel-name", String.class);
    }

    public String getMethod() {
        return this.config.getOptionalValue("method", String.class).orElse("POST");
    }

    public void validate() {
    }
}

