/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.reactivemessaging.http.runtime.serializers;

import io.quarkus.reactivemessaging.http.runtime.serializers.Deserializer;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public abstract class DeserializerFactoryBase {
    private final Map<String, Deserializer<?>> deserializersByClassName = new HashMap();

    protected DeserializerFactoryBase() {
        this.initAdditionalSerializers();
    }

    public <T> Optional<Deserializer<T>> getDeserializer(String name) {
        return name != null ? Optional.ofNullable(this.deserializersByClassName.get(name)) : Optional.empty();
    }

    public void addSerializer(String className, Deserializer<?> serializer) {
        this.deserializersByClassName.put(className, serializer);
    }

    protected abstract void initAdditionalSerializers();
}

