/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.reactivemessaging.http.runtime.config;

import io.quarkus.reactivemessaging.http.runtime.QuarkusHttpConnector;
import io.quarkus.reactivemessaging.http.runtime.QuarkusWebSocketConnector;
import io.quarkus.reactivemessaging.http.runtime.config.HttpStreamConfig;
import io.quarkus.reactivemessaging.http.runtime.config.WebSocketStreamConfig;
import jakarta.annotation.PostConstruct;
import jakarta.inject.Singleton;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.config.spi.ConfigProviderResolver;

@Singleton
public class ReactiveHttpConfig {
    private static final String CONNECTOR = ".connector";
    private static final String MP_MSG_IN = "mp.messaging.incoming.";
    private static final String IN_KEY = "mp.messaging.incoming.%s.%s";
    private static final Pattern IN_PATTERN = Pattern.compile(Pattern.quote("mp.messaging.incoming.") + "[^.]+" + Pattern.quote(".connector"));
    private static final String MP_MSG_OUT = "mp.messaging.outgoing.";
    private static final String OUT_KEY = "mp.messaging.outgoing.%s.%s";
    private static final Pattern OUT_PATTERN = Pattern.compile(Pattern.quote("mp.messaging.outgoing.") + "[^.]+" + Pattern.quote(".connector"));
    private List<HttpStreamConfig> httpConfigs;
    private List<WebSocketStreamConfig> websocketConfigs;

    public List<HttpStreamConfig> getHttpConfigs() {
        return this.httpConfigs;
    }

    public List<WebSocketStreamConfig> getWebSocketConfigs() {
        return this.websocketConfigs;
    }

    @PostConstruct
    void init() {
        this.httpConfigs = ReactiveHttpConfig.readIncomingHttpConfigs();
        this.websocketConfigs = ReactiveHttpConfig.readIncomingWebSocketConfigs();
    }

    public static List<HttpStreamConfig> readIncomingHttpConfigs() {
        ArrayList<HttpStreamConfig> streamConfigs = new ArrayList<HttpStreamConfig>();
        Config config = ConfigProviderResolver.instance().getConfig();
        for (String propertyName : config.getPropertyNames()) {
            String connectorName = ReactiveHttpConfig.getConnectorNameIfMatching(IN_PATTERN, propertyName, IN_KEY, MP_MSG_IN, "quarkus-http");
            if (connectorName == null) continue;
            String method = ReactiveHttpConfig.getConfigProperty(IN_KEY, connectorName, "method", "POST", String.class);
            String path = ReactiveHttpConfig.getConfigProperty(IN_KEY, connectorName, "path", String.class);
            int bufferSize = ReactiveHttpConfig.getConfigProperty(IN_KEY, connectorName, "buffer-size", QuarkusHttpConnector.DEFAULT_SOURCE_BUFFER, Integer.class);
            String deserializerName = ReactiveHttpConfig.getConfigProperty(IN_KEY, connectorName, "deserializer", null, String.class);
            streamConfigs.add(new HttpStreamConfig(path, method, connectorName, bufferSize, deserializerName));
        }
        return streamConfigs;
    }

    public static List<WebSocketStreamConfig> readIncomingWebSocketConfigs() {
        ArrayList<WebSocketStreamConfig> streamConfigs = new ArrayList<WebSocketStreamConfig>();
        Config config = ConfigProviderResolver.instance().getConfig();
        for (String propertyName : config.getPropertyNames()) {
            String connectorName = ReactiveHttpConfig.getConnectorNameIfMatching(IN_PATTERN, propertyName, IN_KEY, MP_MSG_IN, "quarkus-websocket");
            if (connectorName == null) continue;
            String path = ReactiveHttpConfig.getConfigProperty(IN_KEY, connectorName, "path", String.class);
            int bufferSize = ReactiveHttpConfig.getConfigProperty(IN_KEY, connectorName, "buffer-size", QuarkusWebSocketConnector.DEFAULT_SOURCE_BUFFER, Integer.class);
            String deserializerName = ReactiveHttpConfig.getConfigProperty(IN_KEY, connectorName, "deserializer", null, String.class);
            streamConfigs.add(new WebSocketStreamConfig(path, bufferSize, deserializerName));
        }
        return streamConfigs;
    }

    public static List<String> readSerializers() {
        return ReactiveHttpConfig.readSerializers(OUT_PATTERN, OUT_KEY, MP_MSG_OUT, "serializer");
    }

    public static List<String> readDeserializers() {
        return ReactiveHttpConfig.readSerializers(IN_PATTERN, IN_KEY, MP_MSG_IN, "deserializer");
    }

    private static List<String> readSerializers(Pattern pattern, String key, String message, String serializerKey) {
        ArrayList<String> result = new ArrayList<String>();
        Config config = ConfigProviderResolver.instance().getConfig();
        for (String propertyName : config.getPropertyNames()) {
            String serializer;
            String connectorName = ReactiveHttpConfig.getConnectorNameIfMatching(pattern, propertyName, key, message, "quarkus-websocket");
            if (connectorName == null) {
                connectorName = ReactiveHttpConfig.getConnectorNameIfMatching(pattern, propertyName, key, message, "quarkus-http");
            }
            if (connectorName == null || (serializer = ReactiveHttpConfig.getConfigProperty(key, connectorName, serializerKey, null, String.class)) == null) continue;
            result.add(serializer);
        }
        return result;
    }

    private static String getConnectorNameIfMatching(Pattern connectorPropertyPattern, String propertyName, String format, String prefix, String expectedConnectorType) {
        Matcher matcher = connectorPropertyPattern.matcher(propertyName);
        if (matcher.matches()) {
            String connectorName = propertyName.substring(prefix.length(), propertyName.length() - CONNECTOR.length());
            String connectorType = ReactiveHttpConfig.getConfigProperty(format, connectorName, "connector", String.class);
            boolean matches = expectedConnectorType.equals(connectorType);
            return matches ? connectorName : null;
        }
        return null;
    }

    private static <T> T getConfigProperty(String format, String connectorName, String property, T defValue, Class<T> type) {
        String key = String.format(format, connectorName, property);
        return ConfigProvider.getConfig().getOptionalValue(key, type).orElse(defValue);
    }

    private static <T> T getConfigProperty(String format, String connectorName, String property, Class<T> type) {
        String key = String.format(format, connectorName, property);
        return ConfigProvider.getConfig().getOptionalValue(key, type).orElseThrow(() -> ReactiveHttpConfig.noPropertyFound(connectorName, property));
    }

    private static IllegalStateException noPropertyFound(String key, String propertyName) {
        String message = String.format("No %s defined for reactive http connector '%s'", propertyName, key);
        return new IllegalStateException(message);
    }
}

