/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.renarde.backoffice.deployment;

import io.quarkiverse.renarde.Controller;
import io.quarkiverse.renarde.backoffice.BackofficeController;
import io.quarkiverse.renarde.backoffice.BackofficeIndexController;
import io.quarkiverse.renarde.backoffice.impl.BackUtil;
import io.quarkiverse.renarde.backoffice.impl.CreateAction;
import io.quarkiverse.renarde.backoffice.impl.EditAction;
import io.quarkiverse.renarde.jpa.NamedBlob;
import io.quarkiverse.renarde.jpa.deployment.ModelField;
import io.quarkus.arc.Arc;
import io.quarkus.arc.ArcContainer;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.ApplicationArchivesBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.GeneratedResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.gizmo.AssignableResultHandle;
import io.quarkus.gizmo.BranchResult;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.hibernate.orm.panache.PanacheEntityBase;
import io.quarkus.panache.common.deployment.EntityField;
import io.quarkus.panache.common.deployment.EntityModel;
import io.quarkus.panache.common.deployment.HibernateMetamodelForFieldAccessBuildItem;
import io.quarkus.panache.common.deployment.MetamodelInfo;
import io.quarkus.qute.Engine;
import io.quarkus.qute.ReflectionValueResolver;
import io.quarkus.qute.Template;
import io.quarkus.qute.TemplateInstance;
import io.quarkus.qute.TemplateLocator;
import io.quarkus.qute.ValueResolver;
import io.quarkus.qute.Variant;
import io.quarkus.qute.deployment.TemplatePathBuildItem;
import io.quarkus.qute.runtime.TemplateProducer;
import io.quarkus.resteasy.reactive.spi.GeneratedJaxRsResourceBuildItem;
import io.quarkus.resteasy.reactive.spi.GeneratedJaxRsResourceGizmoAdaptor;
import io.smallrye.common.annotation.Blocking;
import jakarta.enterprise.context.RequestScoped;
import jakarta.persistence.Entity;
import jakarta.transaction.Transactional;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.sql.Blob;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Type;
import org.jboss.resteasy.reactive.RestForm;
import org.jboss.resteasy.reactive.RestPath;
import org.jboss.resteasy.reactive.multipart.FileUpload;

public class RenardeBackofficeProcessor {
    public static final String URI_PREFIX_NO_SLASH = "_renarde/backoffice";
    public static final String URI_PREFIX = "/_renarde/backoffice";
    public static final String PACKAGE_PREFIX = "rest._renarde.backoffice";
    private static final DotName DOTNAME_ENTITY = DotName.createSimple((String)Entity.class.getName());
    private static final DotName DOTNAME_BACKOFFICE_CONTROLLER = DotName.createSimple(BackofficeController.class);
    private static final DotName DOTNAME_BACKOFFICE_INDEX_CONTROLLER = DotName.createSimple(BackofficeIndexController.class);
    private static final DotName DOTNAME_COMPARABLE = DotName.createSimple(Comparable.class);

    @BuildStep
    void produceBeans(BuildProducer<AdditionalBeanBuildItem> additionalBeanBuildItems) {
        additionalBeanBuildItems.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(BackUtil.class));
    }

    @BuildStep
    public void processModel(HibernateMetamodelForFieldAccessBuildItem metamodel, CombinedIndexBuildItem index, BuildProducer<GeneratedResourceBuildItem> output, BuildProducer<NativeImageResourceBuildItem> nativeImageResources, BuildProducer<TemplatePathBuildItem> templates, BuildProducer<GeneratedJaxRsResourceBuildItem> jaxrsOutput, ApplicationArchivesBuildItem applicationArchives) {
        Engine engine = Engine.builder().addDefaults().addValueResolver((ValueResolver)new ReflectionValueResolver()).addLocator(new TemplateLocator(){

            public Optional<TemplateLocator.TemplateLocation> locate(final String id) {
                URL url = RenardeBackofficeProcessor.class.getClassLoader().getResource("templates/" + id);
                if (url == null) {
                    return Optional.empty();
                }
                return Optional.of(new TemplateLocator.TemplateLocation(){

                    public Reader read() {
                        return new InputStreamReader(RenardeBackofficeProcessor.class.getClassLoader().getResourceAsStream("templates/" + id), StandardCharsets.UTF_8);
                    }

                    public Optional<Variant> getVariant() {
                        return Optional.empty();
                    }
                });
            }
        }).build();
        Collection entityControllers = index.getIndex().getAllKnownSubclasses(DOTNAME_BACKOFFICE_CONTROLLER);
        Collection indexControllers = index.getIndex().getAllKnownSubclasses(DOTNAME_BACKOFFICE_INDEX_CONTROLLER);
        if (indexControllers.size() > 1) {
            throw new RuntimeException("More than one subclass of " + DOTNAME_BACKOFFICE_INDEX_CONTROLLER + " is not allowed: " + indexControllers);
        }
        String mainTemplate = "_renarde/backoffice/main.html";
        TemplateInstance template = engine.getTemplate("main.qute").instance();
        this.render(output, nativeImageResources, templates, template, "main.html");
        this.generateAllController(jaxrsOutput, indexControllers);
        ArrayList<String> entities = new ArrayList<String>();
        for (ClassInfo entityController : entityControllers) {
            Type entityType = (Type)entityController.superClassType().asParameterizedType().arguments().get(0);
            DotName entityName = entityType.asClassType().name();
            ClassInfo classInfo = index.getIndex().getClassByName(entityName);
            if (classInfo.declaredAnnotation(DOTNAME_ENTITY) == null) continue;
            EntityModel entityModel = metamodel.getMetamodelInfo().getEntityModel(entityName.toString());
            String simpleName = entityModel.name;
            int nameLastDot = simpleName.lastIndexOf(46);
            if (nameLastDot != -1) {
                simpleName = simpleName.substring(nameLastDot + 1);
            }
            entities.add(simpleName);
            List<ModelField> fields = ModelField.loadModelFields((EntityModel)entityModel, (MetamodelInfo)metamodel.getMetamodelInfo(), (IndexView)index.getIndex());
            fields = fields.stream().filter(modelField -> !modelField.id).collect(Collectors.toList());
            this.generateEntityController(classInfo, index.getIndex(), entityName.toString(), entityController, simpleName, fields, jaxrsOutput);
            TemplateInstance indexTemplate = engine.getTemplate("entity-index.qute").instance();
            indexTemplate.data("entity", (Object)simpleName);
            indexTemplate.data("entityClass", (Object)entityName.toString());
            indexTemplate.data("mainTemplate", (Object)mainTemplate);
            this.render(output, nativeImageResources, templates, indexTemplate, simpleName + "/index.html");
            TemplateInstance editTemplate = engine.getTemplate("entity-edit.qute").instance();
            editTemplate.data("entity", (Object)simpleName);
            editTemplate.data("entityClass", (Object)entityName.toString());
            editTemplate.data("fields", fields);
            editTemplate.data("mainTemplate", (Object)mainTemplate);
            this.render(output, nativeImageResources, templates, editTemplate, simpleName + "/edit.html");
            TemplateInstance createTemplate = engine.getTemplate("entity-create.qute").instance();
            createTemplate.data("entity", (Object)simpleName);
            createTemplate.data("fields", fields);
            createTemplate.data("mainTemplate", (Object)mainTemplate);
            this.render(output, nativeImageResources, templates, createTemplate, simpleName + "/create.html");
        }
        Collections.sort(entities);
        template = engine.getTemplate("index.qute").instance();
        template.data("entities", entities);
        template.data("mainTemplate", (Object)mainTemplate);
        this.render(output, nativeImageResources, templates, template, "index.html");
    }

    private void render(BuildProducer<GeneratedResourceBuildItem> output, BuildProducer<NativeImageResourceBuildItem> nativeImageResources, BuildProducer<TemplatePathBuildItem> templates, TemplateInstance template, String templateId) {
        String path = "templates/_renarde/backoffice/" + templateId;
        String rendered = template.render();
        output.produce((BuildItem)new GeneratedResourceBuildItem(path, rendered.getBytes(StandardCharsets.UTF_8)));
        nativeImageResources.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{path}));
        templates.produce((BuildItem)new TemplatePathBuildItem(path.substring(10), Path.of(path, new String[0]), rendered));
    }

    private void generateEntityController(ClassInfo entityClass, IndexView index, String entityClassName, ClassInfo entityController, String simpleName, List<ModelField> fields, BuildProducer<GeneratedJaxRsResourceBuildItem> jaxrsOutput) {
        String controllerClass = "rest._renarde.backoffice." + simpleName + "Controller";
        try (ClassCreator c = ClassCreator.builder().classOutput((ClassOutput)new GeneratedJaxRsResourceGizmoAdaptor(jaxrsOutput)).className(controllerClass).superClass(entityController.name().toString()).build();){
            for (AnnotationInstance annotationInstance : entityController.declaredAnnotations()) {
                c.addAnnotation(annotationInstance);
            }
            c.addAnnotation(Blocking.class.getName());
            c.addAnnotation(RequestScoped.class.getName());
            c.addAnnotation(jakarta.ws.rs.Path.class).addValue("value", (Object)("/_renarde/backoffice/" + simpleName));
            try (MethodCreator m = c.getMethodCreator("index", TemplateInstance.class, new Class[0]);){
                m.addAnnotation(jakarta.ws.rs.Path.class).addValue("value", (Object)"index");
                m.addAnnotation(GET.class);
                m.addAnnotation(Produces.class).addValue("value", (Object)new String[]{"text/html"});
                ResultHandle entities = m.invokeStaticMethod(MethodDescriptor.ofMethod((Object)entityClassName, (String)"listAll", List.class, (Object[])new Object[0]), new ResultHandle[0]);
                if (this.implementsInterface(entityClass, index, DOTNAME_COMPARABLE)) {
                    m.invokeStaticMethod(MethodDescriptor.ofMethod(Collections.class, (String)"sort", Void.TYPE, (Class[])new Class[]{List.class}), new ResultHandle[]{entities});
                }
                ResultHandle instance = this.getTemplateInstance(m, "_renarde/backoffice/" + simpleName + "/index");
                instance = m.invokeInterfaceMethod(MethodDescriptor.ofMethod(TemplateInstance.class, (String)"data", TemplateInstance.class, (Class[])new Class[]{String.class, Object.class}), instance, new ResultHandle[]{m.load("entities"), entities});
                m.returnValue(instance);
            }
            m = c.getMethodCreator("edit", TemplateInstance.class, new Class[]{Long.class});
            try {
                this.editOrCreateView(m, controllerClass, entityClassName, simpleName, fields, Mode.EDIT);
            }
            finally {
                if (m != null) {
                    m.close();
                }
            }
            this.editOrCreateAction(c, controllerClass, entityClassName, simpleName, fields, Mode.EDIT);
            m = c.getMethodCreator("create", TemplateInstance.class, new Class[0]);
            try {
                this.editOrCreateView(m, controllerClass, entityClassName, simpleName, fields, Mode.CREATE);
            }
            finally {
                if (m != null) {
                    m.close();
                }
            }
            this.editOrCreateAction(c, controllerClass, entityClassName, simpleName, fields, Mode.CREATE);
            this.deleteAction(c, controllerClass, entityClassName, simpleName);
            this.addBinaryFieldGetters(c, controllerClass, entityClassName, fields);
        }
    }

    private boolean implementsInterface(ClassInfo entityClass, IndexView index, DotName searchedInterface) {
        HashSet<DotName> scanned = new HashSet<DotName>();
        return this.implementsInterface(entityClass, index, searchedInterface, scanned);
    }

    private boolean implementsInterface(ClassInfo entityClass, IndexView index, DotName searchedInterface, Set<DotName> scanned) {
        for (DotName interfaceName : entityClass.interfaceNames()) {
            boolean found;
            if (!scanned.add(interfaceName)) continue;
            if (interfaceName.equals((Object)searchedInterface)) {
                return true;
            }
            ClassInfo interfaceClass = index.getClassByName(interfaceName);
            if (interfaceClass == null || !(found = this.implementsInterface(interfaceClass, index, searchedInterface))) continue;
            return true;
        }
        DotName superName = entityClass.superName();
        if (superName != null) {
            ClassInfo superClass = index.getClassByName(superName);
            if (!scanned.add(superName)) {
                return false;
            }
            if (superClass != null) {
                return this.implementsInterface(superClass, index, searchedInterface);
            }
        }
        return false;
    }

    private void addBinaryFieldGetters(ClassCreator c, String controllerClass, String entityClass, List<ModelField> fields) {
        for (ModelField field : fields) {
            if (field.type != ModelField.Type.Binary) continue;
            MethodCreator m = c.getMethodCreator(field.name + "ForBinary", Response.class, new Class[]{Long.class});
            try {
                ResultHandle response;
                m.getParameterAnnotations(0).addAnnotation(RestPath.class).addValue("value", (Object)"id");
                m.addAnnotation(jakarta.ws.rs.Path.class).addValue("value", (Object)("{id}/" + field.name));
                m.addAnnotation(GET.class);
                m.addAnnotation(Transactional.class);
                m.addAnnotation(Produces.class).addValue("value", (Object)new String[]{"application/octet-stream"});
                AssignableResultHandle entityVariable = this.findEntityById(m, controllerClass, entityClass);
                ResultHandle fieldValue = m.invokeVirtualMethod(MethodDescriptor.ofMethod((String)entityClass, (String)field.entityField.getGetterName(), (String)field.entityField.descriptor, (String[])new String[0]), (ResultHandle)entityVariable, new ResultHandle[0]);
                if (field.entityField.descriptor.equals("[B")) {
                    response = m.invokeStaticMethod(MethodDescriptor.ofMethod(BackUtil.class, (String)"binaryResponse", Response.class, (Class[])new Class[]{byte[].class}), new ResultHandle[]{fieldValue});
                    m.returnValue(response);
                    continue;
                }
                if (field.entityField.descriptor.equals("Ljava/sql/Blob;")) {
                    response = m.invokeStaticMethod(MethodDescriptor.ofMethod(BackUtil.class, (String)"binaryResponse", Response.class, (Class[])new Class[]{Blob.class}), new ResultHandle[]{fieldValue});
                    m.returnValue(response);
                    continue;
                }
                if (field.entityField.descriptor.equals(ModelField.NAMED_BLOB_DESCRIPTOR)) {
                    response = m.invokeStaticMethod(MethodDescriptor.ofMethod(BackUtil.class, (String)"binaryResponse", Response.class, (Class[])new Class[]{NamedBlob.class}), new ResultHandle[]{fieldValue});
                    m.returnValue(response);
                    continue;
                }
                throw new RuntimeException("Unknown binary field " + field + " descriptor: " + field.entityField.descriptor);
            }
            finally {
                if (m == null) continue;
                m.close();
            }
        }
    }

    private void deleteAction(ClassCreator c, String controllerClass, String entityClass, String simpleName) {
        try (MethodCreator m = c.getMethodCreator("delete", Void.TYPE, new Class[]{Long.class});){
            m.getParameterAnnotations(0).addAnnotation(RestPath.class).addValue("value", (Object)"id");
            m.addAnnotation(jakarta.ws.rs.Path.class).addValue("value", (Object)"delete/{id}");
            m.addAnnotation(POST.class);
            m.addAnnotation(Transactional.class);
            AssignableResultHandle variable = this.findEntityById(m, controllerClass, entityClass);
            m.invokeVirtualMethod(MethodDescriptor.ofMethod((Object)entityClass, (String)"delete", Void.TYPE, (Object[])new Object[0]), (ResultHandle)variable, new ResultHandle[0]);
            ResultHandle message = m.newInstance(MethodDescriptor.ofConstructor(StringBuilder.class, (Class[])new Class[]{String.class}), new ResultHandle[]{m.load("Deleted: ")});
            message = m.invokeVirtualMethod(MethodDescriptor.ofMethod(StringBuilder.class, (String)"append", StringBuilder.class, (Class[])new Class[]{Object.class}), message, new ResultHandle[]{variable});
            message = m.invokeVirtualMethod(MethodDescriptor.ofMethod(StringBuilder.class, (String)"toString", String.class, (Class[])new Class[0]), message, new ResultHandle[0]);
            m.invokeVirtualMethod(MethodDescriptor.ofMethod((Object)controllerClass, (String)"flash", Void.TYPE, (Object[])new Object[]{String.class, Object.class}), m.getThis(), new ResultHandle[]{m.load("message"), message});
            m.invokeVirtualMethod(MethodDescriptor.ofMethod((Object)controllerClass, (String)"seeOther", Response.class, (Object[])new Object[]{String.class}), m.getThis(), new ResultHandle[]{m.load("/_renarde/backoffice/" + simpleName + "/index")});
            m.returnValue(null);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void editOrCreateAction(ClassCreator c, String controllerClass, String entityClass, String simpleName, List<ModelField> fields, Mode mode) {
        String[] parameterNames;
        int neededParams = 1;
        if (mode == Mode.EDIT) {
            ++neededParams;
        }
        for (ModelField field : fields) {
            if (field.type == ModelField.Type.Binary) {
                ++neededParams;
            }
            ++neededParams;
        }
        int offset = 0;
        StringBuilder signature = new StringBuilder("(");
        Object[] editParams = new String[neededParams];
        if (mode == Mode.EDIT) {
            editParams[0] = Long.class.getName();
            editParams[1] = EditAction.class.getName();
            signature.append("Ljava/lang/Long;");
            signature.append("L" + EditAction.class.getName().replace('.', '/') + ";");
            offset = 2;
            parameterNames = new String[editParams.length];
            parameterNames[0] = "id";
            parameterNames[1] = "action";
        } else {
            editParams[0] = CreateAction.class.getName();
            signature.append("L" + CreateAction.class.getName().replace('.', '/') + ";");
            offset = 1;
            parameterNames = new String[editParams.length];
            parameterNames[0] = "action";
        }
        int i = 0;
        for (ModelField modelField : fields) {
            if (modelField.type == ModelField.Type.MultiRelation || modelField.type == ModelField.Type.MultiMultiRelation) {
                editParams[i + offset] = List.class.getName();
                signature.append("Ljava/util/List<Ljava/lang/String;>;");
            } else if (modelField.type == ModelField.Type.Binary) {
                editParams[i + offset] = String.class.getName();
                editParams[i + offset + 1] = FileUpload.class.getName();
                signature.append("Ljava/lang/String;");
                signature.append("L" + FileUpload.class.getName().replace('.', '/') + ";");
                ++i;
            } else {
                editParams[i + offset] = String.class.getName();
                signature.append("Ljava/lang/String;");
            }
            ++i;
        }
        signature.append(")V");
        try (MethodCreator m = c.getMethodCreator(mode == Mode.CREATE ? "create" : "edit", Void.TYPE, editParams);){
            BytecodeCreator fb;
            String indexTarget;
            BytecodeCreator tb;
            AssignableResultHandle entityVariable;
            m.setSignature(signature.toString());
            if (mode == Mode.EDIT) {
                m.getParameterAnnotations(0).addAnnotation(RestPath.class).addValue("value", (Object)"id");
                m.getParameterAnnotations(1).addAnnotation(RestForm.class).addValue("value", (Object)"action");
            } else {
                m.getParameterAnnotations(0).addAnnotation(RestForm.class).addValue("value", (Object)"action");
            }
            i = 0;
            for (ModelField field : fields) {
                if (field.type == ModelField.Type.Binary) {
                    m.getParameterAnnotations(i + offset).addAnnotation(RestForm.class).addValue("value", (Object)(field.name + "$unset"));
                    parameterNames[i + offset] = field.name + "$unset";
                    ++i;
                }
                m.getParameterAnnotations(i + offset).addAnnotation(RestForm.class).addValue("value", (Object)field.name);
                for (Class validationAnnotation : field.validation) {
                    m.getParameterAnnotations(i + offset).addAnnotation(validationAnnotation);
                }
                parameterNames[i + offset] = field.name;
                ++i;
            }
            m.setParameterNames(parameterNames);
            m.addAnnotation(Consumes.class).addValue("value", (Object)new String[]{"multipart/form-data"});
            m.addAnnotation(jakarta.ws.rs.Path.class).addValue("value", (Object)(mode == Mode.CREATE ? "create" : "edit/{id}"));
            m.addAnnotation(POST.class);
            m.addAnnotation(Transactional.class);
            String string = "/_renarde/backoffice/" + simpleName + (mode == Mode.CREATE ? "/create" : "/edit/");
            BranchResult validation = m.ifTrue(m.invokeVirtualMethod(MethodDescriptor.ofMethod((Object)controllerClass, (String)"validationFailed", Boolean.TYPE, (Object[])new Object[0]), m.getThis(), new ResultHandle[0]));
            try (BytecodeCreator tb2 = validation.trueBranch();){
                this.redirectToAction(tb2, controllerClass, string, simpleName, mode == Mode.CREATE ? null : () -> tb2.getMethodParam(0));
            }
            if (mode == Mode.EDIT) {
                entityVariable = this.findEntityById(m, controllerClass, entityClass);
            } else {
                String entityTypeDescriptor = "L" + entityClass.replace('.', '/') + ";";
                entityVariable = m.createVariable(entityTypeDescriptor);
                m.assign(entityVariable, m.newInstance(MethodDescriptor.ofConstructor((String)entityClass, (String[])new String[0]), new ResultHandle[0]));
            }
            i = 0;
            for (ModelField field : fields) {
                ResultHandle value = null;
                ResultHandle parameterValue = m.getMethodParam(i + offset);
                ++i;
                if (field.type == ModelField.Type.Text || field.type == ModelField.Type.LargeText) {
                    if (field.entityField.descriptor.equals("Ljava/lang/String;")) {
                        value = m.invokeStaticMethod(MethodDescriptor.ofMethod(BackUtil.class, (String)"stringField", String.class, (Class[])new Class[]{String.class}), new ResultHandle[]{parameterValue});
                    } else {
                        if (!field.entityField.descriptor.equals("C")) throw new RuntimeException("Unknown text field " + field + " descriptor: " + field.entityField.descriptor);
                        value = m.invokeStaticMethod(MethodDescriptor.ofMethod(BackUtil.class, (String)"charField", Character.TYPE, (Class[])new Class[]{String.class}), new ResultHandle[]{parameterValue});
                    }
                } else {
                    if (field.type == ModelField.Type.Binary) {
                        ResultHandle parameterUnsetValue = parameterValue;
                        parameterValue = m.getMethodParam(i + offset);
                        ++i;
                        String hasValueTest = m.ifTrue(m.invokeStaticMethod(MethodDescriptor.ofMethod(BackUtil.class, (String)"isSet", Boolean.TYPE, (Class[])new Class[]{FileUpload.class}), new ResultHandle[]{parameterValue}));
                        try (BytecodeCreator hasValueTrueBranch = hasValueTest.trueBranch();){
                            ResultHandle uploadValue;
                            if (field.entityField.descriptor.equals("[B")) {
                                uploadValue = hasValueTrueBranch.invokeStaticMethod(MethodDescriptor.ofMethod(BackUtil.class, (String)"byteArrayField", byte[].class, (Class[])new Class[]{FileUpload.class}), new ResultHandle[]{parameterValue});
                            } else if (field.entityField.descriptor.equals("Ljava/sql/Blob;")) {
                                uploadValue = hasValueTrueBranch.invokeStaticMethod(MethodDescriptor.ofMethod(BackUtil.class, (String)"blobField", Blob.class, (Class[])new Class[]{FileUpload.class}), new ResultHandle[]{parameterValue});
                            } else {
                                if (!field.entityField.descriptor.equals(ModelField.NAMED_BLOB_DESCRIPTOR)) throw new RuntimeException("Unknown binary field " + field + " descriptor: " + field.entityField.descriptor);
                                uploadValue = hasValueTrueBranch.invokeStaticMethod(MethodDescriptor.ofMethod(BackUtil.class, (String)"namedBlobField", NamedBlob.class, (Class[])new Class[]{FileUpload.class}), new ResultHandle[]{parameterValue});
                            }
                            hasValueTrueBranch.invokeVirtualMethod(MethodDescriptor.ofMethod((Object)entityClass, (String)field.entityField.getSetterName(), Void.TYPE, (Object[])new Object[]{field.entityField.descriptor}), (ResultHandle)entityVariable, new ResultHandle[]{uploadValue});
                        }
                        try (BytecodeCreator hasValueFalseBranch = hasValueTest.falseBranch();){
                            BranchResult unsetTest = hasValueFalseBranch.ifTrue(hasValueFalseBranch.invokeStaticMethod(MethodDescriptor.ofMethod(BackUtil.class, (String)"booleanField", Boolean.TYPE, (Class[])new Class[]{String.class}), new ResultHandle[]{parameterUnsetValue}));
                            try (BytecodeCreator unsetTrueBranch = unsetTest.trueBranch();){
                                unsetTrueBranch.invokeVirtualMethod(MethodDescriptor.ofMethod((Object)entityClass, (String)field.entityField.getSetterName(), Void.TYPE, (Object[])new Object[]{field.entityField.descriptor}), (ResultHandle)entityVariable, new ResultHandle[]{unsetTrueBranch.loadNull()});
                            }
                            unsetTest.falseBranch().close();
                        }
                    }
                    if (field.entityField.descriptor.equals("Z")) {
                        value = m.invokeStaticMethod(MethodDescriptor.ofMethod(BackUtil.class, (String)"booleanField", Boolean.TYPE, (Class[])new Class[]{String.class}), new ResultHandle[]{parameterValue});
                    } else if (field.entityField.descriptor.equals("Ljava/lang/Boolean;")) {
                        value = m.invokeStaticMethod(MethodDescriptor.ofMethod(BackUtil.class, (String)"booleanField", Boolean.TYPE, (Class[])new Class[]{String.class}), new ResultHandle[]{parameterValue});
                        value = m.invokeStaticMethod(MethodDescriptor.ofMethod(Boolean.class, (String)"valueOf", Boolean.class, (Class[])new Class[]{Boolean.TYPE}), new ResultHandle[]{value});
                    } else if (field.entityField.descriptor.equals("Ljava/lang/Integer;")) {
                        value = m.invokeStaticMethod(MethodDescriptor.ofMethod(BackUtil.class, (String)"integerWrapperField", Integer.class, (Class[])new Class[]{String.class}), new ResultHandle[]{parameterValue});
                    } else if (field.type == ModelField.Type.Number) {
                        Class<Number> primitiveClass = switch (field.entityField.descriptor) {
                            case "B" -> Byte.TYPE;
                            case "S" -> Short.TYPE;
                            case "I" -> Integer.TYPE;
                            case "J" -> Long.TYPE;
                            case "F" -> Float.TYPE;
                            case "D" -> Double.TYPE;
                            default -> throw new RuntimeException("Unknown number field " + field + " descriptor: " + field.entityField.descriptor);
                        };
                        value = m.invokeStaticMethod(MethodDescriptor.ofMethod(BackUtil.class, (String)(primitiveClass.getName() + "Field"), primitiveClass, (Class[])new Class[]{String.class}), new ResultHandle[]{parameterValue});
                    } else if (field.entityField.descriptor.equals("Ljava/util/Date;")) {
                        value = m.invokeStaticMethod(MethodDescriptor.ofMethod(BackUtil.class, (String)"dateField", Date.class, (Class[])new Class[]{String.class}), new ResultHandle[]{parameterValue});
                    } else if (field.entityField.descriptor.equals("Ljava/sql/Timestamp;")) {
                        value = m.invokeStaticMethod(MethodDescriptor.ofMethod(BackUtil.class, (String)"sqlTimestampField", Timestamp.class, (Class[])new Class[]{String.class}), new ResultHandle[]{parameterValue});
                    } else if (field.entityField.descriptor.equals("Ljava/time/LocalDateTime;")) {
                        value = m.invokeStaticMethod(MethodDescriptor.ofMethod(BackUtil.class, (String)"localDateTimeField", LocalDateTime.class, (Class[])new Class[]{String.class}), new ResultHandle[]{parameterValue});
                    } else if (field.entityField.descriptor.equals("Ljava/time/LocalDate;")) {
                        value = m.invokeStaticMethod(MethodDescriptor.ofMethod(BackUtil.class, (String)"localDateField", LocalDate.class, (Class[])new Class[]{String.class}), new ResultHandle[]{parameterValue});
                    } else if (field.entityField.descriptor.equals("Ljava/time/LocalTime;")) {
                        value = m.invokeStaticMethod(MethodDescriptor.ofMethod(BackUtil.class, (String)"localTimeField", LocalTime.class, (Class[])new Class[]{String.class}), new ResultHandle[]{parameterValue});
                    } else if (field.type == ModelField.Type.Enum) {
                        value = m.invokeStaticMethod(MethodDescriptor.ofMethod(BackUtil.class, (String)"enumField", Enum.class, (Class[])new Class[]{Class.class, String.class}), new ResultHandle[]{m.loadClass(field.getClassName()), parameterValue});
                        value = m.checkCast(value, field.entityField.descriptor);
                    } else if (field.type == ModelField.Type.JSON) {
                        value = m.invokeStaticMethod(MethodDescriptor.ofMethod(BackUtil.class, (String)"jsonField", Object.class, (Class[])new Class[]{String.class, String.class}), new ResultHandle[]{m.load(field.signature), parameterValue});
                        value = m.checkCast(value, field.entityField.descriptor);
                    } else {
                        if (field.type == ModelField.Type.MultiRelation || field.type == ModelField.Type.MultiMultiRelation) {
                            AssignableResultHandle iterator = m.createVariable(Iterator.class);
                            if (mode == Mode.EDIT) {
                                ResultHandle relation = m.invokeVirtualMethod(MethodDescriptor.ofMethod((String)entityClass, (String)field.entityField.getGetterName(), (String)field.entityField.descriptor, (String[])new String[0]), (ResultHandle)entityVariable, new ResultHandle[0]);
                                m.assign(iterator, m.invokeInterfaceMethod(MethodDescriptor.ofMethod(Iterable.class, (String)"iterator", Iterator.class, (Class[])new Class[0]), relation, new ResultHandle[0]));
                                try (BytecodeCreator loop = m.whileLoop(bc -> bc.ifTrue(bc.invokeInterfaceMethod(MethodDescriptor.ofMethod(Iterator.class, (String)"hasNext", Boolean.TYPE, (Class[])new Class[0]), (ResultHandle)iterator, new ResultHandle[0]))).block();){
                                    ResultHandle next = loop.checkCast(loop.invokeInterfaceMethod(MethodDescriptor.ofMethod(Iterator.class, (String)"next", Object.class, (Class[])new Class[0]), (ResultHandle)iterator, new ResultHandle[0]), field.relationClass);
                                    EntityField inverseField = field.inverseField;
                                    if (field.type == ModelField.Type.MultiMultiRelation) {
                                        ResultHandle inverseRelation = loop.invokeVirtualMethod(MethodDescriptor.ofMethod((String)field.relationClass, (String)inverseField.getGetterName(), (String)inverseField.descriptor, (String[])new String[0]), next, new ResultHandle[0]);
                                        loop.invokeInterfaceMethod(MethodDescriptor.ofMethod(List.class, (String)"remove", Boolean.TYPE, (Class[])new Class[]{Object.class}), inverseRelation, new ResultHandle[]{entityVariable});
                                    } else {
                                        loop.invokeVirtualMethod(MethodDescriptor.ofMethod((Object)field.relationClass, (String)inverseField.getSetterName(), Void.TYPE, (Object[])new Object[]{inverseField.descriptor}), next, new ResultHandle[]{loop.loadNull()});
                                    }
                                }
                                relation = m.invokeVirtualMethod(MethodDescriptor.ofMethod((String)entityClass, (String)field.entityField.getGetterName(), (String)field.entityField.descriptor, (String[])new String[0]), (ResultHandle)entityVariable, new ResultHandle[0]);
                                m.invokeInterfaceMethod(MethodDescriptor.ofMethod(List.class, (String)"clear", Void.TYPE, (Class[])new Class[0]), relation, new ResultHandle[0]);
                            } else {
                                m.invokeVirtualMethod(MethodDescriptor.ofMethod((Object)entityClass, (String)field.entityField.getSetterName(), Void.TYPE, (Object[])new Object[]{field.entityField.descriptor}), (ResultHandle)entityVariable, new ResultHandle[]{m.newInstance(MethodDescriptor.ofConstructor(ArrayList.class, (Class[])new Class[0]), new ResultHandle[0])});
                            }
                            m.assign(iterator, m.invokeInterfaceMethod(MethodDescriptor.ofMethod(Iterable.class, (String)"iterator", Iterator.class, (Class[])new Class[0]), parameterValue, new ResultHandle[0]));
                            try (BytecodeCreator loop = m.whileLoop(bc -> bc.ifTrue(bc.invokeInterfaceMethod(MethodDescriptor.ofMethod(Iterator.class, (String)"hasNext", Boolean.TYPE, (Class[])new Class[0]), (ResultHandle)iterator, new ResultHandle[0]))).block();){
                                ResultHandle next = loop.checkCast(loop.invokeInterfaceMethod(MethodDescriptor.ofMethod(Iterator.class, (String)"next", Object.class, (Class[])new Class[0]), (ResultHandle)iterator, new ResultHandle[0]), String.class);
                                EntityField inverseField = field.inverseField;
                                String relationSignature = "L" + field.relationClass.replace('.', '/') + ";";
                                AssignableResultHandle otherEntityVar = m.createVariable(relationSignature);
                                ResultHandle id = loop.invokeStaticMethod(MethodDescriptor.ofMethod(Long.class, (String)"valueOf", Long.class, (Class[])new Class[]{String.class}), new ResultHandle[]{next});
                                ResultHandle otherEntity = loop.invokeStaticMethod(MethodDescriptor.ofMethod((Object)field.relationClass, (String)"findById", PanacheEntityBase.class, (Object[])new Object[]{Object.class}), new ResultHandle[]{id});
                                otherEntity = loop.checkCast(otherEntity, field.relationClass);
                                loop.assign(otherEntityVar, otherEntity);
                                if (field.type == ModelField.Type.MultiMultiRelation) {
                                    ResultHandle inverseRelation = loop.invokeVirtualMethod(MethodDescriptor.ofMethod((String)field.relationClass, (String)inverseField.getGetterName(), (String)inverseField.descriptor, (String[])new String[0]), (ResultHandle)otherEntityVar, new ResultHandle[0]);
                                    loop.invokeInterfaceMethod(MethodDescriptor.ofMethod(List.class, (String)"add", Boolean.TYPE, (Class[])new Class[]{Object.class}), inverseRelation, new ResultHandle[]{entityVariable});
                                } else {
                                    loop.invokeVirtualMethod(MethodDescriptor.ofMethod((Object)field.relationClass, (String)inverseField.getSetterName(), Void.TYPE, (Object[])new Object[]{inverseField.descriptor}), (ResultHandle)otherEntityVar, new ResultHandle[]{entityVariable});
                                }
                                ResultHandle relation = loop.invokeVirtualMethod(MethodDescriptor.ofMethod((String)entityClass, (String)field.entityField.getGetterName(), (String)field.entityField.descriptor, (String[])new String[0]), (ResultHandle)entityVariable, new ResultHandle[0]);
                                loop.invokeInterfaceMethod(MethodDescriptor.ofMethod(List.class, (String)"add", Boolean.TYPE, (Class[])new Class[]{Object.class}), relation, new ResultHandle[]{otherEntityVar});
                            }
                        }
                        if (field.type == ModelField.Type.Ignore) continue;
                        if (field.type != ModelField.Type.Relation) throw new RuntimeException("Don't know what to do with field of type " + field.entityField.descriptor + " from field " + simpleName + "." + field.name);
                        BranchResult branch = m.ifTrue(m.invokeStaticMethod(MethodDescriptor.ofMethod(BackUtil.class, (String)"isSet", Boolean.TYPE, (Class[])new Class[]{String.class}), new ResultHandle[]{parameterValue}));
                        AssignableResultHandle valueVar = m.createVariable(field.entityField.descriptor);
                        try (BytecodeCreator tb3 = branch.trueBranch();){
                            value = tb3.invokeStaticMethod(MethodDescriptor.ofMethod(Long.class, (String)"valueOf", Long.class, (Class[])new Class[]{String.class}), new ResultHandle[]{parameterValue});
                            value = tb3.invokeStaticMethod(MethodDescriptor.ofMethod((Object)field.getClassName(), (String)"findById", PanacheEntityBase.class, (Object[])new Object[]{Object.class}), new ResultHandle[]{value});
                            value = tb3.checkCast(value, field.entityField.descriptor);
                            tb3.assign(valueVar, value);
                        }
                        try (BytecodeCreator fb2 = branch.falseBranch();){
                            fb2.assign(valueVar, fb2.loadNull());
                        }
                        value = valueVar;
                    }
                }
                if (value == null) continue;
                m.invokeVirtualMethod(MethodDescriptor.ofMethod((Object)entityClass, (String)field.entityField.getSetterName(), Void.TYPE, (Object[])new Object[]{field.entityField.descriptor}), (ResultHandle)entityVariable, new ResultHandle[]{value});
            }
            if (mode == Mode.CREATE) {
                m.invokeVirtualMethod(MethodDescriptor.ofMethod((Object)entityClass, (String)"persist", Void.TYPE, (Object[])new Object[0]), (ResultHandle)entityVariable, new ResultHandle[0]);
            }
            ResultHandle message = m.newInstance(MethodDescriptor.ofConstructor(StringBuilder.class, (Class[])new Class[]{String.class}), new ResultHandle[]{m.load(mode == Mode.CREATE ? "Created: " : "Updated: ")});
            message = m.invokeVirtualMethod(MethodDescriptor.ofMethod(StringBuilder.class, (String)"append", StringBuilder.class, (Class[])new Class[]{Object.class}), message, new ResultHandle[]{entityVariable});
            message = m.invokeVirtualMethod(MethodDescriptor.ofMethod(StringBuilder.class, (String)"toString", String.class, (Class[])new Class[0]), message, new ResultHandle[0]);
            m.invokeVirtualMethod(MethodDescriptor.ofMethod((Object)controllerClass, (String)"flash", Void.TYPE, (Object[])new Object[]{String.class, Object.class}), m.getThis(), new ResultHandle[]{m.load("message"), message});
            if (mode == Mode.EDIT) {
                BranchResult ifSave = m.ifReferencesEqual(m.getMethodParam(1), m.readStaticField(FieldDescriptor.of(EditAction.class, (String)"Save", EditAction.class)));
                tb = ifSave.trueBranch();
                try {
                    indexTarget = "/_renarde/backoffice/" + simpleName + "/index";
                    this.redirectToAction(tb, controllerClass, indexTarget, simpleName, null);
                }
                finally {
                    if (tb != null) {
                        tb.close();
                    }
                }
                fb = ifSave.falseBranch();
                try {
                    String editTarget = "/_renarde/backoffice/" + simpleName + "/edit/";
                    this.redirectToAction(fb, controllerClass, editTarget, simpleName, () -> fb.getMethodParam(0));
                }
                finally {
                    if (fb != null) {
                        fb.close();
                    }
                }
            }
            BranchResult ifCreate = m.ifReferencesEqual(m.getMethodParam(0), m.readStaticField(FieldDescriptor.of(CreateAction.class, (String)"Create", CreateAction.class)));
            tb = ifCreate.trueBranch();
            try {
                indexTarget = "/_renarde/backoffice/" + simpleName + "/index";
                this.redirectToAction(tb, controllerClass, indexTarget, simpleName, null);
            }
            finally {
                if (tb != null) {
                    tb.close();
                }
            }
            fb = ifCreate.falseBranch();
            try {
                BranchResult ifCreateAndContinueEditing = fb.ifReferencesEqual(fb.getMethodParam(0), fb.readStaticField(FieldDescriptor.of(CreateAction.class, (String)"CreateAndContinueEditing", CreateAction.class)));
                try (BytecodeCreator tb2 = ifCreateAndContinueEditing.trueBranch();){
                    String editTarget = "/_renarde/backoffice/" + simpleName + "/edit/";
                    this.redirectToAction(tb2, controllerClass, editTarget, simpleName, () -> tb2.invokeVirtualMethod(MethodDescriptor.ofMethod((Object)entityClass, (String)"getId", Long.class, (Object[])new Object[0]), (ResultHandle)entityVariable, new ResultHandle[0]));
                }
                try (BytecodeCreator fb2 = ifCreate.falseBranch();){
                    String createTarget = "/_renarde/backoffice/" + simpleName + "/create";
                    this.redirectToAction(fb2, controllerClass, createTarget, simpleName, null);
                }
            }
            finally {
                if (fb != null) {
                    fb.close();
                }
            }
            m.returnValue(null);
            return;
        }
    }

    private void redirectToAction(BytecodeCreator m, String controllerClass, String uriTarget, String simpleName, Supplier<ResultHandle> getId) {
        ResultHandle uri;
        if (getId != null) {
            uri = m.newInstance(MethodDescriptor.ofConstructor(StringBuilder.class, (Class[])new Class[]{String.class}), new ResultHandle[]{m.load(uriTarget)});
            uri = m.invokeVirtualMethod(MethodDescriptor.ofMethod(StringBuilder.class, (String)"append", StringBuilder.class, (Class[])new Class[]{Object.class}), uri, new ResultHandle[]{getId.get()});
            uri = m.invokeVirtualMethod(MethodDescriptor.ofMethod(StringBuilder.class, (String)"toString", String.class, (Class[])new Class[0]), uri, new ResultHandle[0]);
        } else {
            uri = m.load(uriTarget);
        }
        m.invokeVirtualMethod(MethodDescriptor.ofMethod((Object)controllerClass, (String)"seeOther", Response.class, (Object[])new Object[]{String.class}), m.getThis(), new ResultHandle[]{uri});
    }

    private void editOrCreateView(MethodCreator m, String controllerClass, String entityClass, String simpleName, List<ModelField> fields, Mode mode) {
        if (mode == Mode.EDIT) {
            m.getParameterAnnotations(0).addAnnotation(RestPath.class).addValue("value", (Object)"id");
            m.addAnnotation(jakarta.ws.rs.Path.class).addValue("value", (Object)"edit/{id}");
        } else {
            m.addAnnotation(jakarta.ws.rs.Path.class).addValue("value", (Object)"create");
        }
        m.addAnnotation(GET.class);
        m.addAnnotation(Transactional.class);
        m.addAnnotation(Produces.class).addValue("value", (Object)new String[]{"text/html"});
        ResultHandle instance = this.getTemplateInstance(m, "_renarde/backoffice/" + simpleName + "/" + (mode == Mode.CREATE ? "create" : "edit"));
        AssignableResultHandle entityVariable = null;
        if (mode == Mode.EDIT) {
            entityVariable = this.findEntityById(m, controllerClass, entityClass);
            instance = m.invokeInterfaceMethod(MethodDescriptor.ofMethod(TemplateInstance.class, (String)"data", TemplateInstance.class, (Class[])new Class[]{String.class, Object.class}), instance, new ResultHandle[]{m.load("entity"), entityVariable});
        }
        for (ModelField field : fields) {
            ResultHandle data = null;
            if (field.type == ModelField.Type.Relation || field.type == ModelField.Type.MultiRelation || field.type == ModelField.Type.MultiMultiRelation) {
                list = m.invokeStaticMethod(MethodDescriptor.ofMethod((Object)field.relationClass, (String)"listAll", List.class, (Object[])new Object[0]), new ResultHandle[0]);
                data = m.invokeStaticMethod(MethodDescriptor.ofMethod(BackUtil.class, (String)"entityPossibleValues", Map.class, (Class[])new Class[]{List.class}), new ResultHandle[]{list});
            } else if (field.type == ModelField.Type.Enum) {
                list = m.invokeStaticMethod(MethodDescriptor.ofMethod((String)field.getClassName(), (String)"values", (String)("[" + field.entityField.descriptor), (String[])new String[0]), new ResultHandle[0]);
                data = m.invokeStaticMethod(MethodDescriptor.ofMethod(BackUtil.class, (String)"enumPossibleValues", Map.class, (Class[])new Class[]{Enum[].class}), new ResultHandle[]{list});
            }
            if (data != null) {
                instance = m.invokeInterfaceMethod(MethodDescriptor.ofMethod(TemplateInstance.class, (String)"data", TemplateInstance.class, (Class[])new Class[]{String.class, Object.class}), instance, new ResultHandle[]{m.load(field.name + "PossibleValues"), data});
            }
            if (mode == Mode.EDIT && (field.type == ModelField.Type.MultiRelation || field.type == ModelField.Type.MultiMultiRelation)) {
                ResultHandle relation = m.invokeVirtualMethod(MethodDescriptor.ofMethod((String)entityClass, (String)field.entityField.getGetterName(), (String)field.entityField.descriptor, (String[])new String[0]), (ResultHandle)entityVariable, new ResultHandle[0]);
                data = m.invokeStaticMethod(MethodDescriptor.ofMethod(BackUtil.class, (String)"entityCurrentValues", List.class, (Class[])new Class[]{List.class}), new ResultHandle[]{relation});
                instance = m.invokeInterfaceMethod(MethodDescriptor.ofMethod(TemplateInstance.class, (String)"data", TemplateInstance.class, (Class[])new Class[]{String.class, Object.class}), instance, new ResultHandle[]{m.load(field.name + "CurrentValues"), data});
            }
            if (mode != Mode.EDIT || field.type != ModelField.Type.Binary || !field.entityField.descriptor.equals("Ljava/sql/Blob;")) continue;
            ResultHandle blob = m.invokeVirtualMethod(MethodDescriptor.ofMethod((String)entityClass, (String)field.entityField.getGetterName(), (String)field.entityField.descriptor, (String[])new String[0]), (ResultHandle)entityVariable, new ResultHandle[0]);
            BranchResult ifBranch = m.ifNotNull(blob);
            try (BytecodeCreator trueBranch = ifBranch.trueBranch();){
                ResultHandle blob2 = trueBranch.invokeVirtualMethod(MethodDescriptor.ofMethod((String)entityClass, (String)field.entityField.getGetterName(), (String)field.entityField.descriptor, (String[])new String[0]), (ResultHandle)entityVariable, new ResultHandle[0]);
                data = trueBranch.invokeInterfaceMethod(MethodDescriptor.ofMethod(Blob.class, (String)"length", Long.TYPE, (Class[])new Class[0]), blob2, new ResultHandle[0]);
                trueBranch.invokeInterfaceMethod(MethodDescriptor.ofMethod(TemplateInstance.class, (String)"data", TemplateInstance.class, (Class[])new Class[]{String.class, Object.class}), instance, new ResultHandle[]{trueBranch.load(field.name + "Length"), data});
            }
            ifBranch.falseBranch().close();
        }
        m.returnValue(instance);
    }

    private AssignableResultHandle findEntityById(MethodCreator m, String controllerClass, String entityClass) {
        ResultHandle entity = m.invokeStaticMethod(MethodDescriptor.ofMethod((Object)entityClass, (String)"findById", PanacheEntityBase.class, (Object[])new Object[]{Object.class}), new ResultHandle[]{m.getMethodParam(0)});
        String entityTypeDescriptor = "L" + entityClass.replace('.', '/') + ";";
        AssignableResultHandle variable = m.createVariable(entityTypeDescriptor);
        m.assign(variable, m.checkCast(entity, entityTypeDescriptor));
        m.invokeVirtualMethod(MethodDescriptor.ofMethod((Object)controllerClass, (String)"notFoundIfNull", Void.TYPE, (Object[])new Object[]{Object.class}), m.getThis(), new ResultHandle[]{variable});
        return variable;
    }

    private ResultHandle getTemplateInstance(MethodCreator m, String templateName) {
        ResultHandle container = m.invokeStaticMethod(MethodDescriptor.ofMethod(Arc.class, (String)"container", ArcContainer.class, (Class[])new Class[0]), new ResultHandle[0]);
        ResultHandle instanceHandle = m.invokeInterfaceMethod(MethodDescriptor.ofMethod(ArcContainer.class, (String)"instance", InstanceHandle.class, (Class[])new Class[]{Class.class, Annotation[].class}), container, new ResultHandle[]{m.loadClass(TemplateProducer.class), m.newArray(Annotation.class, 0)});
        ResultHandle templateProducer = m.checkCast(m.invokeInterfaceMethod(MethodDescriptor.ofMethod(InstanceHandle.class, (String)"get", Object.class, (Class[])new Class[0]), instanceHandle, new ResultHandle[0]), TemplateProducer.class);
        ResultHandle template = m.invokeVirtualMethod(MethodDescriptor.ofMethod(TemplateProducer.class, (String)"getInjectableTemplate", Template.class, (Class[])new Class[]{String.class}), templateProducer, new ResultHandle[]{m.load(templateName)});
        return m.invokeInterfaceMethod(MethodDescriptor.ofMethod(Template.class, (String)"instance", TemplateInstance.class, (Class[])new Class[0]), template, new ResultHandle[0]);
    }

    private void generateAllController(BuildProducer<GeneratedJaxRsResourceBuildItem> jaxrsOutput, Collection<ClassInfo> indexControllers) {
        String superClass = Controller.class.getName();
        List declaredAnnotations = null;
        if (!indexControllers.isEmpty()) {
            ClassInfo indexController = indexControllers.iterator().next();
            superClass = indexController.name().toString();
            declaredAnnotations = indexController.declaredAnnotations();
        }
        try (ClassCreator c = ClassCreator.builder().classOutput((ClassOutput)new GeneratedJaxRsResourceGizmoAdaptor(jaxrsOutput)).className("rest._renarde.backoffice.Index").superClass(superClass).build();){
            if (declaredAnnotations != null) {
                for (AnnotationInstance annotationInstance : declaredAnnotations) {
                    c.addAnnotation(annotationInstance);
                }
            }
            c.addAnnotation(Blocking.class.getName());
            c.addAnnotation(RequestScoped.class.getName());
            c.addAnnotation(jakarta.ws.rs.Path.class).addValue("value", (Object)URI_PREFIX);
            try (MethodCreator m = c.getMethodCreator("index", TemplateInstance.class, new Class[0]);){
                m.addAnnotation(jakarta.ws.rs.Path.class).addValue("value", (Object)"index");
                m.addAnnotation(GET.class);
                m.addAnnotation(Produces.class).addValue("value", (Object)new String[]{"text/html"});
                ResultHandle instance = this.getTemplateInstance(m, "_renarde/backoffice/index");
                m.returnValue(instance);
            }
        }
    }

    public static enum Mode {
        EDIT,
        CREATE;

    }
}

