/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.renarde.barcode.runtime;

import io.quarkiverse.renarde.barcode.runtime.Futures;
import io.quarkiverse.renarde.barcode.runtime.Util;
import io.quarkus.qute.Expression;
import io.quarkus.qute.Parameter;
import io.quarkus.qute.ResultNode;
import io.quarkus.qute.Scope;
import io.quarkus.qute.SectionHelper;
import io.quarkus.qute.SectionHelperFactory;
import io.quarkus.qute.SingleResultNode;
import io.quarkus.qute.TemplateException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionStage;

public abstract class QuteBarCode
implements SectionHelperFactory<CustomSectionHelper> {
    private String name;
    private BarCodeEncoder encoder;

    public QuteBarCode(String name, BarCodeEncoder encoder) {
        this.name = name;
        this.encoder = encoder;
    }

    public List<String> getDefaultAliases() {
        return List.of(this.name);
    }

    public SectionHelperFactory.ParametersInfo getParameters() {
        return SectionHelperFactory.ParametersInfo.builder().addParameter(Parameter.builder((String)"value")).addParameter(Parameter.builder((String)"size").optional()).addParameter(Parameter.builder((String)"width").optional()).addParameter(Parameter.builder((String)"height").optional()).build();
    }

    public Scope initializeBlock(Scope outerScope, SectionHelperFactory.BlockInfo block) {
        Util.declareBlock(block, "value", "size", "width", "height");
        return super.initializeBlock(outerScope, block);
    }

    public CustomSectionHelper initialize(SectionHelperFactory.SectionInitContext context) {
        Util.requireParameter(context, "value");
        Map<String, Expression> params = Util.collectExpressions(context, "value", "size", "width", "height");
        if (context.hasParameter("size") && (params.containsKey("width") || params.containsKey("height"))) {
            throw new TemplateException("Cannot set both size and (width or height): choose one the others");
        }
        return new CustomSectionHelper(params, this.encoder);
    }

    @FunctionalInterface
    public static interface BarCodeEncoder {
        public String encode(String var1, int var2, int var3);
    }

    static class CustomSectionHelper
    implements SectionHelper {
        private Map<String, Expression> params;
        private BarCodeEncoder encoder;

        public CustomSectionHelper(Map<String, Expression> params, BarCodeEncoder encoder) {
            this.params = params;
            this.encoder = encoder;
        }

        public CompletionStage<ResultNode> resolve(SectionHelper.SectionResolutionContext context) {
            return Futures.evaluateParams(this.params, context.resolutionContext()).thenApply(values -> {
                String value = Util.typecheckValue(values, "value", String.class);
                Integer size = Util.typecheckValue(values, "size", Integer.class, 200);
                Integer width = Util.typecheckValue(values, "width", Integer.class, size);
                Integer height = Util.typecheckValue(values, "height", Integer.class, size);
                return new SingleResultNode((Object)this.encoder.encode(value, width, height));
            });
        }
    }
}

