/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.renarde.deployment;

import io.quarkiverse.renarde.Controller;
import io.quarkiverse.renarde.deployment.ControllerVisitor;
import io.quarkiverse.renarde.deployment.ExcludedControllerBuildItem;
import io.quarkiverse.renarde.deployment.LoginPageBuildItem;
import io.quarkiverse.renarde.deployment.RouterUserVisitor;
import io.quarkiverse.renarde.htmx.HxController;
import io.quarkiverse.renarde.impl.RenardeConfigBean;
import io.quarkiverse.renarde.impl.RenardeRecorder;
import io.quarkiverse.renarde.router.Router;
import io.quarkiverse.renarde.router.RouterMethod;
import io.quarkiverse.renarde.util.Filters;
import io.quarkiverse.renarde.util.Flash;
import io.quarkiverse.renarde.util.Globals;
import io.quarkiverse.renarde.util.I18N;
import io.quarkiverse.renarde.util.JavaExtensions;
import io.quarkiverse.renarde.util.MyParamConverters;
import io.quarkiverse.renarde.util.MyValidationInterceptor;
import io.quarkiverse.renarde.util.QuteResolvers;
import io.quarkiverse.renarde.util.RedirectExceptionMapper;
import io.quarkiverse.renarde.util.RenardeJWTAuthMechanism;
import io.quarkiverse.renarde.util.RenardeValidationLocaleResolver;
import io.quarkiverse.renarde.util.RenderArgs;
import io.quarkiverse.renarde.util.Validation;
import io.quarkus.arc.Unremovable;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.AnnotationsTransformerBuildItem;
import io.quarkus.arc.deployment.AutoAddScopeBuildItem;
import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.arc.deployment.BuildTimeConditionBuildItem;
import io.quarkus.arc.deployment.ExcludedTypeBuildItem;
import io.quarkus.arc.deployment.GeneratedBeanBuildItem;
import io.quarkus.arc.deployment.GeneratedBeanGizmoAdaptor;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.arc.processor.AnnotationsTransformer;
import io.quarkus.arc.processor.BuiltinScope;
import io.quarkus.arc.processor.Transformation;
import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import io.quarkus.bootstrap.workspace.ArtifactSources;
import io.quarkus.bootstrap.workspace.SourceDir;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.ApplicationArchive;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.AdditionalIndexedClassesBuildItem;
import io.quarkus.deployment.builditem.ApplicationArchivesBuildItem;
import io.quarkus.deployment.builditem.ApplicationClassPredicateBuildItem;
import io.quarkus.deployment.builditem.ApplicationIndexBuildItem;
import io.quarkus.deployment.builditem.BytecodeTransformerBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.HotDeploymentWatchedFileBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.RunTimeConfigurationDefaultBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.RuntimeInitializedClassBuildItem;
import io.quarkus.deployment.execannotations.ExecutionModelAnnotationsAllowedBuildItem;
import io.quarkus.deployment.logging.LogCleanupFilterBuildItem;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.deployment.util.AsmUtil;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.FieldCreator;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.FunctionCreator;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.hibernate.validator.runtime.jaxrs.ResteasyReactiveEndPointValidationInterceptor;
import io.quarkus.qute.TemplateInstance;
import io.quarkus.resteasy.reactive.spi.AdditionalResourceClassBuildItem;
import io.quarkus.resteasy.reactive.spi.CustomExceptionMapperBuildItem;
import io.quarkus.resteasy.reactive.spi.ParamConverterBuildItem;
import io.quarkus.runtime.LocalesBuildTimeConfig;
import io.quarkus.runtime.StartupEvent;
import io.quarkus.smallrye.jwt.runtime.auth.JWTAuthMechanism;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import jakarta.enterprise.context.RequestScoped;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.Produces;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import jakarta.transaction.Transactional;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;
import org.jboss.resteasy.reactive.common.processor.ResteasyReactiveDotNames;
import org.jboss.resteasy.reactive.common.processor.transformation.AnnotationsTransformer;
import org.jboss.resteasy.reactive.common.util.URLUtils;
import org.jboss.resteasy.reactive.server.ServerExceptionMapper;

public class RenardeProcessor {
    private static final Logger logger = Logger.getLogger(RenardeProcessor.class);
    public static final DotName DOTNAME_UNI = DotName.createSimple((String)Uni.class.getName());
    public static final DotName DOTNAME_MULTI = DotName.createSimple((String)Multi.class.getName());
    public static final DotName DOTNAME_CONTROLLER = DotName.createSimple((String)Controller.class.getName());
    public static final DotName DOTNAME_ROUTER = DotName.createSimple((String)Router.class.getName());
    public static final DotName DOTNAME_UNREMOVABLE = DotName.createSimple((String)Unremovable.class.getName());
    public static final DotName DOTNAME_TRANSACTIONAL = DotName.createSimple((String)Transactional.class.getName());
    public static final DotName DOTNAME_USER = DotName.createSimple((String)"io.quarkiverse.renarde.security.RenardeUser");
    public static final DotName DOTNAME_USER_WITH_PASSWORD = DotName.createSimple((String)"io.quarkiverse.renarde.security.RenardeUserWithPassword");
    public static final DotName DOTNAME_SECURITY = DotName.createSimple((String)"io.quarkiverse.renarde.security.RenardeSecurity");
    public static final DotName DOTNAME_AUTHENTICATION_HANDLER = DotName.createSimple((String)"io.quarkiverse.renarde.security.impl.AuthenticationFailedExceptionMapper");
    public static final DotName DOTNAME_RENARDE_FORM_LOGIN_CONTROLLER = DotName.createSimple((String)"io.quarkiverse.renarde.security.impl.RenardeFormLoginController");
    public static final DotName DOTNAME_RENARDE_SECURITY_CONTROLLER = DotName.createSimple((String)"io.quarkiverse.renarde.security.impl.RenardeSecurityController");
    public static final DotName DOTNAME_HX_CONTROLLER = DotName.createSimple((String)HxController.class.getName());
    public static final DotName DOTNAME_LOGIN_PAGE = DotName.createSimple((String)"io.quarkiverse.renarde.security.LoginPage");
    public static final DotName DOTNAME_NAMED = DotName.createSimple((String)Named.class.getName());
    public static final DotName DOTNAME_TEMPLATE_INSTANCE = DotName.createSimple((String)TemplateInstance.class.getName());
    private static final String FEATURE = "renarde";
    private static final String PDFBOX_PROBLEMATIC_CLASS = "org.apache.pdfbox.pdmodel.encryption.PublicKeySecurityHandler";
    private static final String PDF_RESPONSE_HANDLER_CLASS = "io.quarkiverse.renarde.pdf.runtime.PdfResponseHandler";
    private static final String[] SUPPORTED_OIDC_PROVIDERS = new String[]{"facebook", "apple", "github", "microsoft", "google", "twitter", "spotify"};

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    void setupPdfBox(BuildProducer<RuntimeInitializedClassBuildItem> runtimeInitializedClassBuildItem) {
        if (QuarkusClassLoader.isClassPresentAtRuntime((String)PDF_RESPONSE_HANDLER_CLASS)) {
            runtimeInitializedClassBuildItem.produce((BuildItem)new RuntimeInitializedClassBuildItem(PDF_RESPONSE_HANDLER_CLASS));
            runtimeInitializedClassBuildItem.produce((BuildItem)new RuntimeInitializedClassBuildItem(PDFBOX_PROBLEMATIC_CLASS));
            runtimeInitializedClassBuildItem.produce((BuildItem)new RuntimeInitializedClassBuildItem("sun.java2d.Disposer"));
            runtimeInitializedClassBuildItem.produce((BuildItem)new RuntimeInitializedClassBuildItem("com.openhtmltopdf.resource.FSEntityResolver"));
        }
    }

    @BuildStep
    void removeHibernateLogging(LaunchModeBuildItem launchMode, BuildProducer<LogCleanupFilterBuildItem> logFilters) {
        if (launchMode.getLaunchMode().isDevOrTest()) {
            logFilters.produce((BuildItem)new LogCleanupFilterBuildItem("org.hibernate.engine.jdbc.spi.SqlExceptionHelper", new String[]{"SQL Warning Code: 0, SQLState: 00000", "relation \"", "table \"", "sequence \""}));
        }
    }

    @BuildStep
    void setupSecurity(LaunchModeBuildItem launchMode, Capabilities capabilities, BuildProducer<RunTimeConfigurationDefaultBuildItem> runtimeConfigurationBuildItem) throws IOException, NoSuchAlgorithmException {
        Config config = ConfigProvider.getConfig();
        if (capabilities.isPresent("io.quarkus.jwt")) {
            this.defineUnlessPresent("quarkus.http.auth.proactive", "false", config, runtimeConfigurationBuildItem);
            this.defineUnlessPresent("mp.jwt.verify.issuer", "https://example.com/issuer", config, runtimeConfigurationBuildItem);
            this.defineUnlessPresent("mp.jwt.token.header", "Cookie", config, runtimeConfigurationBuildItem);
            this.defineUnlessPresent("mp.jwt.token.cookie", "QuarkusUser", config, runtimeConfigurationBuildItem);
        }
        for (String provider : SUPPORTED_OIDC_PROVIDERS) {
            if (!config.getOptionalValue("quarkus.oidc." + provider + ".provider", String.class).isPresent() && !config.getOptionalValue("quarkus.oidc." + provider + ".client-id", String.class).isPresent() || config.getOptionalValue("quarkus.oidc." + provider + ".authentication.redirect-path", String.class).isPresent()) continue;
            runtimeConfigurationBuildItem.produce((BuildItem)new RunTimeConfigurationDefaultBuildItem("quarkus.oidc." + provider + ".authentication.redirect-path", "/_renarde/security/oidc-success"));
        }
    }

    private void defineUnlessPresent(String key, String value, Config config, BuildProducer<RunTimeConfigurationDefaultBuildItem> runtimeConfigurationBuildItem) {
        if (!config.getOptionalValue(key, String.class).isPresent()) {
            runtimeConfigurationBuildItem.produce((BuildItem)new RunTimeConfigurationDefaultBuildItem(key, value));
        }
    }

    @BuildStep
    void setupJWT(LaunchModeBuildItem launchMode, Capabilities capabilities, BuildProducer<RunTimeConfigurationDefaultBuildItem> runtimeConfigurationBuildItem, CurateOutcomeBuildItem curateOutcomeBuildItem) throws IOException, NoSuchAlgorithmException {
        if (launchMode.getLaunchMode().isDevOrTest() && capabilities.isPresent("io.quarkus.jwt")) {
            Config config = ConfigProvider.getConfig();
            Optional decryptKeyLocationOpt = config.getOptionalValue("mp.jwt.decrypt.key.location", String.class);
            Optional signKeyLocationOpt = config.getOptionalValue("smallrye.jwt.sign.key.location", String.class);
            Optional verifyKeyOpt = config.getOptionalValue("mp.jwt.verify.publickey", String.class);
            Optional verifyKeyLocationOpt = config.getOptionalValue("mp.jwt.verify.publickey.location", String.class);
            Optional encryptKeyLocationOpt = config.getOptionalValue("smallrye.jwt.encrypt.key.location", String.class);
            if (!(decryptKeyLocationOpt.isPresent() || signKeyLocationOpt.isPresent() || verifyKeyOpt.isPresent() || verifyKeyLocationOpt.isPresent() || encryptKeyLocationOpt.isPresent())) {
                File buildDir = null;
                ArtifactSources src = curateOutcomeBuildItem.getApplicationModel().getAppArtifact().getSources();
                if (src != null) {
                    Collection srcDirs = src.getResourceDirs();
                    if (srcDirs.isEmpty()) {
                        srcDirs = src.getSourceDirs();
                    }
                    if (!srcDirs.isEmpty()) {
                        Path resourcesOutputDir = ((SourceDir)srcDirs.iterator().next()).getOutputDir();
                        buildDir = resourcesOutputDir.toFile();
                    }
                }
                if (buildDir == null) {
                    buildDir = new File(curateOutcomeBuildItem.getApplicationModel().getAppArtifact().getWorkspaceModule().getBuildDir(), "classes");
                }
                buildDir.mkdirs();
                File privateKey = new File(buildDir, "dev.privateKey.pem");
                File publicKey = new File(buildDir, "dev.publicKey.pem");
                if (!privateKey.exists() && !publicKey.exists()) {
                    KeyPairGenerator kpg = KeyPairGenerator.getInstance("RSA");
                    kpg.initialize(2048);
                    KeyPair kp = kpg.generateKeyPair();
                    logger.infof("Generating private/public keys for DEV/TEST in %s and %s", (Object)privateKey, (Object)publicKey);
                    try (FileWriter fw = new FileWriter(privateKey);){
                        fw.append("-----BEGIN PRIVATE KEY-----\n");
                        fw.append(Base64.getMimeEncoder().encodeToString(kp.getPrivate().getEncoded()));
                        fw.append("\n");
                        fw.append("-----END PRIVATE KEY-----\n");
                    }
                    fw = new FileWriter(publicKey);
                    try {
                        fw.append("-----BEGIN PUBLIC KEY-----\n");
                        fw.append(Base64.getMimeEncoder().encodeToString(kp.getPublic().getEncoded()));
                        fw.append("\n");
                        fw.append("-----END PUBLIC KEY-----\n");
                    }
                    finally {
                        fw.close();
                    }
                }
                runtimeConfigurationBuildItem.produce((BuildItem)new RunTimeConfigurationDefaultBuildItem("mp.jwt.decrypt.key.location", privateKey.getName()));
                runtimeConfigurationBuildItem.produce((BuildItem)new RunTimeConfigurationDefaultBuildItem("smallrye.jwt.sign.key.location", privateKey.getName()));
                runtimeConfigurationBuildItem.produce((BuildItem)new RunTimeConfigurationDefaultBuildItem("mp.jwt.verify.publickey.location", publicKey.getName()));
                runtimeConfigurationBuildItem.produce((BuildItem)new RunTimeConfigurationDefaultBuildItem("smallrye.jwt.encrypt.key.location", publicKey.getName()));
            }
        }
    }

    @BuildStep
    void produceBeans(BuildProducer<AdditionalBeanBuildItem> additionalBeanBuildItems, BuildProducer<ParamConverterBuildItem> paramConverterBuildItems, BuildProducer<AdditionalIndexedClassesBuildItem> additionalIndexedClassesBuildItems, BuildProducer<ApplicationClassPredicateBuildItem> applicationClassPredicateBuildItems) {
        additionalBeanBuildItems.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(Globals.class));
        additionalBeanBuildItems.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(Filters.class));
        additionalBeanBuildItems.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(QuteResolvers.class));
        additionalBeanBuildItems.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(Flash.class));
        additionalBeanBuildItems.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(I18N.class));
        additionalBeanBuildItems.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(RenderArgs.class));
        additionalBeanBuildItems.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(Validation.class));
        additionalBeanBuildItems.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(RenardeValidationLocaleResolver.class));
        additionalBeanBuildItems.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(JavaExtensions.class));
        additionalBeanBuildItems.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(MyValidationInterceptor.class));
        additionalBeanBuildItems.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(RenardeJWTAuthMechanism.class));
        additionalBeanBuildItems.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(RenardeConfigBean.class));
        if (QuarkusClassLoader.isClassPresentAtRuntime((String)DOTNAME_AUTHENTICATION_HANDLER.toString())) {
            additionalBeanBuildItems.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf((String)DOTNAME_AUTHENTICATION_HANDLER.toString()));
        }
        paramConverterBuildItems.produce((BuildItem)new ParamConverterBuildItem(MyParamConverters.class.getName(), 5000, true));
        additionalIndexedClassesBuildItems.produce((BuildItem)new AdditionalIndexedClassesBuildItem(new String[]{Filters.class.getName(), RedirectExceptionMapper.class.getName(), Controller.class.getName(), HxController.class.getName()}));
        applicationClassPredicateBuildItems.produce((BuildItem)new ApplicationClassPredicateBuildItem((Predicate)new Predicate<String>(){

            @Override
            public boolean test(String t) {
                return DOTNAME_RENARDE_SECURITY_CONTROLLER.toString('.').equals(t) || DOTNAME_RENARDE_FORM_LOGIN_CONTROLLER.toString('.').equals(t);
            }
        }));
    }

    @BuildStep
    void registerCustomExceptionMappers(BuildProducer<CustomExceptionMapperBuildItem> customExceptionMapper) {
        if (QuarkusClassLoader.isClassPresentAtRuntime((String)DOTNAME_AUTHENTICATION_HANDLER.toString())) {
            customExceptionMapper.produce((BuildItem)new CustomExceptionMapperBuildItem(DOTNAME_AUTHENTICATION_HANDLER.toString()));
        }
    }

    @BuildStep
    ExcludedTypeBuildItem removeOriginalValidatorInterceptor() {
        return new ExcludedTypeBuildItem(ResteasyReactiveEndPointValidationInterceptor.class.getName());
    }

    @BuildStep
    ExcludedTypeBuildItem removeOriginalJWTAuthMechanism() {
        return new ExcludedTypeBuildItem(JWTAuthMechanism.class.getName());
    }

    @BuildStep
    void produceUserInRequestScope(ApplicationIndexBuildItem indexBuildItem, BuildProducer<GeneratedBeanBuildItem> generatedBeans) {
        Set users = indexBuildItem.getIndex().getAllKnownImplementors(DOTNAME_USER);
        users.addAll(indexBuildItem.getIndex().getAllKnownImplementors(DOTNAME_USER_WITH_PASSWORD));
        if (users.isEmpty()) {
            return;
        }
        if (users.size() > 2) {
            System.err.println("Unable to generate request-scoped user producer: more than one user implementation found: " + users);
            return;
        }
        ClassInfo userClass = (ClassInfo)users.iterator().next();
        GeneratedBeanGizmoAdaptor beansClassOutput = new GeneratedBeanGizmoAdaptor(generatedBeans);
        try (ClassCreator beanClassCreator = ClassCreator.builder().classOutput((ClassOutput)beansClassOutput).className("__RenardeUserProducer").build();){
            beanClassCreator.addAnnotation(RequestScoped.class);
            FieldCreator fieldCreator = beanClassCreator.getFieldCreator("security", DOTNAME_SECURITY.toString());
            fieldCreator.addAnnotation(Inject.class);
            fieldCreator.setModifiers(0);
            try (MethodCreator methodCreator = beanClassCreator.getMethodCreator("getUser", userClass.name().toString(), new String[0]);){
                methodCreator.addAnnotation(Produces.class);
                AnnotationInstance annotationInstance = AnnotationInstance.create((DotName)DOTNAME_NAMED, null, Arrays.asList(AnnotationValue.createStringValue((String)"value", (String)"user")));
                methodCreator.addAnnotation(annotationInstance);
                ResultHandle security = methodCreator.readInstanceField(FieldDescriptor.of((String)beanClassCreator.getClassName(), (String)"security", (String)DOTNAME_SECURITY.toString()), methodCreator.getThis());
                ResultHandle user = methodCreator.invokeVirtualMethod(MethodDescriptor.ofMethod((String)DOTNAME_SECURITY.toString(), (String)"getUser", (String)DOTNAME_USER.toString(), (String[])new String[0]), security, new ResultHandle[0]);
                methodCreator.returnValue(methodCreator.checkCast(user, userClass.name().toString()));
            }
        }
    }

    @BuildStep
    void collectControllers(CombinedIndexBuildItem indexBuildItem, List<ExcludedControllerBuildItem> excludedControllerBuildItems, BuildProducer<AdditionalResourceClassBuildItem> additionalResourceClassBuildItems, BuildProducer<io.quarkus.resteasy.reactive.server.spi.AnnotationsTransformerBuildItem> annotationTransformerBuildItems, BuildProducer<AnnotationsTransformerBuildItem> arcTransformers, BuildProducer<UnremovableBeanBuildItem> unremovableBeans, BuildProducer<BytecodeTransformerBuildItem> bytecodeTransformers, BuildProducer<GeneratedBeanBuildItem> generatedBeans, BuildProducer<LoginPageBuildItem> loginPageBuildItem, BuildProducer<ExecutionModelAnnotationsAllowedBuildItem> executionModelAnnotationsAllowedBuildItems, BuildProducer<AutoAddScopeBuildItem> autoAddScopeBuildItems) {
        HashSet<DotName> excludedControllers = new HashSet<DotName>();
        for (ExcludedControllerBuildItem excludedControllerBuildItem : excludedControllerBuildItems) {
            excludedControllers.add(excludedControllerBuildItem.excludedClass);
        }
        final HashSet<DotName> controllers = new HashSet<DotName>();
        HashMap<String, ControllerVisitor.ControllerClass> methodsByClass = new HashMap<String, ControllerVisitor.ControllerClass>();
        for (ClassInfo controllerInfo : indexBuildItem.getIndex().getAllKnownSubclasses(DOTNAME_CONTROLLER)) {
            if (excludedControllers.contains(controllerInfo.name())) continue;
            controllers.add(controllerInfo.name());
            if (!Modifier.isAbstract(controllerInfo.flags())) {
                additionalResourceClassBuildItems.produce((BuildItem)new AdditionalResourceClassBuildItem(controllerInfo, ""));
                unremovableBeans.produce((BuildItem)UnremovableBeanBuildItem.beanTypes((DotName[])new DotName[]{controllerInfo.name()}));
            }
            methodsByClass.put(controllerInfo.name().toString(), this.scanController(controllerInfo, loginPageBuildItem));
        }
        for (DotName controller : controllers) {
            bytecodeTransformers.produce((BuildItem)new BytecodeTransformerBuildItem(controller.toString(), (BiFunction)new ControllerVisitor(methodsByClass)));
        }
        for (ClassInfo routerUserInfo : indexBuildItem.getIndex().getKnownUsers(DOTNAME_ROUTER)) {
            if (controllers.contains(routerUserInfo.name())) continue;
            bytecodeTransformers.produce((BuildItem)new BytecodeTransformerBuildItem(routerUserInfo.name().toString(), (BiFunction)new RouterUserVisitor()));
        }
        this.generateRouterInit(generatedBeans, methodsByClass);
        annotationTransformerBuildItems.produce((BuildItem)new io.quarkus.resteasy.reactive.server.spi.AnnotationsTransformerBuildItem(org.jboss.resteasy.reactive.common.processor.transformation.AnnotationsTransformer.builder().appliesTo(AnnotationTarget.Kind.METHOD).transform(ti -> this.transformControllerMethod((AnnotationsTransformer.TransformationContext)ti, (Set<DotName>)controllers))));
        annotationTransformerBuildItems.produce((BuildItem)new io.quarkus.resteasy.reactive.server.spi.AnnotationsTransformerBuildItem(org.jboss.resteasy.reactive.common.processor.transformation.AnnotationsTransformer.builder().appliesTo(AnnotationTarget.Kind.CLASS).transform(ti -> this.transformController((AnnotationsTransformer.TransformationContext)ti, (Set<DotName>)controllers))));
        autoAddScopeBuildItems.produce((BuildItem)AutoAddScopeBuildItem.builder().defaultScope(BuiltinScope.REQUEST).match(new AutoAddScopeBuildItem.MatchPredicate(){

            public boolean test(ClassInfo klass, Collection<AnnotationInstance> annotations, IndexView index) {
                return !klass.isInterface() && !Modifier.isAbstract(klass.flags()) && controllers.contains(klass.name());
            }
        }).build());
        arcTransformers.produce((BuildItem)new AnnotationsTransformerBuildItem(new AnnotationsTransformer(){

            public void transform(AnnotationsTransformer.TransformationContext transformationContext) {
                MethodInfo method;
                if (transformationContext.isMethod() && controllers.contains((method = transformationContext.getTarget().asMethod()).declaringClass().name()) && !method.hasAnnotation(DOTNAME_TRANSACTIONAL) && !RenardeProcessor.this.isAsync(method.returnType()) && (method.hasAnnotation(ResteasyReactiveDotNames.POST) || method.hasAnnotation(ResteasyReactiveDotNames.PUT) || method.hasAnnotation(ResteasyReactiveDotNames.DELETE))) {
                    ((Transformation)transformationContext.transform().add(DOTNAME_TRANSACTIONAL, new AnnotationValue[0])).done();
                }
            }
        }));
        executionModelAnnotationsAllowedBuildItems.produce((BuildItem)new ExecutionModelAnnotationsAllowedBuildItem((Predicate)new Predicate<MethodInfo>(){

            @Override
            public boolean test(MethodInfo method) {
                return RenardeProcessor.this.isControllerMethod(method) && controllers.contains(method.declaringClass().name());
            }
        }));
    }

    protected boolean isAsync(Type type) {
        if (type.kind() == Type.Kind.CLASS || type.kind() == Type.Kind.PARAMETERIZED_TYPE) {
            return type.name().equals((Object)DOTNAME_UNI) || type.name().equals((Object)DOTNAME_MULTI);
        }
        return false;
    }

    private void generateRouterInit(BuildProducer<GeneratedBeanBuildItem> generatedBeans, Map<String, ControllerVisitor.ControllerClass> methodsByClass) {
        GeneratedBeanGizmoAdaptor beansClassOutput = new GeneratedBeanGizmoAdaptor(generatedBeans);
        try (ClassCreator beanClassCreator = ClassCreator.builder().classOutput((ClassOutput)beansClassOutput).className("__RenardeInit").build();){
            beanClassCreator.addAnnotation(Singleton.class);
            try (MethodCreator methodCreator = beanClassCreator.getMethodCreator("init", Void.TYPE, new Class[]{StartupEvent.class});){
                methodCreator.getParameterAnnotations(0).addAnnotation(Observes.class);
                methodCreator.invokeStaticMethod(MethodDescriptor.ofMethod(Router.class, (String)"clearRoutes", Void.TYPE, (Class[])new Class[0]), new ResultHandle[0]);
                for (ControllerVisitor.ControllerClass controllerClass : methodsByClass.values()) {
                    int lastDollar;
                    if (controllerClass.isAbstract) continue;
                    String simpleControllerName = controllerClass.className;
                    int lastDot = simpleControllerName.lastIndexOf(46);
                    if (lastDot != -1) {
                        simpleControllerName = simpleControllerName.substring(lastDot + 1);
                    }
                    if ((lastDollar = simpleControllerName.lastIndexOf(36)) != -1) {
                        simpleControllerName = simpleControllerName.substring(lastDollar + 1);
                    }
                    for (ControllerVisitor.ControllerMethod method : controllerClass.getMethods(methodsByClass).values()) {
                        FunctionCreator function = methodCreator.createFunction(RouterMethod.class);
                        String uriMethodName = ControllerVisitor.ControllerClassVisitor.uriVarargsName(method.name, method.descriptor);
                        try (BytecodeCreator functionBytecode = function.getBytecode();){
                            functionBytecode.returnValue(functionBytecode.invokeStaticMethod(MethodDescriptor.ofMethod((Object)controllerClass.className, (String)uriMethodName, URI.class, (Object[])new Object[]{Boolean.TYPE, Object[].class}), new ResultHandle[]{functionBytecode.getMethodParam(0), functionBytecode.getMethodParam(1)}));
                        }
                        methodCreator.invokeStaticMethod(MethodDescriptor.ofMethod(Router.class, (String)"registerRoute", Void.TYPE, (Class[])new Class[]{String.class, RouterMethod.class}), new ResultHandle[]{methodCreator.load(simpleControllerName + "." + method.name), function.getInstance()});
                    }
                }
                methodCreator.returnValue(null);
            }
        }
    }

    private ControllerVisitor.ControllerClass scanController(ClassInfo controllerInfo, BuildProducer<LoginPageBuildItem> loginPageBuildItem) {
        HashMap<String, ControllerVisitor.ControllerMethod> methods = new HashMap<String, ControllerVisitor.ControllerMethod>();
        for (MethodInfo method : controllerInfo.methods()) {
            if (!this.isControllerMethod(method)) continue;
            ArrayList<ControllerVisitor.UriPart> parts = new ArrayList<ControllerVisitor.UriPart>();
            String path = this.getMethodPath(controllerInfo, method);
            parts.add(new ControllerVisitor.StaticUriPart(path));
            HashSet pathParameters = new HashSet();
            URLUtils.parsePathParameters((String)path, pathParameters);
            Map<DotName, AnnotationInstance>[] parameterAnnotations = this.getParameterAnnotations(method);
            int asmParamIndex = 1;
            for (int paramIndex = 0; paramIndex < method.parametersCount(); ++paramIndex) {
                AnnotationInstance restQueryParam;
                AnnotationInstance queryParam;
                AnnotationInstance restPathParam;
                String paramName = method.parameterName(paramIndex);
                AnnotationInstance pathParam = parameterAnnotations[paramIndex].get(ResteasyReactiveDotNames.PATH_PARAM);
                if (pathParam != null) {
                    String name = (String)pathParam.value().value();
                    parts.add(new ControllerVisitor.PathParamUriPart(name, paramIndex, asmParamIndex, pathParameters.contains(paramName)));
                }
                if ((restPathParam = parameterAnnotations[paramIndex].get(ResteasyReactiveDotNames.REST_PATH_PARAM)) != null) {
                    String name;
                    String string = name = restPathParam.value() != null ? (String)restPathParam.value().value() : "";
                    if (name != null) {
                        name = paramName;
                    }
                    parts.add(new ControllerVisitor.PathParamUriPart(name, paramIndex, asmParamIndex, pathParameters.contains(paramName)));
                }
                if (pathParameters.contains(paramName)) {
                    parts.add(new ControllerVisitor.PathParamUriPart(paramName, paramIndex, asmParamIndex, true));
                }
                if ((queryParam = parameterAnnotations[paramIndex].get(ResteasyReactiveDotNames.QUERY_PARAM)) != null) {
                    String name = (String)queryParam.value().value();
                    parts.add(new ControllerVisitor.QueryParamUriPart(name, paramIndex, asmParamIndex));
                }
                if ((restQueryParam = parameterAnnotations[paramIndex].get(ResteasyReactiveDotNames.REST_QUERY_PARAM)) != null) {
                    String name;
                    String string = name = restQueryParam.value() != null ? (String)restQueryParam.value().value() : "";
                    if (name.isEmpty()) {
                        name = paramName;
                    }
                    parts.add(new ControllerVisitor.QueryParamUriPart(name, paramIndex, asmParamIndex));
                }
                asmParamIndex += AsmUtil.getParameterSize((Type)method.parameterType(paramIndex));
            }
            if (method.hasAnnotation(DOTNAME_LOGIN_PAGE)) {
                loginPageBuildItem.produce((BuildItem)new LoginPageBuildItem(parts));
            }
            String descriptor = method.descriptor();
            String key = method.name() + "/" + descriptor;
            methods.put(key, new ControllerVisitor.ControllerMethod(method.name(), descriptor, parts, method.parameterTypes()));
        }
        return new ControllerVisitor.ControllerClass(controllerInfo.name().toString(), controllerInfo.superName().toString(), Modifier.isAbstract(controllerInfo.flags()), methods);
    }

    private String getMethodPath(ClassInfo controllerInfo, MethodInfo method) {
        String methodPathValue;
        AnnotationInstance classPath = method.declaringClass().declaredAnnotation(ResteasyReactiveDotNames.PATH);
        String className = method.declaringClass().simpleName();
        Object classPathValue = classPath != null ? classPath.value().value().toString() : null;
        AnnotationInstance methodPath = method.annotation(ResteasyReactiveDotNames.PATH);
        String string = methodPathValue = methodPath != null ? methodPath.value().value().toString() : method.name();
        if (classPathValue == null) {
            if (methodPathValue.startsWith("/")) {
                return methodPathValue;
            }
            classPathValue = className;
        }
        if (((String)classPathValue).equals("/")) {
            classPathValue = "";
        } else if (!((String)classPathValue).isEmpty() && !((String)classPathValue).startsWith("/")) {
            classPathValue = "/" + (String)classPathValue;
        }
        boolean needsSeparator = !((String)classPathValue).endsWith("/") && !methodPathValue.startsWith("/");
        Object ret = (String)classPathValue + (needsSeparator ? "/" : "") + methodPathValue;
        if (((String)ret).length() > 1 && ((String)ret).endsWith("/")) {
            ret = ((String)ret).substring(0, ((String)ret).length() - 1);
        }
        return ret;
    }

    private boolean isControllerMethod(MethodInfo method) {
        return !Modifier.isAbstract(method.flags()) && Modifier.isPublic(method.flags()) && !Modifier.isNative(method.flags()) && !Modifier.isStatic(method.flags()) && !method.name().equals("<init>") && !method.name().equals("<clinit>") && !method.hasDeclaredAnnotation(ServerExceptionMapper.class);
    }

    private void transformController(AnnotationsTransformer.TransformationContext ti, Set<DotName> controllers) {
        ClassInfo klass = ti.getTarget().asClass();
        if (controllers.contains(klass.name()) && !Modifier.isAbstract(klass.flags()) && klass.declaredAnnotation(ResteasyReactiveDotNames.PATH) == null) {
            ((org.jboss.resteasy.reactive.common.processor.transformation.Transformation)ti.transform().add(ResteasyReactiveDotNames.PATH, new AnnotationValue[]{AnnotationValue.createStringValue((String)"value", (String)"")})).done();
        }
    }

    private void transformControllerMethod(AnnotationsTransformer.TransformationContext ti, Set<DotName> controllers) {
        MethodInfo method = ti.getTarget().asMethod();
        if (!this.isControllerMethod(method)) {
            return;
        }
        if (controllers.contains(method.declaringClass().name())) {
            Object methodPathValue;
            AnnotationInstance classPath = method.declaringClass().declaredAnnotation(ResteasyReactiveDotNames.PATH);
            String path = this.getMethodPath(method.declaringClass(), method);
            AnnotationInstance methodPath = method.declaredAnnotation(ResteasyReactiveDotNames.PATH);
            boolean setMethodPath = false;
            if (classPath == null) {
                methodPathValue = path;
                setMethodPath = true;
            } else if (methodPath != null) {
                methodPathValue = methodPath.value().value().toString();
            } else {
                methodPathValue = method.name();
                setMethodPath = true;
            }
            HashSet pathParameters = new HashSet();
            URLUtils.parsePathParameters((String)path, pathParameters);
            Map<DotName, AnnotationInstance>[] parameterAnnotations = this.getParameterAnnotations(method);
            for (int paramPos = 0; paramPos < method.parametersCount(); ++paramPos) {
                if (parameterAnnotations[paramPos].get(ResteasyReactiveDotNames.PATH_PARAM) == null && parameterAnnotations[paramPos].get(ResteasyReactiveDotNames.REST_PATH_PARAM) == null || pathParameters.contains(method.parameterName(paramPos))) continue;
                methodPathValue = (String)methodPathValue + "/{" + method.parameterName(paramPos) + "}";
                setMethodPath = true;
            }
            if (setMethodPath) {
                org.jboss.resteasy.reactive.common.processor.transformation.Transformation transform = ti.transform();
                if (methodPath != null) {
                    transform.remove(ai -> ai.name().equals((Object)ResteasyReactiveDotNames.PATH));
                }
                transform.add(ResteasyReactiveDotNames.PATH, new AnnotationValue[]{AnnotationValue.createStringValue((String)"value", (String)methodPathValue)});
                transform.done();
            }
            if (!(method.hasAnnotation(ResteasyReactiveDotNames.GET) || method.hasAnnotation(ResteasyReactiveDotNames.PUT) || method.hasAnnotation(ResteasyReactiveDotNames.POST) || method.hasAnnotation(ResteasyReactiveDotNames.HEAD) || method.hasAnnotation(ResteasyReactiveDotNames.OPTIONS) || method.hasAnnotation(ResteasyReactiveDotNames.DELETE))) {
                ((org.jboss.resteasy.reactive.common.processor.transformation.Transformation)ti.transform().add(ResteasyReactiveDotNames.GET, new AnnotationValue[0])).done();
            }
        }
    }

    private Map<DotName, AnnotationInstance>[] getParameterAnnotations(MethodInfo method) {
        Map[] parameterAnnotations = new Map[method.parametersCount()];
        for (int paramPos = 0; paramPos < method.parametersCount(); ++paramPos) {
            parameterAnnotations[paramPos] = new HashMap();
        }
        for (AnnotationInstance i : method.annotations()) {
            if (i.target().kind() != AnnotationTarget.Kind.METHOD_PARAMETER) continue;
            parameterAnnotations[i.target().asMethodParameter().position()].put(i.name(), i);
        }
        return parameterAnnotations;
    }

    @BuildStep
    void removeHxController(BuildProducer<ExcludedControllerBuildItem> excludedControllerBuildItems) {
        excludedControllerBuildItems.produce((BuildItem)new ExcludedControllerBuildItem(DOTNAME_HX_CONTROLLER));
    }

    @BuildStep
    void removeLoginControllerIfNoUserWithPassword(CombinedIndexBuildItem indexBuildItem, BuildProducer<ExcludedControllerBuildItem> excludedControllerBuildItems, BuildProducer<ExcludedTypeBuildItem> excludedTypeBuildItems, BuildProducer<BuildTimeConditionBuildItem> buildTimeConditionBuildItems) {
        if (indexBuildItem.getIndex().getAllKnownImplementors(DOTNAME_USER_WITH_PASSWORD).isEmpty()) {
            excludedControllerBuildItems.produce((BuildItem)new ExcludedControllerBuildItem(DOTNAME_RENARDE_FORM_LOGIN_CONTROLLER));
            excludedTypeBuildItems.produce((BuildItem)new ExcludedTypeBuildItem(DOTNAME_RENARDE_FORM_LOGIN_CONTROLLER.toString()));
            ClassInfo klass = indexBuildItem.getIndex().getClassByName(DOTNAME_RENARDE_FORM_LOGIN_CONTROLLER);
            if (klass != null) {
                buildTimeConditionBuildItems.produce((BuildItem)new BuildTimeConditionBuildItem((AnnotationTarget)klass, false));
            }
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void configureLoginPage(RenardeRecorder recorder, LoginPageBuildItem loginPageBuildItem, BeanContainerBuildItem beanContainerBuildItem) {
        Object loginPage;
        if (loginPageBuildItem != null) {
            loginPage = loginPageBuildItem.uri;
        } else {
            Config config = ConfigProvider.getConfig();
            String oidcLoginPage = null;
            for (String provider : SUPPORTED_OIDC_PROVIDERS) {
                if (!config.getOptionalValue("quarkus.oidc." + provider + ".provider", String.class).isPresent() && !config.getOptionalValue("quarkus.oidc." + provider + ".client-id", String.class).isPresent()) continue;
                if (oidcLoginPage == null) {
                    oidcLoginPage = "/_renarde/security/login-" + provider;
                    continue;
                }
                oidcLoginPage = null;
                break;
            }
            loginPage = oidcLoginPage != null ? oidcLoginPage : "/";
        }
        recorder.configureLoginPage(beanContainerBuildItem.getValue(), (String)loginPage);
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void findMessageFiles(RenardeRecorder recorder, BeanContainerBuildItem beanContainerBuildItem, ApplicationArchivesBuildItem applicationArchivesBuildItem, LocalesBuildTimeConfig locales, BuildProducer<NativeImageResourceBuildItem> nativeImageResources, BuildProducer<HotDeploymentWatchedFileBuildItem> watchedFiles) throws IOException {
        HashMap languageToPath = new HashMap();
        for (ApplicationArchive applicationArchive : applicationArchivesBuildItem.getAllApplicationArchives()) {
            applicationArchive.accept(tree -> {
                for (Path root : tree.getRoots()) {
                    try {
                        Stream<Path> files = Files.list(root);
                        try {
                            Iterator iter = files.iterator();
                            while (iter.hasNext()) {
                                Path filePath = (Path)iter.next();
                                String name = filePath.getFileName().toString();
                                if (!Files.isRegularFile(filePath, new LinkOption[0]) || !name.startsWith("messages.") && !name.startsWith("messages_") || !name.endsWith(".properties")) continue;
                                String language = name.startsWith("messages.") ? locales.defaultLocale.getLanguage() : name.substring(9, name.length() - 11);
                                Path relativePath = root.relativize(filePath);
                                languageToPath.put(language, relativePath);
                            }
                        }
                        finally {
                            if (files == null) continue;
                            files.close();
                        }
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
            });
        }
        for (Path path : languageToPath.values()) {
            watchedFiles.produce((BuildItem)new HotDeploymentWatchedFileBuildItem(path.toString()));
            nativeImageResources.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{path.toString()}));
        }
        for (Map.Entry entry : languageToPath.entrySet()) {
            recorder.addLanguageBundle(beanContainerBuildItem.getValue(), (String)entry.getKey(), ((Path)entry.getValue()).toString());
        }
        for (Locale locale : locales.locales) {
            String lang = locale.getLanguage();
            if (languageToPath.containsKey(lang)) continue;
            logger.warnf("Locale %s is declared in 'quarkus.locales' but no matching messages_%s.properties resource file found", (Object)lang, (Object)lang);
        }
        if (!languageToPath.isEmpty()) {
            logger.infof("Supported locales with messages: %s", languageToPath.keySet());
        }
    }
}

