/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.renarde.deployment;

import io.quarkiverse.renarde.Controller;
import io.quarkiverse.renarde.deployment.RouterMethodVisitor;
import io.quarkiverse.renarde.router.Router;
import io.quarkus.deployment.util.AsmUtil;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.util.HashUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Type;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;

public class ControllerVisitor
implements BiFunction<String, ClassVisitor, ClassVisitor> {
    public static final DotName DOTNAME_LONG = DotName.createSimple((String)Long.class.getName());
    public static final DotName DOTNAME_OPTIONAL = DotName.createSimple((String)Optional.class.getName());
    public static final String ROUTER_BINARY_NAME = Router.class.getName().replace('.', '/');
    public static final String CONTROLLER_BINARY_NAME = Controller.class.getName().replace('.', '/');
    public static final String CONTROLLER_DESCRIPTOR = "L" + CONTROLLER_BINARY_NAME + ";";
    Map<String, ControllerClass> controllers;

    public ControllerVisitor(Map<String, ControllerClass> controllers) {
        this.controllers = controllers;
    }

    @Override
    public ClassVisitor apply(String className, ClassVisitor visitor) {
        return new ControllerClassVisitor(this.controllers.get(className), this.controllers, visitor);
    }

    public static class ControllerClassVisitor
    extends ClassVisitor {
        private String className;
        private ControllerClass controller;
        private Map<String, ControllerClass> controllers;

        public ControllerClassVisitor(ControllerClass controller, Map<String, ControllerClass> controllers, ClassVisitor classVisitor) {
            super(589824, classVisitor);
            this.controller = controller;
            this.controllers = controllers;
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            super.visit(version, access, name, signature, superName, interfaces);
            this.className = name;
        }

        public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
            MethodVisitor visitor = super.visitMethod(access, name, descriptor, signature, exceptions);
            return new RouterMethodVisitor(589824, visitor){

                @Override
                public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
                    boolean cleanupTarget = false;
                    if (opcode == 182) {
                        String ownerClass = owner.replace('/', '.');
                        ControllerClass ownerController = controllers.get(ownerClass);
                        String key = (String)name + "/" + descriptor;
                        if (ownerController != null && ownerController.methods.get(key) != null) {
                            super.visitIntInsn(25, 0);
                            super.visitMethodInsn(182, CONTROLLER_BINARY_NAME, "beforeRedirect", "()V", false);
                            name = "__redirect$" + (String)name;
                            opcode = 184;
                            cleanupTarget = true;
                        } else if (owner.equals(className) && ((String)name).equals("redirect") && descriptor.equals("(Ljava/lang/Class;)" + CONTROLLER_DESCRIPTOR)) {
                            super.visitInsn(87);
                            super.visitInsn(87);
                            super.visitInsn(1);
                            return;
                        }
                    }
                    super.visitMethodInsn(opcode, owner, (String)name, descriptor, isInterface);
                    if (cleanupTarget) {
                        if (!descriptor.endsWith(")V")) {
                            super.visitInsn(95);
                        }
                        super.visitInsn(87);
                    }
                }
            };
        }

        public void visitEnd() {
            for (ControllerMethod method : this.controller.methods.values()) {
                this.makeUriMethod(method);
                this.makeUriVarargsMethod(method);
                this.makeRedirectMethod(method);
            }
            super.visitEnd();
        }

        private void makeUriVarargsMethod(ControllerMethod method) {
            MethodVisitor visitor = super.visitMethod(4233, ControllerClassVisitor.uriVarargsName(method.name, method.descriptor), "(Z[Ljava/lang/Object;)Ljava/net/URI;", null, null);
            visitor.visitVarInsn(21, 0);
            int index = 0;
            for (Type parameterType : method.parameters) {
                visitor.visitVarInsn(25, 1);
                visitor.visitInsn(190);
                Label end = new Label();
                Label elseBranch = new Label();
                visitor.visitIntInsn(16, index);
                visitor.visitJumpInsn(164, elseBranch);
                visitor.visitVarInsn(25, 1);
                visitor.visitIntInsn(16, index);
                visitor.visitInsn(50);
                if (parameterType.kind() == Type.Kind.PRIMITIVE) {
                    ControllerClassVisitor.unboxOrWidenIfRequired(visitor, parameterType);
                } else if (parameterType.name().equals((Object)DOTNAME_OPTIONAL)) {
                    visitor.visitMethodInsn(184, Router.class.getName().replace('.', '/'), "ofNullable", "(Ljava/lang/Object;)Ljava/util/Optional;", false);
                } else {
                    visitor.visitTypeInsn(192, parameterType.name().toString('/'));
                }
                visitor.visitJumpInsn(167, end);
                visitor.visitLabel(elseBranch);
                if (parameterType.kind() == Type.Kind.PRIMITIVE) {
                    switch (parameterType.asPrimitiveType().primitive()) {
                        case BOOLEAN: 
                        case BYTE: 
                        case SHORT: 
                        case INT: 
                        case CHAR: {
                            visitor.visitInsn(3);
                            break;
                        }
                        case DOUBLE: {
                            visitor.visitInsn(14);
                            break;
                        }
                        case FLOAT: {
                            visitor.visitInsn(11);
                            break;
                        }
                        case LONG: {
                            visitor.visitInsn(9);
                        }
                    }
                } else if (parameterType.name().equals((Object)DOTNAME_OPTIONAL)) {
                    visitor.visitMethodInsn(184, "java/util/Optional", "empty", "()Ljava/util/Optional;", false);
                } else {
                    visitor.visitInsn(1);
                }
                visitor.visitLabel(end);
                ++index;
            }
            visitor.visitMethodInsn(184, this.className, "__uri$" + method.name, this.uriDescriptor(method), false);
            visitor.visitInsn(176);
            visitor.visitMaxs(0, 0);
            visitor.visitEnd();
        }

        public static void unboxOrWidenIfRequired(MethodVisitor mv, Type jandexType) {
            if (jandexType.kind() == Type.Kind.PRIMITIVE) {
                switch (jandexType.asPrimitiveType().primitive()) {
                    case BOOLEAN: {
                        ControllerClassVisitor.unbox(mv, "java/lang/Boolean", "booleanValue", "Z");
                        break;
                    }
                    case BYTE: {
                        ControllerClassVisitor.unbox(mv, "java/lang/Number", "byteValue", "B");
                        break;
                    }
                    case CHAR: {
                        ControllerClassVisitor.unbox(mv, "java/lang/Character", "charValue", "C");
                        break;
                    }
                    case DOUBLE: {
                        ControllerClassVisitor.unbox(mv, "java/lang/Number", "doubleValue", "D");
                        break;
                    }
                    case FLOAT: {
                        ControllerClassVisitor.unbox(mv, "java/lang/Number", "floatValue", "F");
                        break;
                    }
                    case INT: {
                        ControllerClassVisitor.unbox(mv, "java/lang/Number", "intValue", "I");
                        break;
                    }
                    case LONG: {
                        ControllerClassVisitor.unbox(mv, "java/lang/Number", "longValue", "J");
                        break;
                    }
                    case SHORT: {
                        ControllerClassVisitor.unbox(mv, "java/lang/Number", "shortValue", "S");
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown primitive type: " + String.valueOf(jandexType));
                    }
                }
            }
        }

        private static void unbox(MethodVisitor mv, String owner, String methodName, String returnTypeSignature) {
            mv.visitTypeInsn(192, owner);
            mv.visitMethodInsn(182, owner, methodName, "()" + returnTypeSignature, false);
        }

        static String uriVarargsName(String name, String descriptor) {
            return "__urivarargs$" + name + "$" + HashUtil.sha1((String)descriptor);
        }

        private void makeRedirectMethod(ControllerMethod method) {
            MethodVisitor visitor = super.visitMethod(4105, "__redirect$" + method.name, method.descriptor, null, null);
            visitor.visitInsn(4);
            int index = 0;
            for (Type parameterType : method.parameters) {
                visitor.visitVarInsn(AsmUtil.getLoadOpcode((Type)parameterType), index);
                index += AsmUtil.getParameterSize((Type)parameterType);
            }
            visitor.visitMethodInsn(184, this.className, "__uri$" + method.name, this.uriDescriptor(method), false);
            visitor.visitMethodInsn(184, CONTROLLER_BINARY_NAME, "seeOther", "(Ljava/net/URI;)Ljakarta/ws/rs/core/Response;", false);
            visitor.visitInsn(87);
            int lastParen = method.descriptor.lastIndexOf(41);
            String returnDescriptor = method.descriptor.substring(lastParen + 1);
            int returnInstruction = AsmUtil.getReturnInstruction((String)returnDescriptor);
            switch (returnInstruction) {
                case 177: {
                    break;
                }
                case 176: {
                    visitor.visitInsn(1);
                    break;
                }
                case 175: {
                    visitor.visitInsn(14);
                    break;
                }
                case 174: {
                    visitor.visitInsn(11);
                    break;
                }
                case 172: {
                    visitor.visitInsn(3);
                    break;
                }
                case 173: {
                    visitor.visitInsn(9);
                }
            }
            visitor.visitInsn(returnInstruction);
            visitor.visitMaxs(0, 0);
            visitor.visitEnd();
        }

        private String uriDescriptor(ControllerMethod method) {
            int lastParen = method.descriptor.lastIndexOf(41);
            return "(Z" + method.descriptor.substring(1, lastParen + 1) + "Ljava/net/URI;";
        }

        private void makeUriMethod(ControllerMethod method) {
            String descriptor = this.uriDescriptor(method);
            int uriBuilderIndex = 1;
            for (Type parameterType : method.parameters) {
                uriBuilderIndex += AsmUtil.getParameterSize((Type)parameterType);
            }
            MethodVisitor visitor = super.visitMethod(4105, "__uri$" + method.name, descriptor, null, null);
            visitor.visitVarInsn(21, 0);
            String staticMethod = "getUriBuilder";
            if (LaunchMode.current() == LaunchMode.TEST) {
                staticMethod = "getTestUriBuilder";
            }
            visitor.visitMethodInsn(184, ROUTER_BINARY_NAME, staticMethod, "(Z)Ljakarta/ws/rs/core/UriBuilder;", false);
            visitor.visitVarInsn(58, uriBuilderIndex);
            for (UriPart part : method.parts) {
                Type paramType;
                if (part instanceof StaticUriPart) {
                    visitor.visitVarInsn(25, uriBuilderIndex);
                    visitor.visitLdcInsn((Object)((StaticUriPart)part).part);
                    visitor.visitMethodInsn(182, "jakarta/ws/rs/core/UriBuilder", "path", "(Ljava/lang/String;)Ljakarta/ws/rs/core/UriBuilder;", false);
                    visitor.visitInsn(87);
                    continue;
                }
                if (part instanceof PathParamUriPart) {
                    PathParamUriPart pathPart = (PathParamUriPart)part;
                    if (!pathPart.declared) {
                        visitor.visitVarInsn(25, uriBuilderIndex);
                        visitor.visitLdcInsn((Object)("{" + pathPart.name + "}"));
                        visitor.visitMethodInsn(182, "jakarta/ws/rs/core/UriBuilder", "path", "(Ljava/lang/String;)Ljakarta/ws/rs/core/UriBuilder;", false);
                        visitor.visitInsn(87);
                    }
                    visitor.visitVarInsn(25, uriBuilderIndex);
                    visitor.visitLdcInsn((Object)pathPart.name);
                    paramType = method.parameters.get(pathPart.paramIndex);
                    visitor.visitVarInsn(AsmUtil.getLoadOpcode((Type)paramType), pathPart.asmParamIndex);
                    AsmUtil.boxIfRequired((MethodVisitor)visitor, (Type)paramType);
                    visitor.visitMethodInsn(182, "jakarta/ws/rs/core/UriBuilder", "resolveTemplate", "(Ljava/lang/String;Ljava/lang/Object;)Ljakarta/ws/rs/core/UriBuilder;", false);
                    visitor.visitInsn(87);
                    continue;
                }
                if (!(part instanceof QueryParamUriPart)) continue;
                QueryParamUriPart queryPart = (QueryParamUriPart)part;
                paramType = method.parameters.get(queryPart.paramIndex);
                Label end = new Label();
                if (paramType.name().equals((Object)DOTNAME_OPTIONAL)) {
                    visitor.visitVarInsn(25, queryPart.asmParamIndex);
                    visitor.visitMethodInsn(182, "java/util/Optional", "isPresent", "()Z", false);
                    visitor.visitJumpInsn(153, end);
                } else if (paramType.kind() != Type.Kind.PRIMITIVE) {
                    visitor.visitVarInsn(25, queryPart.asmParamIndex);
                    visitor.visitJumpInsn(198, end);
                }
                visitor.visitVarInsn(25, uriBuilderIndex);
                visitor.visitLdcInsn((Object)queryPart.name);
                visitor.visitInsn(4);
                visitor.visitTypeInsn(189, "java/lang/Object");
                visitor.visitInsn(89);
                visitor.visitInsn(3);
                visitor.visitVarInsn(AsmUtil.getLoadOpcode((Type)paramType), queryPart.asmParamIndex);
                AsmUtil.boxIfRequired((MethodVisitor)visitor, (Type)paramType);
                if (paramType.name().equals((Object)DOTNAME_OPTIONAL)) {
                    visitor.visitMethodInsn(182, "java/util/Optional", "get", "()Ljava/lang/Object;", false);
                }
                visitor.visitInsn(83);
                visitor.visitMethodInsn(182, "jakarta/ws/rs/core/UriBuilder", "queryParam", "(Ljava/lang/String;[Ljava/lang/Object;)Ljakarta/ws/rs/core/UriBuilder;", false);
                visitor.visitInsn(87);
                if (paramType.kind() == Type.Kind.PRIMITIVE) continue;
                visitor.visitLabel(end);
            }
            visitor.visitVarInsn(25, uriBuilderIndex);
            visitor.visitInsn(3);
            visitor.visitTypeInsn(189, "java/lang/Object");
            visitor.visitMethodInsn(182, "jakarta/ws/rs/core/UriBuilder", "build", "([Ljava/lang/Object;)Ljava/net/URI;", false);
            visitor.visitInsn(176);
            visitor.visitMaxs(0, 0);
            visitor.visitEnd();
        }
    }

    static class ControllerClass {
        public final String className;
        public final String superClass;
        public final boolean isAbstract;
        public final Map<String, ControllerMethod> methods;

        public ControllerClass(String className, String superClass, boolean isAbstract, Map<String, ControllerMethod> methods) {
            this.className = className;
            this.superClass = superClass;
            this.isAbstract = isAbstract;
            this.methods = methods;
        }

        public Map<String, ControllerMethod> getMethods(Map<String, ControllerClass> methodsByClass) {
            ControllerClass superController = methodsByClass.get(this.superClass);
            if (superController == null) {
                return this.methods;
            }
            Map<String, ControllerMethod> superMethods = superController.getMethods(methodsByClass);
            HashMap<String, ControllerMethod> allMethods = new HashMap<String, ControllerMethod>(superMethods);
            allMethods.putAll(this.methods);
            return allMethods;
        }
    }

    static class ControllerMethod {
        public final String name;
        public final String descriptor;
        public final List<UriPart> parts;
        public final List<Type> parameters;

        public ControllerMethod(String name, String descriptor, List<UriPart> parts, List<Type> parameters) {
            this.name = name;
            this.descriptor = descriptor;
            this.parts = parts;
            this.parameters = parameters;
        }
    }

    static class QueryParamUriPart
    extends UriPart {
        public final String name;
        public final int asmParamIndex;
        public final int paramIndex;

        public QueryParamUriPart(String name, int paramIndex, int asmParamIndex) {
            this.name = name;
            this.paramIndex = paramIndex;
            this.asmParamIndex = asmParamIndex;
        }
    }

    static class PathParamUriPart
    extends UriPart {
        public final String name;
        public final int asmParamIndex;
        public final int paramIndex;
        public final boolean declared;

        public PathParamUriPart(String name, int paramIndex, int asmParamIndex, boolean declared) {
            this.name = name;
            this.asmParamIndex = asmParamIndex;
            this.paramIndex = paramIndex;
            this.declared = declared;
        }
    }

    static class StaticUriPart
    extends UriPart {
        public final String part;

        public StaticUriPart(String part) {
            this.part = part;
        }
    }

    static abstract class UriPart {
        UriPart() {
        }
    }
}

