/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.renarde.jpa.deployment;

import io.quarkiverse.renarde.jpa.NamedBlob;
import io.quarkiverse.renarde.util.JavaExtensions;
import io.quarkus.panache.common.deployment.EntityField;
import io.quarkus.panache.common.deployment.EntityModel;
import io.quarkus.panache.common.deployment.MetamodelInfo;
import jakarta.persistence.Column;
import jakarta.persistence.Enumerated;
import jakarta.persistence.Id;
import jakarta.persistence.Lob;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.Size;
import java.lang.annotation.Annotation;
import java.sql.Types;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.hibernate.annotations.JdbcTypeCode;
import org.hibernate.validator.constraints.Length;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;

public class ModelField {
    private static final DotName DOTNAME_MANYTOMANY = DotName.createSimple((String)ManyToMany.class.getName());
    private static final DotName DOTNAME_MANYTOONE = DotName.createSimple((String)ManyToOne.class.getName());
    private static final DotName DOTNAME_ONETOMANY = DotName.createSimple((String)OneToMany.class.getName());
    private static final DotName DOTNAME_ONETOONE = DotName.createSimple((String)OneToOne.class.getName());
    private static final DotName DOTNAME_ENUMERATED = DotName.createSimple((String)Enumerated.class.getName());
    private static final DotName DOTNAME_COLUMN = DotName.createSimple((String)Column.class.getName());
    private static final DotName DOTNAME_LENGTH = DotName.createSimple((String)Length.class.getName());
    private static final DotName DOTNAME_SIZE = DotName.createSimple((String)Size.class.getName());
    private static final DotName DOTNAME_JDBC_TYPE_CODE = DotName.createSimple((String)JdbcTypeCode.class.getName());
    private static final DotName DOTNAME_TYPES = DotName.createSimple((String)Types.class.getName());
    private static final DotName DOTNAME_LOB = DotName.createSimple((String)Lob.class.getName());
    private static final DotName DOTNAME_ID = DotName.createSimple((String)Id.class.getName());
    public static final String NAMED_BLOB_DESCRIPTOR = "L" + NamedBlob.class.getName().replace('.', '/') + ";";
    public String name;
    public String label;
    public Type type = Type.Text;
    public String relationClass;
    public long min;
    public long max;
    public double step;
    public String help;
    public EntityField entityField;
    public EntityField inverseField;
    public List<Class<? extends Annotation>> validation = new ArrayList<Class<? extends Annotation>>();
    public String signature;
    public boolean relationOwner;
    public boolean id;

    public ModelField(EntityField entityField, String entityClass, MetamodelInfo metamodelInfo, IndexView index) {
        this.name = entityField.name;
        this.label = JavaExtensions.capitalised((String)this.name);
        ClassInfo classInfo = index.getClassByName(DotName.createSimple((String)entityClass));
        FieldInfo field = classInfo.field(entityField.name);
        this.signature = field.genericSignature();
        AnnotationInstance oneToOne = field.annotation(DOTNAME_ONETOONE);
        AnnotationInstance column = field.annotation(DOTNAME_COLUMN);
        AnnotationInstance jdbcTypeCode = field.annotation(DOTNAME_JDBC_TYPE_CODE);
        boolean bl = this.id = field.annotation(DOTNAME_ID) != null;
        if (jdbcTypeCode != null && jdbcTypeCode.value().asInt() == 3001) {
            this.type = Type.JSON;
        } else if (entityField.descriptor.equals("B")) {
            this.type = Type.Number;
            this.min = -128L;
            this.max = 127L;
            this.step = 1.0;
        } else if (entityField.descriptor.equals("S")) {
            this.type = Type.Number;
            this.min = -32768L;
            this.max = 32767L;
            this.step = 1.0;
        } else if (entityField.descriptor.equals("I") || entityField.descriptor.equals("Ljava/lang/Integer;")) {
            this.type = Type.Number;
            this.min = Integer.MIN_VALUE;
            this.max = Integer.MAX_VALUE;
            this.step = 1.0;
        } else if (entityField.descriptor.equals("J") || entityField.descriptor.equals("Ljava/lang/Long;")) {
            this.type = Type.Number;
            this.min = Long.MIN_VALUE;
            this.max = Long.MAX_VALUE;
            this.step = 1.0;
        } else if (entityField.descriptor.equals("C")) {
            this.type = Type.Text;
            this.min = 1L;
            this.max = 1L;
        } else if (entityField.descriptor.equals("D")) {
            this.type = Type.Number;
            this.step = 1.0E-5;
        } else if (entityField.descriptor.equals("F")) {
            this.type = Type.Number;
            this.step = 1.0E-5;
        } else if (entityField.descriptor.equals("Z") || entityField.descriptor.equals("Ljava/lang/Boolean;")) {
            this.type = Type.Checkbox;
        } else if (entityField.descriptor.equals("[B") || entityField.descriptor.equals("Ljava/sql/Blob;") || entityField.descriptor.equals(NAMED_BLOB_DESCRIPTOR)) {
            this.type = Type.Binary;
        } else if (entityField.descriptor.equals("Ljava/lang/String;")) {
            AnnotationInstance length = field.annotation(DOTNAME_LENGTH);
            AnnotationInstance size = field.annotation(DOTNAME_SIZE);
            this.type = column != null && column.value("length") != null && column.value("length").asInt() > 255 ? Type.LargeText : (length != null && length.value("max") != null && length.value("max").asInt() > 255 ? Type.LargeText : (size != null && size.value("max") != null && size.value("max").asInt() > 255 ? Type.LargeText : (jdbcTypeCode != null && jdbcTypeCode.value() != null && jdbcTypeCode.value().asInt() == -1 ? Type.LargeText : (field.hasAnnotation(DOTNAME_LOB) ? Type.LargeText : Type.Text))));
        } else if (entityField.descriptor.equals("Ljava/util/Date;") || entityField.descriptor.equals("Ljava/time/LocalDateTime;")) {
            this.type = Type.DateTimeLocal;
        } else if (entityField.descriptor.equals("Ljava/time/LocalDate;")) {
            this.type = Type.Date;
        } else if (entityField.descriptor.equals("Ljava/time/LocalTime;")) {
            this.type = Type.Time;
        } else if (entityField.descriptor.equals("Ljava/sql/Timestamp;")) {
            this.type = Type.Timestamp;
        } else if (field.hasAnnotation(DOTNAME_ENUMERATED)) {
            this.type = Type.Enum;
        } else if (field.hasAnnotation(DOTNAME_ONETOMANY)) {
            this.type = Type.MultiRelation;
            this.relationClass = ((org.jboss.jandex.Type)field.type().asParameterizedType().arguments().get(0)).name().toString();
            EntityModel relationModel = metamodelInfo.getEntityModel(this.relationClass);
            AnnotationValue mappedBy = field.annotation(DOTNAME_ONETOMANY).value("mappedBy");
            String inverseField = mappedBy.asString();
            this.inverseField = (EntityField)relationModel.fields.get(inverseField);
            this.relationOwner = false;
        } else if (field.hasAnnotation(DOTNAME_MANYTOMANY)) {
            this.type = Type.MultiMultiRelation;
            this.relationClass = ((org.jboss.jandex.Type)field.type().asParameterizedType().arguments().get(0)).name().toString();
            EntityModel relationModel = metamodelInfo.getEntityModel(this.relationClass);
            AnnotationValue mappedBy = field.annotation(DOTNAME_MANYTOMANY).value("mappedBy");
            if (mappedBy != null) {
                String inverseField = mappedBy.asString();
                this.inverseField = (EntityField)relationModel.fields.get(inverseField);
                this.relationOwner = false;
            } else {
                ClassInfo relationClassInfo = index.getClassByName(DotName.createSimple((String)this.relationClass));
                for (FieldInfo relationField : relationClassInfo.fields()) {
                    AnnotationValue value;
                    AnnotationInstance manyToMany = relationField.annotation(DOTNAME_MANYTOMANY);
                    if (manyToMany == null || (value = manyToMany.value("mappedBy")) == null || !value.asString().equals(field.name())) continue;
                    this.inverseField = (EntityField)relationModel.fields.get(relationField.name());
                    break;
                }
                if (this.inverseField == null) {
                    throw new RuntimeException("Failed to find owning side of @ManyToMany from " + field + " in relation type " + this.relationClass);
                }
                this.relationOwner = true;
            }
        } else if (oneToOne != null && oneToOne.value("mappedBy") != null) {
            this.type = Type.Ignore;
            this.relationOwner = false;
        } else if (field.hasAnnotation(DOTNAME_MANYTOONE) || oneToOne != null && oneToOne.value("mappedBy") == null) {
            this.type = Type.Relation;
            this.relationClass = entityField.descriptor.substring(1, entityField.descriptor.length() - 1).replace('/', '.');
            this.relationOwner = true;
        } else {
            ClassInfo fieldClassInfo = index.getClassByName(field.type().name());
            if (fieldClassInfo != null && fieldClassInfo.isEnum()) {
                this.type = Type.Enum;
            }
        }
        if (column != null && column.value("nullable") != null && !column.value("nullable").asBoolean()) {
            this.validation.add(NotEmpty.class);
            this.help = "This field is required";
        }
        this.entityField = entityField;
    }

    public String getClassName() {
        return this.entityField.descriptor.substring(1, this.entityField.descriptor.length() - 1).replace('/', '.');
    }

    public String toString() {
        return "ModelField " + this.name + " of type " + this.entityField.descriptor;
    }

    public static List<ModelField> loadModelFields(EntityModel entityModel, MetamodelInfo metamodelInfo, IndexView index) {
        ArrayList<ModelField> fields = new ArrayList<ModelField>();
        ModelField.addFields(fields, entityModel, metamodelInfo, index);
        return fields;
    }

    private static void addFields(List<ModelField> fields, EntityModel entityModel, MetamodelInfo metamodelInfo, IndexView index) {
        EntityModel superModel;
        for (Map.Entry entry : entityModel.fields.entrySet()) {
            ModelField mf = new ModelField((EntityField)entry.getValue(), entityModel.name, metamodelInfo, index);
            if (mf.type == Type.Ignore) continue;
            fields.add(mf);
        }
        if (entityModel.superClassName != null && (superModel = metamodelInfo.getEntityModel(entityModel.superClassName)) != null) {
            ModelField.addFields(fields, superModel, metamodelInfo, index);
        }
    }

    public static enum Type {
        LargeText,
        Text,
        Number,
        Checkbox,
        DateTimeLocal,
        Date,
        Time,
        Timestamp,
        Enum,
        Relation,
        MultiRelation,
        Ignore,
        MultiMultiRelation,
        Binary,
        JSON;

    }
}

