/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.renarde.oidc.test;

import io.quarkiverse.renarde.oidc.test.MockAppleOidc;
import io.quarkiverse.renarde.oidc.test.MockOidcTestResource;
import io.smallrye.jwt.build.Jwt;
import io.vertx.mutiny.ext.web.Router;
import io.vertx.mutiny.ext.web.RoutingContext;
import io.vertx.mutiny.ext.web.handler.BodyHandler;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.RSAPublicKey;
import java.time.Duration;
import java.time.Instant;
import java.util.Base64;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import org.eclipse.microprofile.jwt.Claims;

public class MockAppleOidcTestResource
extends MockOidcTestResource<MockAppleOidc> {
    private KeyPair kp;

    public MockAppleOidcTestResource() {
        super("apple");
    }

    @Override
    protected void registerRoutes(Router router) {
        KeyPairGenerator ecKpg;
        KeyPairGenerator kpg;
        BodyHandler bodyHandler = BodyHandler.create();
        router.get("/.well-known/openid-configuration").handler(this::configuration);
        router.get("/auth/authorize").handler(this::authorize);
        router.post("/auth/token").handler((Consumer)bodyHandler).handler(this::accessTokenJson);
        router.get("/auth/keys").handler(this::getKeys);
        try {
            kpg = KeyPairGenerator.getInstance("RSA");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        kpg.initialize(2048);
        this.kp = kpg.generateKeyPair();
        File privateKey = new File("target/classes/test.oidc-apple-key.pem");
        if (privateKey.exists()) {
            privateKey.delete();
        }
        try {
            ecKpg = KeyPairGenerator.getInstance("EC");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        ecKpg.initialize(256);
        KeyPair kp = ecKpg.generateKeyPair();
        try (FileWriter fw = new FileWriter(privateKey);){
            fw.append("-----BEGIN PRIVATE KEY-----\n");
            fw.append(Base64.getMimeEncoder().encodeToString(kp.getPrivate().getEncoded()));
            fw.append("\n");
            fw.append("-----END PRIVATE KEY-----\n");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Map<String, String> start() {
        Map<String, String> ret = super.start();
        ret.put("quarkus.oidc.apple.credentials.jwt.key-file", "test.oidc-apple-key.pem");
        return ret;
    }

    private void configuration(RoutingContext rc) {
        String data = "{\n \"issuer\": \"https://appleid.apple.com\",\n \"authorization_endpoint\": \"" + this.baseURI + "/auth/authorize\",\n \"token_endpoint\": \"" + this.baseURI + "/auth/token\",\n \"jwks_uri\": \"" + this.baseURI + "/auth/keys\",\n \"response_types_supported\": [\n  \"code\"\n ],\n \"response_modes_supported\": [\n  \"query\",\n  \"fragment\",\n  \"form_post\"\n ],\n  \"subject_types_supported\": [\n  \"pairwise\"\n ],\n \"id_token_signing_alg_values_supported\": [\n  \"RS256\"\n ],\n \"scopes_supported\": [\n  \"openid\",\n  \"email\",\n  \"name\"\n ],\n \"token_endpoint_auth_methods_supported\": [\n  \"client_secret_post\"\n ],\n \"claims_supported\": [\n  \"aud\",\n  \"email\",\n  \"email_verified\",\n  \"exp\",\n  \"iat\",\n  \"iss\",\n  \"sub\"\n ]\n}";
        rc.response().putHeader("Content-Type", "application/json");
        rc.endAndForget(data);
    }

    private void authorize(RoutingContext rc) {
        String response_type = rc.request().params().get("response_type");
        String client_id = rc.request().params().get("client_id");
        String scope = rc.request().params().get("scope");
        String state = rc.request().params().get("state");
        String redirect_uri = rc.request().params().get("redirect_uri");
        if (!redirect_uri.startsWith("https://")) {
            rc.response().setStatusCode(400).sendAndForget("HTTPS is required");
            return;
        }
        UUID code = UUID.randomUUID();
        rc.response().putHeader("Content-Type", "application/json").endAndForget("{\n  \"code\":\"" + code + "\",\n  \"state\":\"" + state + "\"\n}");
    }

    private void accessTokenJson(RoutingContext rc) {
        String authorization_code = rc.request().formAttributes().get("authorization_code");
        String code = rc.request().formAttributes().get("code");
        String redirect_uri = rc.request().formAttributes().get("redirect_uri");
        UUID token = UUID.randomUUID();
        UUID token2 = UUID.randomUUID();
        String hashedToken = this.hashAccessToken(token.toString());
        String idToken = Jwt.issuer((String)"https://appleid.apple.com").audience("APLCLIENT").expiresIn(Duration.ofDays(1L)).issuedAt(Instant.now()).subject("USERID").claim(Claims.at_hash, (Object)hashedToken).claim(Claims.email, (Object)"apple@example.com").claim(Claims.email_verified, (Object)true).claim(Claims.auth_time, (Object)Instant.now()).claim("nonce_supported", (Object)true).jws().keyId("KEYID").sign(this.kp.getPrivate());
        String data = "{\n \"token_type\":\"Bearer\",\n \"expires_in\":3600,\n \"access_token\":\"" + token + "\",\n \"refresh_token\":\"" + token2 + "\",\n \"id_token\":\"" + idToken + "\"\n }  ";
        rc.response().putHeader("Content-Type", "application/json").endAndForget(data);
    }

    private void getKeys(RoutingContext rc) {
        RSAPublicKey pub = (RSAPublicKey)this.kp.getPublic();
        String modulus = Base64.getUrlEncoder().encodeToString(pub.getModulus().toByteArray());
        String exponent = Base64.getUrlEncoder().encodeToString(pub.getPublicExponent().toByteArray());
        String data = "{\n  \"keys\": [\n    {\n      \"kty\": \"RSA\",\n      \"kid\": \"KEYID\",\n      \"use\": \"sig\",\n      \"alg\": \"RS256\",\n      \"n\": \"" + modulus + "\",\n      \"e\": \"" + exponent + "\"\n    },\n  ]\n}";
        rc.response().putHeader("Content-Type", "application/json").endAndForget(data);
    }
}

