/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.renarde.oidc.test;

import io.quarkiverse.renarde.oidc.test.MockFacebookOidc;
import io.quarkiverse.renarde.oidc.test.MockOidcTestResource;
import io.smallrye.jwt.build.Jwt;
import io.vertx.mutiny.ext.web.Router;
import io.vertx.mutiny.ext.web.RoutingContext;
import io.vertx.mutiny.ext.web.handler.BodyHandler;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.RSAPublicKey;
import java.time.Duration;
import java.time.Instant;
import java.util.Base64;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import org.eclipse.microprofile.jwt.Claims;

public class MockFacebookOidcTestResource
extends MockOidcTestResource<MockFacebookOidc> {
    private KeyPair kp;

    public MockFacebookOidcTestResource() {
        super("facebook");
    }

    @Override
    protected void registerRoutes(Router router) {
        KeyPairGenerator kpg;
        BodyHandler bodyHandler = BodyHandler.create();
        router.get("/.well-known/openid-configuration").handler(this::configuration);
        router.get("/dialog/oauth/").handler(this::authorize);
        router.post("/v12.0/oauth/access_token").handler((Consumer)bodyHandler).handler(this::accessTokenJson);
        router.get("/.well-known/oauth/openid/jwks/").handler(this::getKeys);
        try {
            kpg = KeyPairGenerator.getInstance("RSA");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        kpg.initialize(2048);
        this.kp = kpg.generateKeyPair();
    }

    @Override
    public Map<String, String> start() {
        Map<String, String> ret = super.start();
        ret.put("quarkus.oidc.facebook.token-path", this.baseURI + "/v12.0/oauth/access_token");
        ret.put("quarkus.oidc.facebook.authorization-path", this.baseURI + "/dialog/oauth/");
        ret.put("quarkus.oidc.facebook.jwks-path", this.baseURI + "/.well-known/oauth/openid/jwks/");
        return ret;
    }

    private void configuration(RoutingContext rc) {
        String data = "{\n   \"issuer\": \"https://www.facebook.com\",\n   \"authorization_endpoint\": \"" + this.baseURI + "/dialog/oauth/\",\n   \"jwks_uri\": \"" + this.baseURI + "/.well-known/oauth/openid/jwks/\",\n   \"response_types_supported\": [\n      \"id_token\",\n      \"token id_token\"\n   ],\n   \"subject_types_supported\": [\n      \"pairwise\"\n   ],\n   \"id_token_signing_alg_values_supported\": [\n      \"RS256\"\n   ],\n   \"claims_supported\": [\n      \"iss\",\n      \"aud\",\n      \"sub\",\n      \"iat\",\n      \"exp\",\n      \"jti\",\n      \"nonce\",\n      \"at_hash\",\n      \"name\",\n      \"given_name\",\n      \"middle_name\",\n      \"family_name\",\n      \"email\",\n      \"picture\",\n      \"user_friends\",\n      \"user_birthday\",\n      \"user_age_range\",\n      \"user_link\",\n      \"user_hometown\",\n      \"user_location\",\n      \"user_gender\"\n   ]\n}";
        rc.response().putHeader("Content-Type", "application/json");
        rc.endAndForget(data);
    }

    private void authorize(RoutingContext rc) {
        URI redirect;
        String response_type = rc.request().params().get("response_type");
        String client_id = rc.request().params().get("client_id");
        String scope = rc.request().params().get("scope");
        String state = rc.request().params().get("state");
        String redirect_uri = rc.request().params().get("redirect_uri");
        if (!redirect_uri.startsWith("https://")) {
            rc.response().setStatusCode(400).sendAndForget("HTTPS is required");
            return;
        }
        UUID code = UUID.randomUUID();
        try {
            redirect = new URI(redirect_uri + "?state=" + state + "&code=" + code);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        rc.response().putHeader("Location", redirect.toASCIIString()).setStatusCode(302).endAndForget();
    }

    private void accessTokenJson(RoutingContext rc) {
        String authorization_code = rc.request().formAttributes().get("authorization_code");
        String code = rc.request().formAttributes().get("code");
        String redirect_uri = rc.request().formAttributes().get("redirect_uri");
        UUID token = UUID.randomUUID();
        String hashedToken = this.hashAccessToken(token.toString());
        String idToken = Jwt.issuer((String)"https://www.facebook.com").audience("FBCLIENT").subject("USERID").issuedAt(Instant.now()).expiresIn(Duration.ofDays(1L)).claim(Claims.jti, (Object)UUID.randomUUID().toString()).claim(Claims.nonce, (Object)"").claim(Claims.at_hash, (Object)hashedToken).claim(Claims.email, (Object)"facebook@example.com").claim(Claims.given_name, (Object)"Foo").claim(Claims.family_name, (Object)"Bar").claim("name", (Object)"Foo Bar").claim("picture", (Object)"https://platform-lookaside.fbsbx.com/platform/profilepic/XXX").jws().keyId("KEYID").sign(this.kp.getPrivate());
        String data = "{\n \"access_token\":\"" + token + "\",\n \"id_token\":\"" + idToken + "\",\n \"token_type\":\"bearer\",\n \"expires_in\":5172337\n} ";
        rc.response().putHeader("Content-Type", "application/json").endAndForget(data);
    }

    private void getKeys(RoutingContext rc) {
        RSAPublicKey pub = (RSAPublicKey)this.kp.getPublic();
        String modulus = Base64.getUrlEncoder().encodeToString(pub.getModulus().toByteArray());
        String exponent = Base64.getUrlEncoder().encodeToString(pub.getPublicExponent().toByteArray());
        String data = "{\n  \"keys\": [\n    {\n      \"alg\": \"RS256\",\n      \"kty\": \"RSA\",\n      \"n\": \"" + modulus + "\",\n      \"use\": \"sig\",\n      \"kid\": \"KEYID\",\n      \"e\": \"" + exponent + "\"\n    },\n  ]\n}";
        rc.response().putHeader("Content-Type", "application/json").endAndForget(data);
    }
}

