/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.renarde.oidc.test;

import io.quarkus.test.common.QuarkusTestResourceConfigurableLifecycleManager;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.mutiny.core.Vertx;
import io.vertx.mutiny.core.http.HttpServer;
import io.vertx.mutiny.ext.web.Router;
import java.lang.annotation.Annotation;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;

public abstract class MockOidcTestResource<ConfigAnnotation extends Annotation>
implements QuarkusTestResourceConfigurableLifecycleManager<ConfigAnnotation> {
    private HttpServer httpServer;
    protected String baseURI;
    private String name;

    MockOidcTestResource(String name) {
        this.name = name;
    }

    public Map<String, String> start() {
        Vertx vertx = Vertx.vertx();
        HttpServerOptions options = new HttpServerOptions();
        options.setPort(0);
        this.httpServer = vertx.createHttpServer(options);
        Router router = Router.router((Vertx)vertx);
        this.httpServer.requestHandler((Consumer)router);
        this.registerRoutes(router);
        this.httpServer.listenAndAwait();
        int port = this.httpServer.actualPort();
        HashMap<String, String> ret = new HashMap<String, String>();
        this.baseURI = "http://localhost:" + port;
        ret.put("quarkus.oidc." + this.name + ".auth-server-url", this.baseURI);
        System.err.println("Started OIDC Mock for " + this.name + " on " + this.baseURI);
        return ret;
    }

    protected abstract void registerRoutes(Router var1);

    public void stop() {
        System.err.println("Closing OIDC Mock: " + this.name);
        this.httpServer.closeAndAwait();
    }

    protected String hashAccessToken(String string) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            byte[] digest = md.digest(string.getBytes(StandardCharsets.UTF_8));
            byte[] part = new byte[8];
            System.arraycopy(digest, 0, part, 0, 8);
            return Base64.getUrlEncoder().encodeToString(part);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }
}

