/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.renarde.oidc.test;

import io.quarkiverse.renarde.oidc.test.MockMicrosoftOidc;
import io.quarkiverse.renarde.oidc.test.MockOidcTestResource;
import io.smallrye.jwt.build.Jwt;
import io.vertx.mutiny.ext.web.Router;
import io.vertx.mutiny.ext.web.RoutingContext;
import io.vertx.mutiny.ext.web.handler.BodyHandler;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.RSAPublicKey;
import java.time.Duration;
import java.time.Instant;
import java.util.Base64;
import java.util.UUID;
import java.util.function.Consumer;
import org.eclipse.microprofile.jwt.Claims;

public class MockMicrosoftOidcTestResource
extends MockOidcTestResource<MockMicrosoftOidc> {
    private KeyPair kp;
    private String clientId;

    public MockMicrosoftOidcTestResource() {
        super("microsoft");
    }

    @Override
    protected void registerRoutes(Router router) {
        KeyPairGenerator kpg;
        BodyHandler bodyHandler = BodyHandler.create();
        router.get("/.well-known/openid-configuration").handler(this::configuration);
        router.get("/common/oauth2/v2.0/authorize").handler(this::authorize);
        router.post("/common/oauth2/v2.0/token").handler((Consumer)bodyHandler).handler(this::accessTokenJson);
        router.get("/common/discovery/v2.0/keys").handler(this::getKeys);
        try {
            kpg = KeyPairGenerator.getInstance("RSA");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        kpg.initialize(2048);
        this.kp = kpg.generateKeyPair();
    }

    private void configuration(RoutingContext rc) {
        String data = "{\n   \"token_endpoint\":\"" + this.baseURI + "/common/oauth2/v2.0/token\",\n   \"token_endpoint_auth_methods_supported\":[\n      \"client_secret_post\",\n      \"private_key_jwt\",\n      \"client_secret_basic\"\n   ],\n   \"jwks_uri\":\"" + this.baseURI + "/common/discovery/v2.0/keys\",\n   \"response_modes_supported\":[\n      \"query\",\n      \"fragment\",\n      \"form_post\"\n   ],\n   \"subject_types_supported\":[\n      \"pairwise\"\n   ],\n   \"id_token_signing_alg_values_supported\":[\n      \"RS256\"\n   ],\n   \"response_types_supported\":[\n      \"code\",\n      \"id_token\",\n      \"code id_token\",\n      \"id_token token\"\n   ],\n   \"scopes_supported\":[\n      \"openid\",\n      \"profile\",\n      \"email\",\n      \"offline_access\"\n   ],\n   \"issuer\":\"" + this.baseURI + "/{tenantid}/v2.0\",\n   \"request_uri_parameter_supported\":false,\n   \"userinfo_endpoint\":\"" + this.baseURI + "/oidc/userinfo\",\n   \"authorization_endpoint\":\"" + this.baseURI + "/common/oauth2/v2.0/authorize\",\n   \"device_authorization_endpoint\":\"" + this.baseURI + "/common/oauth2/v2.0/devicecode\",\n   \"http_logout_supported\":true,\n   \"frontchannel_logout_supported\":true,\n   \"end_session_endpoint\":\"" + this.baseURI + "/common/oauth2/v2.0/logout\",\n   \"claims_supported\":[\n      \"sub\",\n      \"iss\",\n      \"cloud_instance_name\",\n      \"cloud_instance_host_name\",\n      \"cloud_graph_host_name\",\n      \"msgraph_host\",\n      \"aud\",\n      \"exp\",\n      \"iat\",\n      \"auth_time\",\n      \"acr\",\n      \"nonce\",\n      \"preferred_username\",\n      \"name\",\n      \"tid\",\n      \"ver\",\n      \"at_hash\",\n      \"c_hash\",\n      \"email\"\n   ],\n   \"kerberos_endpoint\":\"" + this.baseURI + "/common/kerberos\",\n   \"tenant_region_scope\":null,\n   \"cloud_instance_name\":\"microsoftonline.com\",\n   \"cloud_graph_host_name\":\"graph.windows.net\",\n   \"msgraph_host\":\"graph.microsoft.com\",\n   \"rbac_url\":\"https://pas.windows.net\"\n}";
        rc.response().putHeader("Content-Type", "application/json");
        rc.endAndForget(data);
    }

    private void authorize(RoutingContext rc) {
        URI redirect;
        String response_type = rc.request().params().get("response_type");
        this.clientId = rc.request().params().get("client_id");
        String scope = rc.request().params().get("scope");
        String state = rc.request().params().get("state");
        String redirect_uri = rc.request().params().get("redirect_uri");
        UUID code = UUID.randomUUID();
        try {
            redirect = new URI(redirect_uri + "?state=" + state + "&code=" + code);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        rc.response().putHeader("Location", redirect.toASCIIString()).setStatusCode(302).endAndForget();
    }

    private void accessTokenJson(RoutingContext rc) {
        String authorization_code = rc.request().formAttributes().get("authorization_code");
        String code = rc.request().formAttributes().get("code");
        String redirect_uri = rc.request().formAttributes().get("redirect_uri");
        UUID token = UUID.randomUUID();
        UUID tenant = UUID.randomUUID();
        String hashedToken = this.hashAccessToken(token.toString());
        String idToken = Jwt.issuer((String)"https://accounts.google.com").claim("ver", (Object)"2.0").issuer(this.baseURI + "/" + tenant + "/v2.0").subject("USERID").audience(this.clientId).expiresIn(Duration.ofDays(1L)).issuedAt(Instant.now()).claim(Claims.nbf, (Object)Instant.now()).claim("name", (Object)"Foo Bar").claim(Claims.preferred_username, (Object)"microsoft@example.com").claim("oid", (Object)UUID.randomUUID().toString()).claim(Claims.email, (Object)"microsoft@example.com").claim("tid", (Object)tenant.toString()).claim("aio", (Object)UUID.randomUUID().toString()).jws().keyId("KEYID").sign(this.kp.getPrivate());
        String data = "{\n \"token_type\":\"Bearer\",\n \"scope\":\"openid email profile\",\n \"expires_in\":3600,\n \"ext_expires_in\":3600,\n \"access_token\":\"" + token + "\",\n \"id_token\":\"" + idToken + "\"\n }  ";
        rc.response().putHeader("Content-Type", "application/json").endAndForget(data);
    }

    private void getKeys(RoutingContext rc) {
        RSAPublicKey pub = (RSAPublicKey)this.kp.getPublic();
        String modulus = Base64.getUrlEncoder().encodeToString(pub.getModulus().toByteArray());
        String exponent = Base64.getUrlEncoder().encodeToString(pub.getPublicExponent().toByteArray());
        String data = "{\n  \"keys\": [\n    {\n      \"alg\": \"RS256\",\n      \"kty\": \"RSA\",\n      \"n\": \"" + modulus + "\",\n      \"use\": \"sig\",\n      \"kid\": \"KEYID\",\n      \"k5t\": \"KEYID\",\n      \"issuer\": \"" + this.baseURI + "/{tenantid}/v2.0\",\n      \"e\": \"" + exponent + "\"\n    },\n  ]\n}";
        rc.response().putHeader("Content-Type", "application/json").endAndForget(data);
    }
}

