/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.renarde.oidc;

import io.quarkiverse.renarde.oidc.RenardeUser;
import io.quarkiverse.renarde.oidc.RenardeUserProvider;
import io.quarkiverse.renarde.oidc.impl.RenardeGithubClient;
import io.quarkiverse.renarde.util.Flash;
import io.quarkiverse.renarde.util.RedirectException;
import io.quarkus.oidc.AccessTokenCredential;
import io.quarkus.oidc.IdToken;
import io.quarkus.oidc.OidcSession;
import io.quarkus.oidc.UserInfo;
import io.quarkus.oidc.runtime.OidcConfig;
import io.quarkus.security.identity.SecurityIdentity;
import io.smallrye.jwt.auth.principal.JWTCallerPrincipal;
import io.smallrye.jwt.build.Jwt;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.eclipse.microprofile.jwt.Claims;
import org.eclipse.microprofile.jwt.JsonWebToken;
import org.eclipse.microprofile.rest.client.inject.RestClient;

@ApplicationScoped
public class RenardeSecurity {
    @ConfigProperty(name="mp.jwt.verify.issuer")
    String jwtIssuer;
    @ConfigProperty(name="mp.jwt.token.cookie")
    String jwtCookie;
    @Inject
    SecurityIdentity identity;
    @Inject
    OidcSession oidcSession;
    @Inject
    RenardeUserProvider userProvider;
    @Inject
    OidcConfig oidcConfig;
    @Inject
    Flash flash;
    @RestClient
    RenardeGithubClient client;
    @Inject
    AccessTokenCredential accessToken;
    @Inject
    @IdToken
    JsonWebToken idToken;
    @Inject
    UserInfo userInfo;

    public NewCookie makeUserCookie(RenardeUser user) {
        Set<String> roles = user.getRoles();
        String token = Jwt.issuer((String)this.jwtIssuer).upn(user.getUserId()).groups(roles).expiresIn(Duration.ofDays(10L)).innerSign().encrypt();
        return new NewCookie(this.jwtCookie, token, "/", null, 1, null, -1, null, false, false);
    }

    public RenardeUser getUser() {
        if (!this.identity.isAnonymous()) {
            RenardeUser user;
            JWTCallerPrincipal principal = (JWTCallerPrincipal)this.identity.getPrincipal();
            String tenantId = this.oidcSession.getTenantId();
            if (tenantId == null) {
                tenantId = "manual";
            }
            if ((user = this.userProvider.findUser(tenantId, principal.getName())) == null) {
                this.flash.flash("message", (Object)("Invalid user: " + principal.getName()));
                throw new RedirectException(this.makeLogoutResponse());
            }
            if (!user.isRegistered()) {
                return null;
            }
            return user;
        }
        return null;
    }

    public Response makeLogoutResponse() {
        ArrayList<NewCookie> cookies = new ArrayList<NewCookie>(this.oidcConfig.namedTenants.size() + 1);
        cookies.add(new NewCookie("q_session", null, "/", null, null, 0, false, true));
        for (String tenant : this.oidcConfig.namedTenants.keySet()) {
            cookies.add(new NewCookie("q_session_" + tenant, null, "/", null, null, 0, false, true));
        }
        cookies.add(new NewCookie(this.jwtCookie, null, "/", null, null, 0, false, true));
        try {
            return Response.seeOther((URI)new URI("/")).cookie(cookies.toArray(new NewCookie[0])).build();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public String getOidcEmail() {
        String tenantId;
        switch (tenantId = this.oidcSession.getTenantId()) {
            case "github": {
                List<RenardeGithubClient.Email> emails = this.client.getEmails("Bearer " + this.accessToken.getToken());
                for (RenardeGithubClient.Email emailStruct : emails) {
                    if (!emailStruct.primary) continue;
                    return emailStruct.email;
                }
                return null;
            }
            case "twitter": {
                return null;
            }
        }
        return (String)this.idToken.getClaim(Claims.email);
    }

    public String getOidcFirstName() {
        String tenantId;
        switch (tenantId = this.oidcSession.getTenantId()) {
            case "github": {
                return this.firstPart(this.userInfo.getString("name"));
            }
            case "twitter": {
                return this.firstPart(this.userInfo.getObject("data").getString("name"));
            }
            case "microsoft": {
                return this.firstPart((String)this.idToken.getClaim("name"));
            }
        }
        return (String)this.idToken.getClaim(Claims.given_name);
    }

    private String firstPart(String name) {
        if (name == null) {
            return null;
        }
        int firstSpace = name.indexOf(32);
        if (firstSpace != -1) {
            return name.substring(0, firstSpace);
        }
        return name;
    }

    private String secondPart(String name) {
        if (name == null) {
            return null;
        }
        int firstSpace = name.indexOf(32);
        if (firstSpace != -1) {
            return name.substring(firstSpace + 1);
        }
        return null;
    }

    public String getOidcLastName() {
        String tenantId;
        switch (tenantId = this.oidcSession.getTenantId()) {
            case "github": {
                return this.secondPart(this.userInfo.getString("name"));
            }
            case "twitter": {
                return this.secondPart(this.userInfo.getObject("data").getString("name"));
            }
            case "microsoft": {
                return this.secondPart((String)this.idToken.getClaim("name"));
            }
        }
        return (String)this.idToken.getClaim(Claims.family_name);
    }

    public String getOidcUserName() {
        String tenantId;
        switch (tenantId = this.oidcSession.getTenantId()) {
            case "github": {
                return this.userInfo.getString("login");
            }
            case "twitter": {
                return this.firstPart(this.userInfo.getObject("data").getString("username"));
            }
            case "facebook": {
                return null;
            }
        }
        return (String)this.idToken.getClaim(Claims.preferred_username);
    }
}

