/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.renarde.oidc.impl;

import io.quarkiverse.renarde.Controller;
import io.quarkiverse.renarde.oidc.RenardeOidcHandler;
import io.quarkiverse.renarde.oidc.RenardeSecurity;
import io.quarkus.oidc.IdToken;
import io.quarkus.oidc.OidcSession;
import io.quarkus.oidc.UserInfo;
import io.quarkus.security.Authenticated;
import io.smallrye.jwt.auth.principal.JWTCallerPrincipal;
import javax.inject.Inject;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;
import org.eclipse.microprofile.jwt.JsonWebToken;
import org.jboss.resteasy.reactive.RestPath;

@Path(value="_renarde/security")
public class RenardeSecurityController
extends Controller {
    @Inject
    RenardeSecurity security;
    @Inject
    RenardeOidcHandler oidcHandler;
    @Inject
    @IdToken
    JsonWebToken idToken;
    @Inject
    UserInfo userInfo;
    @Inject
    OidcSession oidcSession;

    @Path(value="login-{provider}")
    @Authenticated
    public void loginUsingOidc(@RestPath String provider) {
        JWTCallerPrincipal principal = (JWTCallerPrincipal)this.identity.getPrincipal();
        String tenantId = this.oidcSession.getTenantId();
        if (tenantId == null) {
            tenantId = "manual";
        }
        this.oidcHandler.loginWithOidcSession(tenantId, principal.getName());
    }

    @Path(value="logout")
    public Response logout() {
        return this.security.makeLogoutResponse();
    }

    @Authenticated
    @Path(value="github-success")
    public void githubSuccess() {
        String authId = this.userInfo.getLong("id").toString();
        this.oidcHandler.oidcSuccess(this.oidcSession.getTenantId(), authId);
    }

    @Authenticated
    @Path(value="twitter-success")
    public void twitterSuccess() {
        String authId = this.userInfo.getObject("data").getString("id");
        this.oidcHandler.oidcSuccess(this.oidcSession.getTenantId(), authId);
    }

    @Authenticated
    @Path(value="oidc-success")
    public void oidcSuccessGet() {
        this.oidcLoginSuccess();
    }

    @Authenticated
    @Path(value="oidc-success")
    @POST
    public void oidcSuccessPost() {
        this.oidcLoginSuccess();
    }

    private void oidcLoginSuccess() {
        String authId = this.idToken.getName();
        this.oidcHandler.oidcSuccess(this.oidcSession.getTenantId(), authId);
    }
}

