/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.renarde.oidc.impl;

import io.quarkus.oidc.UserInfo;
import io.quarkus.security.identity.AuthenticationRequestContext;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.identity.SecurityIdentityAugmentor;
import io.quarkus.security.runtime.QuarkusSecurityIdentity;
import io.smallrye.jwt.auth.principal.DefaultJWTCallerPrincipal;
import io.smallrye.mutiny.Uni;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.json.JsonNumber;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import java.security.Principal;
import org.eclipse.microprofile.jwt.Claims;
import org.jose4j.jwt.JwtClaims;

@ApplicationScoped
public class RenardeSecurityIdentityAugmentor
implements SecurityIdentityAugmentor {
    public Uni<SecurityIdentity> augment(SecurityIdentity identity, AuthenticationRequestContext context) {
        if (identity.isAnonymous()) {
            return Uni.createFrom().item((Object)identity);
        }
        DefaultJWTCallerPrincipal oldPrincipal = (DefaultJWTCallerPrincipal)identity.getPrincipal();
        String tenantId = (String)identity.getAttribute("tenant-id");
        if ("github".equals(tenantId) || "twitter".equals(tenantId) || "spotify".equals(tenantId)) {
            String rawToken = (String)oldPrincipal.getClaim(Claims.raw_token);
            JwtClaims claims = new JwtClaims();
            for (String claim : oldPrincipal.getClaimNames()) {
                claims.setClaim(claim, oldPrincipal.getClaim(claim));
            }
            UserInfo userInfo = (UserInfo)identity.getAttribute("userinfo");
            JsonValue id = "github".equals(tenantId) || "spotify".equals(tenantId) ? (JsonValue)userInfo.get("id") : (JsonValue)userInfo.getObject("data").get((Object)"id");
            claims.setClaim(Claims.upn.name(), (Object)(switch (id.getValueType()) {
                case JsonValue.ValueType.NUMBER -> Long.toString(((JsonNumber)id).longValue());
                case JsonValue.ValueType.STRING -> ((JsonString)id).getString();
                default -> throw new RuntimeException("Don't know how to handle userinfo id: " + id);
            }));
            QuarkusSecurityIdentity newIdentity = QuarkusSecurityIdentity.builder((SecurityIdentity)identity).setPrincipal((Principal)new DefaultJWTCallerPrincipal(rawToken, "JWT", claims)).build();
            return Uni.createFrom().item((Object)newIdentity);
        }
        return Uni.createFrom().item((Object)identity);
    }
}

