/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.renarde.oidc.impl;

import io.quarkus.oidc.OidcTenantConfig;
import io.quarkus.oidc.TenantResolver;
import io.quarkus.oidc.runtime.OidcConfig;
import io.vertx.core.http.Cookie;
import io.vertx.ext.web.RoutingContext;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.util.Map;
import org.eclipse.microprofile.config.inject.ConfigProperty;

@ApplicationScoped
public class RenardeTenantResolver
implements TenantResolver {
    @Inject
    OidcConfig oidcConfig;
    @ConfigProperty(name="mp.jwt.token.cookie")
    String jwtCookie;

    public String resolve(RoutingContext context) {
        String knownTenant = (String)context.get("tenant-id");
        if (knownTenant != null) {
            return knownTenant;
        }
        for (Map.Entry tenantEntry : this.oidcConfig.namedTenants.entrySet()) {
            if (!((OidcTenantConfig)tenantEntry.getValue()).tenantEnabled) continue;
            String tenant = (String)tenantEntry.getKey();
            if (!context.request().path().equals("/_renarde/security/login-" + tenant)) continue;
            return tenant;
        }
        Cookie cookie = context.request().getCookie(this.jwtCookie);
        if (cookie != null) {
            return "manual";
        }
        return null;
    }
}

