/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.renarde.oidc.impl;

import io.quarkiverse.renarde.Controller;
import io.quarkiverse.renarde.oidc.RenardeOidcHandler;
import io.quarkiverse.renarde.oidc.RenardeOidcSecurity;
import io.quarkiverse.renarde.security.RenardeSecurity;
import io.quarkus.oidc.IdToken;
import io.quarkus.oidc.OidcSession;
import io.quarkus.oidc.UserInfo;
import io.quarkus.security.Authenticated;
import io.smallrye.jwt.auth.principal.JWTCallerPrincipal;
import jakarta.inject.Inject;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import java.security.Principal;
import org.eclipse.microprofile.jwt.JsonWebToken;
import org.jboss.resteasy.reactive.RestPath;

@Path(value="_renarde/security")
public class RenardeOidcController
extends Controller {
    @Inject
    RenardeOidcSecurity security;
    @Inject
    RenardeOidcHandler oidcHandler;
    @Inject
    @IdToken
    JsonWebToken idToken;
    @Inject
    UserInfo userInfo;
    @Inject
    OidcSession oidcSession;

    @Path(value="login-{provider}")
    @Authenticated
    public void loginUsingOidc(@RestPath String provider) {
        JWTCallerPrincipal principal = (JWTCallerPrincipal)this.identity.getPrincipal();
        String tenantId = this.oidcSession.getTenantId();
        if (tenantId == null) {
            tenantId = "manual";
        }
        this.oidcHandler.loginWithOidcSession(tenantId, RenardeSecurity.getUserId((Principal)principal));
    }

    @Authenticated
    @Path(value="github-success")
    public void githubSuccess() {
        this.oidcLoginSuccess();
    }

    @Authenticated
    @Path(value="twitter-success")
    public void twitterSuccess() {
        this.oidcLoginSuccess();
    }

    @Authenticated
    @Path(value="oidc-success")
    public void oidcSuccessGet() {
        this.oidcLoginSuccess();
    }

    @Authenticated
    @Path(value="oidc-success")
    @POST
    public void oidcSuccessPost() {
        this.oidcLoginSuccess();
    }

    private void oidcLoginSuccess() {
        String authId;
        String tenantId;
        switch (tenantId = this.oidcSession.getTenantId()) {
            case "github": {
                authId = this.userInfo.getLong("id").toString();
                break;
            }
            case "spotify": {
                authId = this.userInfo.getString("id");
                break;
            }
            case "twitter": {
                authId = this.userInfo.getObject("data").getString("id");
                break;
            }
            default: {
                authId = RenardeSecurity.getUserId((Principal)this.idToken);
            }
        }
        this.oidcHandler.oidcSuccess(tenantId, authId);
    }
}

