/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.renarde.oidc;

import io.quarkiverse.renarde.oidc.impl.RenardeGithubClient;
import io.quarkus.oidc.AccessTokenCredential;
import io.quarkus.oidc.IdToken;
import io.quarkus.oidc.OidcSession;
import io.quarkus.oidc.UserInfo;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.util.List;
import org.eclipse.microprofile.jwt.Claims;
import org.eclipse.microprofile.jwt.JsonWebToken;
import org.eclipse.microprofile.rest.client.inject.RestClient;

@ApplicationScoped
public class RenardeOidcSecurity {
    @RestClient
    RenardeGithubClient client;
    @Inject
    AccessTokenCredential accessToken;
    @Inject
    @IdToken
    JsonWebToken idToken;
    @Inject
    OidcSession oidcSession;
    @Inject
    UserInfo userInfo;

    public String getOidcEmail() {
        String tenantId;
        switch (tenantId = this.oidcSession.getTenantId()) {
            case "github": {
                List<RenardeGithubClient.Email> emails = this.client.getEmails("Bearer " + this.accessToken.getToken());
                for (RenardeGithubClient.Email emailStruct : emails) {
                    if (!emailStruct.primary) continue;
                    return emailStruct.email;
                }
                return null;
            }
            case "twitter": {
                return null;
            }
            case "spotify": {
                return this.userInfo.getString("email");
            }
        }
        return (String)this.idToken.getClaim(Claims.email);
    }

    public String getOidcFirstName() {
        String tenantId;
        switch (tenantId = this.oidcSession.getTenantId()) {
            case "spotify": {
                return this.firstPart(this.userInfo.getString("display_name"));
            }
            case "github": {
                return this.firstPart(this.userInfo.getString("name"));
            }
            case "twitter": {
                return this.firstPart(this.userInfo.getObject("data").getString("name"));
            }
            case "microsoft": {
                return this.firstPart((String)this.idToken.getClaim("name"));
            }
        }
        return (String)this.idToken.getClaim(Claims.given_name);
    }

    private String firstPart(String name) {
        if (name == null) {
            return null;
        }
        int firstSpace = name.indexOf(32);
        if (firstSpace != -1) {
            return name.substring(0, firstSpace);
        }
        return name;
    }

    private String secondPart(String name) {
        if (name == null) {
            return null;
        }
        int firstSpace = name.indexOf(32);
        if (firstSpace != -1) {
            return name.substring(firstSpace + 1);
        }
        return null;
    }

    public String getOidcLastName() {
        String tenantId;
        switch (tenantId = this.oidcSession.getTenantId()) {
            case "spotify": {
                return this.secondPart(this.userInfo.getString("display_name"));
            }
            case "github": {
                return this.secondPart(this.userInfo.getString("name"));
            }
            case "twitter": {
                return this.secondPart(this.userInfo.getObject("data").getString("name"));
            }
            case "microsoft": {
                return this.secondPart((String)this.idToken.getClaim("name"));
            }
        }
        return (String)this.idToken.getClaim(Claims.family_name);
    }

    public String getOidcUserName() {
        String tenantId;
        switch (tenantId = this.oidcSession.getTenantId()) {
            case "github": {
                return this.userInfo.getString("login");
            }
            case "twitter": {
                return this.firstPart(this.userInfo.getObject("data").getString("username"));
            }
            case "spotify": 
            case "facebook": {
                return null;
            }
        }
        return (String)this.idToken.getClaim(Claims.preferred_username);
    }
}

