/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.renarde.pdf.runtime;

import com.openhtmltopdf.pdfboxout.PdfBoxRenderer;
import com.openhtmltopdf.pdfboxout.PdfRendererBuilder;
import com.openhtmltopdf.util.Diagnostic;
import com.openhtmltopdf.util.XRLog;
import com.openhtmltopdf.util.XRLogger;
import io.quarkiverse.renarde.pdf.Pdf;
import io.quarkus.runtime.ExecutorRecorder;
import io.smallrye.mutiny.Uni;
import jakarta.ws.rs.container.ContainerResponseContext;
import jakarta.ws.rs.core.UriInfo;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import org.jboss.logging.Logger;
import org.jboss.resteasy.reactive.server.ServerResponseFilter;
import org.jboss.resteasy.reactive.server.core.BlockingOperationSupport;

public class PdfResponseHandler {
    private static final Logger logger = Logger.getLogger(Pdf.class);

    @ServerResponseFilter
    public Uni<Void> filter(ContainerResponseContext responseContext, UriInfo uriInfo) throws IOException {
        Object entity = responseContext.getEntity();
        if (responseContext.getStatus() == 200 && entity instanceof String && responseContext.getMediaType() != null && responseContext.getMediaType().equals((Object)Pdf.APPLICATION_PDF_TYPE)) {
            String baseURI = uriInfo.getBaseUri().toString();
            if (BlockingOperationSupport.isBlockingAllowed()) {
                this.renderPdf((String)entity, baseURI, responseContext);
                return Uni.createFrom().nullItem();
            }
            return Uni.createFrom().item(() -> {
                this.renderPdf((String)entity, baseURI, responseContext);
                return null;
            }).runSubscriptionOn(ExecutorRecorder.getCurrent());
        }
        return Uni.createFrom().nullItem();
    }

    private void renderPdf(String entity, String baseURI, ContainerResponseContext responseContext) {
        PdfRendererBuilder builder = new PdfRendererBuilder();
        builder.withHtmlContent(entity, baseURI);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        builder.toStream((OutputStream)out);
        PdfBoxRenderer renderer = builder.buildPdfRenderer();
        try {
            renderer.createPDF();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        responseContext.setEntity((Object)out.toByteArray(), null, Pdf.APPLICATION_PDF_TYPE);
    }

    static {
        XRLog.setLoggerImpl((XRLogger)new XRLogger(){

            public void log(String where, Level level, String msg) {
                logger.log(this.translate(level), (Object)msg);
            }

            public void log(String where, Level level, String msg, Throwable th) {
                logger.log(this.translate(level), (Object)msg, th);
            }

            private Logger.Level translate(Level level) {
                if (level == Level.INFO) {
                    return Logger.Level.DEBUG;
                }
                if (level == Level.WARNING) {
                    return Logger.Level.WARN;
                }
                if (level == Level.SEVERE) {
                    return Logger.Level.ERROR;
                }
                if (level == Level.FINE || level == Level.FINER) {
                    return Logger.Level.TRACE;
                }
                if (level == Level.FINEST) {
                    return Logger.Level.DEBUG;
                }
                return Logger.Level.INFO;
            }

            public void setLevel(String logger, Level level) {
            }

            public boolean isLogLevelEnabled(Diagnostic diagnostic) {
                return logger.isEnabled(this.translate(diagnostic.getLevel()));
            }
        });
    }
}

