/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.renarde.security;

import io.quarkiverse.renarde.security.RenardeTenantProvider;
import io.quarkiverse.renarde.security.RenardeUser;
import io.quarkiverse.renarde.security.RenardeUserProvider;
import io.quarkiverse.renarde.util.Flash;
import io.quarkiverse.renarde.util.RedirectException;
import io.quarkus.security.identity.SecurityIdentity;
import io.smallrye.jwt.build.Jwt;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.core.NewCookie;
import jakarta.ws.rs.core.Response;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Set;
import org.eclipse.microprofile.config.inject.ConfigProperty;

@ApplicationScoped
public class RenardeSecurity {
    @ConfigProperty(name="mp.jwt.verify.issuer")
    String jwtIssuer;
    @ConfigProperty(name="mp.jwt.token.cookie")
    String jwtCookie;
    @Inject
    SecurityIdentity identity;
    @Inject
    RenardeTenantProvider tenantProvider;
    @Inject
    RenardeUserProvider userProvider;
    @Inject
    Flash flash;

    public NewCookie makeUserCookie(RenardeUser user) {
        Set<String> roles = user.roles();
        String token = Jwt.issuer((String)this.jwtIssuer).upn(user.userId()).groups(roles).expiresIn(Duration.ofDays(10L)).innerSign().encrypt();
        return new NewCookie(this.jwtCookie, token, "/", null, 1, null, -1, null, false, false);
    }

    public RenardeUser getUser() {
        if (!this.identity.isAnonymous()) {
            RenardeUser user;
            String name = this.identity.getPrincipal().getName();
            String tenantId = this.tenantProvider.getTenantId();
            if (tenantId == null) {
                tenantId = "manual";
            }
            if ((user = this.userProvider.findUser(tenantId, name)) == null) {
                this.flash.flash("message", (Object)("Invalid user: " + name));
                throw new RedirectException(this.makeLogoutResponse());
            }
            if (!user.registered()) {
                return null;
            }
            return user;
        }
        return null;
    }

    public Response makeLogoutResponse() {
        Set<String> tenants = this.tenantProvider.getTenants();
        ArrayList<NewCookie> cookies = new ArrayList<NewCookie>(tenants.size() + 1);
        cookies.add(new NewCookie("q_session", null, "/", null, null, 0, false, true));
        for (String tenant : tenants) {
            cookies.add(new NewCookie("q_session_" + tenant, null, "/", null, null, 0, false, true));
        }
        cookies.add(new NewCookie(this.jwtCookie, null, "/", null, null, 0, false, true));
        try {
            return Response.seeOther((URI)new URI("/")).cookie(cookies.toArray(new NewCookie[0])).build();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }
}

