/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.renarde.security.impl;

import io.quarkiverse.renarde.Controller;
import io.quarkiverse.renarde.security.LoginPage;
import io.quarkiverse.renarde.security.RenardeSecurity;
import io.quarkiverse.renarde.security.RenardeUserProvider;
import io.quarkiverse.renarde.security.RenardeUserWithPassword;
import io.quarkus.elytron.security.common.BcryptUtil;
import io.quarkus.qute.CheckedTemplate;
import io.quarkus.qute.TemplateInstance;
import jakarta.inject.Inject;
import jakarta.validation.constraints.NotBlank;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.NewCookie;
import jakarta.ws.rs.core.Response;
import java.net.URI;
import org.jboss.resteasy.reactive.RestCookie;
import org.jboss.resteasy.reactive.RestForm;

@Path(value="_renarde/security")
public class RenardeFormLoginController
extends Controller {
    @Inject
    RenardeSecurity security;
    @Inject
    RenardeUserProvider userProvider;

    @LoginPage
    public TemplateInstance login() {
        return Templates.login();
    }

    @POST
    public Response login(@NotBlank @RestForm String username, @NotBlank @RestForm String password, @RestCookie(value="quarkus-redirect-location") String quarkusRedirectLocation) {
        RenardeUserWithPassword user;
        if (this.validationFailed()) {
            this.login();
        }
        if ((user = (RenardeUserWithPassword)this.userProvider.findUser("manual", username)) == null) {
            this.validation.addError("username", "Unknown user");
        }
        if (this.validationFailed()) {
            this.login();
        }
        if (!BcryptUtil.matches((String)password, (String)user.password())) {
            this.validation.addError("username", "Unknown user");
        }
        if (this.validationFailed()) {
            this.login();
        }
        NewCookie cookie = this.security.makeUserCookie(user);
        String target = quarkusRedirectLocation != null ? quarkusRedirectLocation : "/";
        return Response.seeOther((URI)URI.create(target)).cookie(new NewCookie[]{cookie}).build();
    }

    @CheckedTemplate(basePath="_renarde/security")
    public static class Templates {
        public static native TemplateInstance login();
    }
}

